/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search.geo;

import org.elasticsearch.common.unit.DistanceUnit;

public class LatLng {
    private double lat;
    private double lng;
    private boolean normalized;

    public LatLng(double lat, double lng) {
        if (lat > 90.0 || lat < -90.0) {
            throw new IllegalArgumentException("Illegal latitude value " + lat);
        }
        this.lat = lat;
        this.lng = lng;
    }

    public boolean isNormalized() {
        return this.normalized || this.lng >= -180.0 && this.lng <= 180.0;
    }

    public LatLng normalize() {
        double newLng;
        if (this.isNormalized()) {
            return this;
        }
        double delta = 0.0;
        if (this.lng < 0.0) {
            delta = 360.0;
        } else if (this.lng >= 0.0) {
            delta = -360.0;
        }
        for (newLng = this.lng; newLng <= -180.0 || newLng >= 180.0; newLng += delta) {
        }
        LatLng ret = new LatLng(this.lat, newLng);
        ret.normalized = true;
        return ret;
    }

    public double getLat() {
        return this.lat;
    }

    public double getLng() {
        return this.lng;
    }

    public boolean equals(LatLng other) {
        return this.lat == other.getLat() && this.lng == other.getLng();
    }

    public boolean equals(Object other) {
        return other instanceof LatLng && this.equals((LatLng)other);
    }

    public double arcDistance(LatLng ll2) {
        return this.arcDistance(ll2, DistanceUnit.MILES);
    }

    public double arcDistance(LatLng ll2, DistanceUnit lUnits) {
        double radius;
        LatLng ll1 = this.normalize();
        ll2 = ll2.normalize();
        double lat1 = ll1.getLat();
        double lng1 = ll1.getLng();
        double lat2 = ll2.getLat();
        double lng2 = ll2.getLng();
        if (lat1 == lat2 && lng1 == lng2) {
            return 0.0;
        }
        double dLon = lng2 - lng1;
        double a = this.radians(90.0 - lat1);
        double c = this.radians(90.0 - lat2);
        double cosB = Math.cos(a) * Math.cos(c) + Math.sin(a) * Math.sin(c) * Math.cos(this.radians(dLon));
        double d = radius = lUnits == DistanceUnit.MILES ? 3963.205 : 6378.160187;
        if (cosB < -1.0) {
            return Math.PI * radius;
        }
        if (cosB >= 1.0) {
            return 0.0;
        }
        return Math.acos(cosB) * radius;
    }

    private double radians(double a) {
        return a * 0.01745329251994;
    }
}

