/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard.recovery;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.collect.Maps;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.store.StoreFileMetaData;

public class StartRecoveryRequest
implements Streamable {
    private ShardId shardId;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private boolean markAsRelocated;
    private Map<String, StoreFileMetaData> existingFiles;

    StartRecoveryRequest() {
    }

    public StartRecoveryRequest(ShardId shardId, DiscoveryNode sourceNode, DiscoveryNode targetNode, boolean markAsRelocated, Map<String, StoreFileMetaData> existingFiles) {
        this.shardId = shardId;
        this.sourceNode = sourceNode;
        this.targetNode = targetNode;
        this.markAsRelocated = markAsRelocated;
        this.existingFiles = existingFiles;
    }

    public ShardId shardId() {
        return this.shardId;
    }

    public DiscoveryNode sourceNode() {
        return this.sourceNode;
    }

    public DiscoveryNode targetNode() {
        return this.targetNode;
    }

    public boolean markAsRelocated() {
        return this.markAsRelocated;
    }

    public Map<String, StoreFileMetaData> existingFiles() {
        return this.existingFiles;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.shardId = ShardId.readShardId(in);
        this.sourceNode = DiscoveryNode.readNode(in);
        this.targetNode = DiscoveryNode.readNode(in);
        this.markAsRelocated = in.readBoolean();
        int size = in.readVInt();
        this.existingFiles = Maps.newHashMapWithExpectedSize(size);
        for (int i = 0; i < size; ++i) {
            StoreFileMetaData md = StoreFileMetaData.readStoreFileMetaData(in);
            this.existingFiles.put(md.name(), md);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.shardId.writeTo(out);
        this.sourceNode.writeTo(out);
        this.targetNode.writeTo(out);
        out.writeBoolean(this.markAsRelocated);
        out.writeVInt(this.existingFiles.size());
        for (StoreFileMetaData md : this.existingFiles.values()) {
            md.writeTo(out);
        }
    }
}

