/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.core.database.dialog;

import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.i18n.LanguageChoice;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.ui.core.database.dialog.DataOverrideHandler;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.ui.database.DatabaseConnectionDialog;
import org.pentaho.ui.xul.XulComponent;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;

public class XulDatabaseDialog {
    private static Class<?> PKG = XulDatabaseDialog.class;
    private DatabaseMeta databaseMeta;
    private ObjectId databaseMetaObjectId;
    protected Shell shell;
    private Shell parentShell;
    private String databaseName;
    private List<DatabaseMeta> databases;
    private boolean modalDialog;
    DataOverrideHandler dataHandler = null;
    private LogChannelInterface log;
    private static final String EVENT_ID = "dataHandler";
    private static final String MESSAGES = "org.pentaho.di.ui.core.database.dialog.messages.messages";
    private static final String DIALOG_FRAGMENT_FILE = "/feature_override.xul";
    private static final String FRAGMENT_ID = "test-button-box";
    private static final String EXTENDED_WIDGET_CLASSNAME = "org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox";
    private static final String EXTENDED_WIDGET_ID = "VARIABLETEXTBOX";
    private DatabaseConnectionDialog databaseDialogInstance;
    private XulDialog xulDialogComponent;

    public XulDatabaseDialog(Shell parent) {
        this.parentShell = parent;
        this.databases = null;
        this.log = new LogChannel((Object)"XulDatabaseDialog");
    }

    public String open() {
        if (this.databaseDialogInstance == null) {
            this.createDialog();
        }
        try {
            XulTree tree = (XulTree)this.xulDialogComponent.getDocument().getRootElement().getElementById("options-parameter-tree");
            tree.getRootChildren().removeAll();
            this.dataHandler.setData(this.databaseMeta);
            this.xulDialogComponent.show();
            this.databaseMeta = (DatabaseMeta)this.dataHandler.getData();
            if (this.databaseMeta != null) {
                this.databaseMeta.setObjectId(this.databaseMetaObjectId);
                this.databaseName = Const.isEmpty((String)this.databaseMeta.getName()) ? null : this.databaseMeta.getName();
            } else {
                this.databaseName = null;
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.parentShell, BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Dialog", (String[])new String[0]), e);
            return null;
        }
        return this.databaseName;
    }

    private void createDialog() {
        XulDomContainer container = null;
        try {
            this.databaseDialogInstance = new DatabaseConnectionDialog();
            this.databaseDialogInstance.registerClass(EXTENDED_WIDGET_ID, EXTENDED_WIDGET_CLASSNAME);
            container = this.databaseDialogInstance.getSwtInstance(this.parentShell);
            container.addEventHandler(EVENT_ID, DataOverrideHandler.class.getName());
            this.dataHandler = (DataOverrideHandler)container.getEventHandler(EVENT_ID);
            if (this.databaseMeta != null) {
                this.dataHandler.setData(this.databaseMeta);
            }
            this.dataHandler.setDatabases(this.databases);
            this.dataHandler.getControls();
        }
        catch (XulException e) {
            new ErrorDialog(this.parentShell, BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.HandleXul", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        try {
            XulComponent boxElement = container.getDocumentRoot().getElementById(FRAGMENT_ID);
            XulComponent parentElement = boxElement.getParent();
            ResourceBundle res = null;
            Locale primaryLocale = GlobalMessages.getLocale();
            Locale failOverLocale = LanguageChoice.getInstance().getFailoverLocale();
            try {
                res = GlobalMessages.getBundle((Locale)primaryLocale, (String)MESSAGES);
            }
            catch (MissingResourceException e) {
                try {
                    res = GlobalMessages.getBundle((Locale)failOverLocale, (String)MESSAGES);
                }
                catch (MissingResourceException e2) {
                    res = null;
                    this.log.logError(BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.ResourcesNotFound.Title", (String[])new String[0]), new Object[]{BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.ResourcesNotFound", (String[])new String[]{primaryLocale == null ? "" : primaryLocale.toString(), failOverLocale == null ? "" : failOverLocale.toString()}), e2});
                }
            }
            XulDomContainer fragmentContainer = null;
            String pkg = this.getClass().getPackage().getName().replace('.', '/');
            fragmentContainer = res != null ? container.loadFragment(pkg.concat(DIALOG_FRAGMENT_FILE), (Object)res) : container.loadFragment(pkg.concat(DIALOG_FRAGMENT_FILE));
            XulComponent newBox = fragmentContainer.getDocumentRoot().getFirstChild();
            parentElement.replaceChild(boxElement, newBox);
        }
        catch (Exception e) {
            new ErrorDialog(this.parentShell, BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.HandleXul", (String[])new String[0]), e);
            return;
        }
        try {
            this.xulDialogComponent = (XulDialog)container.getDocumentRoot().getRootElement();
            ((Shell)this.xulDialogComponent.getRootObject()).setImage(GUIResource.getInstance().getImageConnection());
            this.parentShell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent arg0) {
                    XulDatabaseDialog.this.xulDialogComponent.hide();
                }
            });
        }
        catch (Exception e) {
            new ErrorDialog(this.parentShell, BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XulDatabaseDialog.Error.Dialog", (String[])new String[0]), e);
            return;
        }
    }

    public void setDatabaseMeta(DatabaseMeta dbMeta) {
        this.databaseMeta = dbMeta;
        if (dbMeta != null) {
            this.databaseMetaObjectId = this.databaseMeta.getObjectId();
            this.databaseName = this.databaseMeta.getDisplayName();
        }
    }

    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public void setDatabases(List<DatabaseMeta> databases) {
        this.databases = databases;
    }

    public boolean isModalDialog() {
        return this.modalDialog;
    }

    public void setModalDialog(boolean modalDialog) {
        this.modalDialog = modalDialog;
    }
}

