/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.dialog;

import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterStringDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.repository.RepositoryDirectoryUI;
import org.pentaho.di.ui.repository.dialog.RepositoryDialogInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class SelectDirectoryDialog
extends Dialog {
    private static Class<?> PKG = RepositoryDialogInterface.class;
    private PropsUI props = PropsUI.getInstance();
    private Repository rep;
    private Shell shell;
    private Tree wTree;
    private TreeItem tiTree;
    private Button wOK;
    private Button wRefresh;
    private Button wCancel;
    private RepositoryDirectoryInterface selection;
    private Color dircolor;
    private RepositoryDirectoryInterface repositoryTree;
    private boolean readOnly;

    public SelectDirectoryDialog(Shell parent, int style, Repository rep) {
        super(parent, style);
        this.rep = rep;
        this.selection = null;
        this.readOnly = rep.getSecurityProvider().isReadOnly();
    }

    public RepositoryDirectoryInterface open() {
        this.dircolor = GUIResource.getInstance().getColorDirectory();
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageConnection());
        this.shell.setText(BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.Dialog.Main.Title", (String[])new String[0]));
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.wTree = new Tree((Composite)this.shell, 2052);
        this.props.setLook((Control)this.wTree);
        try {
            this.repositoryTree = this.rep.loadRepositoryDirectoryTree();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.Dialog.ErrorRefreshingDirectoryTree.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.Dialog.ErrorRefreshingDirectoryTree.Message", (String[])new String[0]), (Exception)((Object)e));
            return null;
        }
        if (!this.getData()) {
            return null;
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wRefresh = new Button((Composite)this.shell, 8);
        this.wRefresh.setText(BaseMessages.getString(PKG, (String)"System.Button.Refresh", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        FormData fdTree = new FormData();
        FormData fdOK = new FormData();
        FormData fdRefresh = new FormData();
        FormData fdCancel = new FormData();
        int margin = 10;
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, -50);
        this.wTree.setLayoutData((Object)fdTree);
        fdOK.left = new FormAttachment((Control)this.wTree, 0, 0x1000000);
        fdOK.bottom = new FormAttachment(100, -margin);
        this.wOK.setLayoutData((Object)fdOK);
        fdRefresh.left = new FormAttachment((Control)this.wOK, 10);
        fdRefresh.bottom = new FormAttachment(100, -margin);
        this.wRefresh.setLayoutData((Object)fdRefresh);
        fdCancel.left = new FormAttachment((Control)this.wRefresh, 10);
        fdCancel.bottom = new FormAttachment(100, -margin);
        this.wCancel.setLayoutData((Object)fdCancel);
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectDirectoryDialog.this.dispose();
            }
        });
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectDirectoryDialog.this.handleOK();
            }
        });
        this.wTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
                SelectDirectoryDialog.this.handleOK();
            }
        });
        this.wRefresh.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                SelectDirectoryDialog.this.getData();
            }
        });
        this.wTree.addMenuDetectListener(new MenuDetectListener(){

            public void menuDetected(MenuDetectEvent e) {
                SelectDirectoryDialog.this.setTreeMenu();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.selection;
    }

    private boolean getData() {
        if (this.tiTree != null && !this.tiTree.isDisposed()) {
            this.tiTree.dispose();
        }
        this.tiTree = new TreeItem(this.wTree, 0);
        this.tiTree.setImage(GUIResource.getInstance().getImageFolderConnections());
        RepositoryDirectoryUI.getDirectoryTree(this.tiTree, this.dircolor, this.repositoryTree);
        this.tiTree.setExpanded(true);
        return true;
    }

    public void setTreeMenu() {
        Menu mTree = null;
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            mTree = new Menu((Control)this.wTree);
            MenuItem miNew = new MenuItem(mTree, 64);
            miNew.setText(BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.PopupMenu.Directory.New", (String[])new String[0]));
            miNew.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!SelectDirectoryDialog.this.readOnly) {
                        TreeItem ti = SelectDirectoryDialog.this.wTree.getSelection()[0];
                        String[] str = ConstUI.getTreeStrings(ti);
                        RepositoryDirectoryInterface dir = SelectDirectoryDialog.this.repositoryTree.findDirectory(str);
                        if (dir != null) {
                            EnterStringDialog etd = new EnterStringDialog(SelectDirectoryDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.EnterDirectoryName.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.EnterDirectoryName.Message", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.EnterDirectoryName.Default", (String[])new String[0]));
                            String newdir = etd.open();
                            if (newdir != null) {
                                RepositoryDirectory subdir = new RepositoryDirectory(dir, newdir);
                                try {
                                    SelectDirectoryDialog.this.rep.saveRepositoryDirectory((RepositoryDirectoryInterface)subdir);
                                    dir.addSubdirectory((RepositoryDirectoryInterface)subdir);
                                    TreeItem tiNew = new TreeItem(ti, 0);
                                    tiNew.setText(newdir);
                                    tiNew.setImage(GUIResource.getInstance().getImageArrow());
                                    SelectDirectoryDialog.this.wTree.setSelection(new TreeItem[]{tiNew});
                                }
                                catch (Exception exception) {
                                    new ErrorDialog(SelectDirectoryDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.UnableToCreateDirectory.Message", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.UnableToCreateDirectory.Title", (String[])new String[0]), exception);
                                }
                            }
                        } else {
                            MessageBox mb = new MessageBox(SelectDirectoryDialog.this.shell, 33);
                            mb.setMessage(BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.UnableToLocateDirectory.Message", (String[])new String[0]));
                            mb.setText(BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.UnableToLocateDirectory.Title", (String[])new String[0]));
                            mb.open();
                        }
                    } else {
                        MessageBox mb = new MessageBox(SelectDirectoryDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.PermissionDenied.Message1", (String[])new String[0]) + (SelectDirectoryDialog.this.rep.getUserInfo() == null ? "" : SelectDirectoryDialog.this.rep.getUserInfo().getLogin()) + BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.PermissionDenied.Message2", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.PermissionDenied.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
            });
            MenuItem miRen = new MenuItem(mTree, 64);
            miRen.setText(BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.PopupMenu.Directory.Rename", (String[])new String[0]));
            miRen.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!SelectDirectoryDialog.this.readOnly) {
                        TreeItem ti = SelectDirectoryDialog.this.wTree.getSelection()[0];
                        String[] str = ConstUI.getTreeStrings(ti);
                        RepositoryDirectoryInterface dir = SelectDirectoryDialog.this.repositoryTree.findDirectory(str);
                        if (dir != null) {
                            String oldName = dir.getName();
                            EnterStringDialog etd = new EnterStringDialog(SelectDirectoryDialog.this.shell, oldName, BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.EnterDirectoryNewName.Message", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SelectDirectoryDialog.Dialog.EnterDirectoryNewName.Title", (String[])new String[0]));
                            String newName = etd.open();
                            if (newName != null && !newName.equals(oldName)) {
                                dir.setName(newName);
                                try {
                                    SelectDirectoryDialog.this.rep.renameRepositoryDirectory(dir.getObjectId(), dir.getParent(), newName);
                                    ti.setText(newName);
                                    SelectDirectoryDialog.this.wTree.setSelection(ti);
                                }
                                catch (Exception exception) {
                                    new ErrorDialog(SelectDirectoryDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Message1", (String[])new String[0]) + oldName + "]" + Const.CR + BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Message2", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Directory.Rename.UnexpectedError.Title", (String[])new String[0]), exception);
                                }
                            }
                        }
                    }
                }
            });
            MenuItem miDel = new MenuItem(mTree, 64);
            miDel.setText(BaseMessages.getString(PKG, (String)"SelectDirectoryDialog.PopupMenu.Directory.Delete", (String[])new String[0]));
            miDel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (!SelectDirectoryDialog.this.readOnly) {
                        TreeItem ti = SelectDirectoryDialog.this.wTree.getSelection()[0];
                        String[] str = ConstUI.getTreeStrings(ti);
                        RepositoryDirectoryInterface dir = SelectDirectoryDialog.this.repositoryTree.findDirectory(str);
                        if (dir != null) {
                            try {
                                SelectDirectoryDialog.this.rep.deleteRepositoryDirectory(dir);
                                ti.dispose();
                            }
                            catch (KettleException exception) {
                                new ErrorDialog(SelectDirectoryDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Directory.Delete.ErrorRemoving.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"RepositoryExplorerDialog.Directory.Delete.ErrorRemoving.Message1", (String[])new String[0]), (Exception)((Object)exception));
                            }
                        }
                    }
                }
            });
        }
        this.wTree.setMenu(mTree);
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void handleOK() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            String[] tree = ConstUI.getTreeStrings(ti[0]);
            this.selection = this.repositoryTree.findDirectory(tree);
            this.dispose();
        }
    }
}

