/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.repository.repositoryexplorer.model;

import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryContent;
import org.pentaho.di.ui.repository.repositoryexplorer.model.UIRepositoryDirectory;

public class UITransformation
extends UIRepositoryContent {
    private static final long serialVersionUID = 3826725834758429573L;
    private static final String REPOSITORY_PKG = "org.pentaho.di.ui.repository";

    public UITransformation() {
    }

    public UITransformation(RepositoryElementMetaInterface rc, UIRepositoryDirectory parent, Repository rep) {
        super(rc, parent, rep);
    }

    @Override
    public void setName(String name) throws Exception {
        this.renameTransformation(this.getObjectId(), this.getRepositoryDirectory(), name);
        super.setName(name);
        this.uiParent.fireCollectionChanged();
    }

    protected ObjectId renameTransformation(ObjectId objectId, RepositoryDirectory directory, String name) throws Exception {
        String comment = BaseMessages.getString((String)REPOSITORY_PKG, (String)"Repository.Rename", (String[])new String[]{super.getName(), name});
        return this.rep.renameTransformation(this.getObjectId(), comment, (RepositoryDirectoryInterface)this.getRepositoryDirectory(), name);
    }

    @Override
    public void delete() throws Exception {
        this.rep.deleteTransformation(this.getObjectId());
        if (this.uiParent.getRepositoryObjects().contains((Object)this)) {
            this.uiParent.getRepositoryObjects().remove((Object)this);
        }
    }

    @Override
    public void move(UIRepositoryDirectory newParentDir) throws KettleException {
        if (newParentDir != null) {
            this.rep.renameTransformation(this.obj.getObjectId(), (RepositoryDirectoryInterface)newParentDir.getDirectory(), null);
            newParentDir.refresh();
        }
    }
}

