/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.sql.ExecSQLMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class ExecSQLDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ExecSQLMeta.class;
    private CCombo wConnection;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlEachRow;
    private Button wEachRow;
    private Label wlSetParams;
    private Button wSetParams;
    private FormData fdlSetParams;
    private FormData fdSetParams;
    private Label wlSingleStatement;
    private Button wSingleStatement;
    private Label wlInsertField;
    private Text wInsertField;
    private FormData fdlInsertField;
    private FormData fdInsertField;
    private Label wlUpdateField;
    private Text wUpdateField;
    private FormData fdlUpdateField;
    private FormData fdUpdateField;
    private Label wlDeleteField;
    private Text wDeleteField;
    private FormData fdlDeleteField;
    private FormData fdDeleteField;
    private Label wlReadField;
    private Text wReadField;
    private FormData fdlReadField;
    private FormData fdReadField;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Label wlVariables;
    private Button wVariables;
    private FormData fdlVariables;
    private FormData fdVariables;
    private Label wlQuoteString;
    private Button wQuoteString;
    private FormData fdlQuoteString;
    private FormData fdQuoteString;
    private ExecSQLMeta input;
    private boolean changedInDialog;
    private Label wlPosition;
    private FormData fdlPosition;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public ExecSQLDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ExecSQLMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecSQLDialog.this.changedInDialog = true;
                ExecSQLDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.Shell.Label", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSQL = new Label((Composite)this.shell, 16384);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.SQL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wSQL = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.wSQL.addModifyListener(lsMod);
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ExecSQLDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ExecSQLDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                ExecSQLDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                ExecSQLDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                ExecSQLDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ExecSQLDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                ExecSQLDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                ExecSQLDialog.this.setPosition();
            }
        });
        this.wSQL.addLineStyleListener(new SQLValuesHighlight());
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.GetFields.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel, this.wGet}, margin, null);
        this.wlReadField = new Label((Composite)this.shell, 131072);
        this.wlReadField.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.ReadField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReadField);
        this.fdlReadField = new FormData();
        this.fdlReadField.left = new FormAttachment(middle, margin);
        this.fdlReadField.right = new FormAttachment(middle * 2, -margin);
        this.fdlReadField.bottom = new FormAttachment((Control)this.wOK, -3 * margin);
        this.wlReadField.setLayoutData((Object)this.fdlReadField);
        this.wReadField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wReadField);
        this.wReadField.addModifyListener(lsMod);
        this.fdReadField = new FormData();
        this.fdReadField.left = new FormAttachment(middle * 2, 0);
        this.fdReadField.bottom = new FormAttachment((Control)this.wOK, -3 * margin);
        this.fdReadField.right = new FormAttachment(100, 0);
        this.wReadField.setLayoutData((Object)this.fdReadField);
        this.wlDeleteField = new Label((Composite)this.shell, 131072);
        this.wlDeleteField.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.DeleteField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDeleteField);
        this.fdlDeleteField = new FormData();
        this.fdlDeleteField.left = new FormAttachment(middle, margin);
        this.fdlDeleteField.right = new FormAttachment(middle * 2, -margin);
        this.fdlDeleteField.bottom = new FormAttachment((Control)this.wReadField, -margin);
        this.wlDeleteField.setLayoutData((Object)this.fdlDeleteField);
        this.wDeleteField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDeleteField);
        this.wDeleteField.addModifyListener(lsMod);
        this.fdDeleteField = new FormData();
        this.fdDeleteField.left = new FormAttachment(middle * 2, 0);
        this.fdDeleteField.bottom = new FormAttachment((Control)this.wReadField, -margin);
        this.fdDeleteField.right = new FormAttachment(100, 0);
        this.wDeleteField.setLayoutData((Object)this.fdDeleteField);
        this.wlUpdateField = new Label((Composite)this.shell, 131072);
        this.wlUpdateField.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.UpdateField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlUpdateField);
        this.fdlUpdateField = new FormData();
        this.fdlUpdateField.left = new FormAttachment(middle, margin);
        this.fdlUpdateField.right = new FormAttachment(middle * 2, -margin);
        this.fdlUpdateField.bottom = new FormAttachment((Control)this.wDeleteField, -margin);
        this.wlUpdateField.setLayoutData((Object)this.fdlUpdateField);
        this.wUpdateField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wUpdateField);
        this.wUpdateField.addModifyListener(lsMod);
        this.fdUpdateField = new FormData();
        this.fdUpdateField.left = new FormAttachment(middle * 2, 0);
        this.fdUpdateField.bottom = new FormAttachment((Control)this.wDeleteField, -margin);
        this.fdUpdateField.right = new FormAttachment(100, 0);
        this.wUpdateField.setLayoutData((Object)this.fdUpdateField);
        this.wlInsertField = new Label((Composite)this.shell, 131072);
        this.wlInsertField.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.InsertField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInsertField);
        this.fdlInsertField = new FormData();
        this.fdlInsertField.left = new FormAttachment(middle, margin);
        this.fdlInsertField.right = new FormAttachment(middle * 2, -margin);
        this.fdlInsertField.bottom = new FormAttachment((Control)this.wUpdateField, -margin);
        this.wlInsertField.setLayoutData((Object)this.fdlInsertField);
        this.wInsertField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInsertField);
        this.wInsertField.addModifyListener(lsMod);
        this.fdInsertField = new FormData();
        this.fdInsertField.left = new FormAttachment(middle * 2, 0);
        this.fdInsertField.bottom = new FormAttachment((Control)this.wUpdateField, -margin);
        this.fdInsertField.right = new FormAttachment(100, 0);
        this.wInsertField.setLayoutData((Object)this.fdInsertField);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.right = new FormAttachment(middle, 0);
        this.fdlFields.bottom = new FormAttachment((Control)this.wInsertField, -25);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.input.getArguments().length;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ExecSQLDialog.ColumnInfo.ArgumentFieldname", (String[])new String[0]), 2, new String[]{""}, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(middle, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -3 * margin);
        this.wFields.setLayoutData(this.fdFields);
        this.wlEachRow = new Label((Composite)this.shell, 131072);
        this.wlEachRow.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.EachRow.Label", (String[])new String[0]));
        this.wlEachRow.pack();
        this.wlSingleStatement = new Label((Composite)this.shell, 131072);
        this.wlSingleStatement.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.SingleStatement.Label", (String[])new String[0]));
        this.wlSingleStatement.pack();
        this.wlVariables = new Label((Composite)this.shell, 131072);
        this.wlVariables.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.ReplaceVariables", (String[])new String[0]));
        this.wlVariables.pack();
        this.wlQuoteString = new Label((Composite)this.shell, 131072);
        this.wlQuoteString.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.QuoteString.Label", (String[])new String[0]));
        this.wlQuoteString.pack();
        Rectangle rEachRow = this.wlEachRow.getBounds();
        Rectangle rSingleStatement = this.wlSingleStatement.getBounds();
        Rectangle rVariables = this.wlVariables.getBounds();
        Rectangle rQuoteString = this.wlQuoteString.getBounds();
        int width = Math.max(Math.max(Math.max(rEachRow.width, rSingleStatement.width), rVariables.width), rQuoteString.width) + 30;
        this.props.setLook((Control)this.wlQuoteString);
        this.fdlQuoteString = new FormData();
        this.fdlQuoteString.left = new FormAttachment(0, margin);
        this.fdlQuoteString.right = new FormAttachment(0, width);
        this.fdlQuoteString.bottom = new FormAttachment((Control)this.wlFields, -2 * margin);
        this.wlQuoteString.setLayoutData((Object)this.fdlQuoteString);
        this.wQuoteString = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wQuoteString);
        this.wQuoteString.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.QuoteString.Tooltip", (String[])new String[0]));
        this.fdQuoteString = new FormData();
        this.fdQuoteString.left = new FormAttachment((Control)this.wlQuoteString, margin);
        this.fdQuoteString.bottom = new FormAttachment((Control)this.wlFields, -2 * margin);
        this.fdQuoteString.right = new FormAttachment(middle, 0);
        this.wQuoteString.setLayoutData((Object)this.fdQuoteString);
        this.wlSetParams = new Label((Composite)this.shell, 131072);
        this.wlSetParams.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.SetParams.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSetParams);
        this.fdlSetParams = new FormData();
        this.fdlSetParams.left = new FormAttachment(0, margin);
        this.fdlSetParams.bottom = new FormAttachment((Control)this.wQuoteString, -margin);
        this.fdlSetParams.right = new FormAttachment(0, width);
        this.wlSetParams.setLayoutData((Object)this.fdlSetParams);
        this.wSetParams = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSetParams);
        this.wSetParams.setToolTipText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.SetParams.Tooltip", (String[])new String[0]));
        this.fdSetParams = new FormData();
        this.fdSetParams.left = new FormAttachment((Control)this.wlSetParams, margin);
        this.fdSetParams.bottom = new FormAttachment((Control)this.wQuoteString, -margin);
        this.fdSetParams.right = new FormAttachment(middle, 0);
        this.wSetParams.setLayoutData((Object)this.fdSetParams);
        this.wSetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSQLDialog.this.setExecutedSetParams();
                ExecSQLDialog.this.input.setChanged();
            }
        });
        this.props.setLook((Control)this.wlVariables);
        this.fdlVariables = new FormData();
        this.fdlVariables.left = new FormAttachment(0, margin);
        this.fdlVariables.right = new FormAttachment(0, width);
        this.fdlVariables.bottom = new FormAttachment((Control)this.wSetParams, -margin);
        this.wlVariables.setLayoutData((Object)this.fdlVariables);
        this.wVariables = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wVariables);
        this.fdVariables = new FormData();
        this.fdVariables.left = new FormAttachment((Control)this.wlVariables, margin);
        this.fdVariables.bottom = new FormAttachment((Control)this.wSetParams, -margin);
        this.fdVariables.right = new FormAttachment(middle, 0);
        this.wVariables.setLayoutData((Object)this.fdVariables);
        this.props.setLook((Control)this.wlSingleStatement);
        FormData fdlSingleStatement = new FormData();
        fdlSingleStatement.left = new FormAttachment(0, margin);
        fdlSingleStatement.right = new FormAttachment(0, width);
        fdlSingleStatement.bottom = new FormAttachment((Control)this.wVariables, -margin);
        this.wlSingleStatement.setLayoutData((Object)fdlSingleStatement);
        this.wSingleStatement = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSingleStatement);
        FormData fdSingleStatement = new FormData();
        fdSingleStatement.left = new FormAttachment((Control)this.wlEachRow, margin);
        fdSingleStatement.bottom = new FormAttachment((Control)this.wVariables, -margin);
        fdSingleStatement.right = new FormAttachment(middle, 0);
        this.wSingleStatement.setLayoutData((Object)fdSingleStatement);
        this.props.setLook((Control)this.wlEachRow);
        FormData fdlEachRow = new FormData();
        fdlEachRow.left = new FormAttachment(0, margin);
        fdlEachRow.right = new FormAttachment(0, width);
        fdlEachRow.bottom = new FormAttachment((Control)this.wSingleStatement, -margin);
        this.wlEachRow.setLayoutData((Object)fdlEachRow);
        this.wEachRow = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wEachRow);
        FormData fdEachRow = new FormData();
        fdEachRow.left = new FormAttachment((Control)this.wlEachRow, margin);
        fdEachRow.bottom = new FormAttachment((Control)this.wSingleStatement, -margin);
        fdEachRow.right = new FormAttachment(middle, 0);
        this.wEachRow.setLayoutData((Object)fdEachRow);
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.fdlPosition.bottom = new FormAttachment((Control)this.wEachRow, -2 * margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wlSQL, margin);
        this.fdSQL.right = new FormAttachment(100, -2 * margin);
        this.fdSQL.bottom = new FormAttachment((Control)this.wlPosition, -margin);
        this.wSQL.setLayoutData(this.fdSQL);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = ExecSQLDialog.this.transMeta.findStep(ExecSQLDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = ExecSQLDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            ExecSQLDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        ExecSQLDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        ExecSQLDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ExecSQLDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                ExecSQLDialog.this.get();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ExecSQLDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wGet.addListener(13, this.lsGet);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExecSQLDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wEachRow.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecSQLDialog.this.setExecutedEachInputRow();
                ExecSQLDialog.this.input.setChanged();
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ExecSQLDialog.this.checkCancel(e);
            }
        });
        this.getData();
        this.setExecutedEachInputRow();
        this.changedInDialog = false;
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void setExecutedEachInputRow() {
        this.wlFields.setEnabled(this.wEachRow.getSelection());
        this.wFields.setEnabled(this.wEachRow.getSelection());
        this.wlSetParams.setEnabled(this.wEachRow.getSelection());
        this.wSetParams.setEnabled(this.wEachRow.getSelection());
        if (!this.wEachRow.getSelection()) {
            this.wSetParams.setSelection(this.wEachRow.getSelection());
        }
        this.wlQuoteString.setEnabled(this.wEachRow.getSelection());
        this.wQuoteString.setEnabled(this.wEachRow.getSelection());
        if (!this.wEachRow.getSelection()) {
            this.wQuoteString.setSelection(this.wEachRow.getSelection());
        }
    }

    private void setExecutedSetParams() {
        this.wlQuoteString.setEnabled(!this.wSetParams.getSelection());
        this.wQuoteString.setEnabled(!this.wSetParams.getSelection());
        if (this.wSetParams.getSelection()) {
            this.wQuoteString.setSelection(!this.wSetParams.getSelection());
        }
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getSql() != null) {
            this.wSQL.setText(this.input.getSql());
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        }
        this.wEachRow.setSelection(this.input.isExecutedEachInputRow());
        this.wSingleStatement.setSelection(this.input.isSingleStatement());
        this.wVariables.setSelection(this.input.isReplaceVariables());
        this.wQuoteString.setSelection(this.input.isQuoteString());
        if (this.input.getUpdateField() != null) {
            this.wUpdateField.setText(this.input.getUpdateField());
        }
        if (this.input.getInsertField() != null) {
            this.wInsertField.setText(this.input.getInsertField());
        }
        if (this.input.getDeleteField() != null) {
            this.wDeleteField.setText(this.input.getDeleteField());
        }
        if (this.input.getReadField() != null) {
            this.wReadField.setText(this.input.getReadField());
        }
        for (int i = 0; i < this.input.getArguments().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            if (this.input.getArguments()[i] == null) continue;
            item.setText(1, this.input.getArguments()[i]);
        }
        this.wSetParams.setSelection(this.input.isParams());
        this.wStepname.selectAll();
        this.wStepname.setFocus();
    }

    private void checkCancel(ShellEvent e) {
        if (this.changedInDialog) {
            int save = JobGraph.showChangedWarning(this.shell, this.wStepname.getText());
            if (save == 256) {
                e.doit = false;
            } else if (save == 64) {
                this.ok();
            } else {
                this.cancel();
            }
        } else {
            this.cancel();
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setSql(this.wSQL.getText());
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setExecutedEachInputRow(this.wEachRow.getSelection());
        this.input.setSingleStatement(this.wSingleStatement.getSelection());
        this.input.setVariableReplacementActive(this.wVariables.getSelection());
        this.input.setQuoteString(this.wQuoteString.getSelection());
        this.input.setParams(this.wSetParams.getSelection());
        this.input.setInsertField(this.wInsertField.getText());
        this.input.setUpdateField(this.wUpdateField.getText());
        this.input.setDeleteField(this.wDeleteField.getText());
        this.input.setReadField(this.wReadField.getText());
        int nrargs = this.wFields.nrNonEmpty();
        this.input.allocate(nrargs);
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecSQLDialog.Log.FoundArguments", (String[])new String[]{nrargs + ""}));
        }
        for (int i = 0; i < nrargs; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getArguments()[i] = item.getText(1);
        }
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ExecSQLDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ExecSQLDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExecSQLDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecSQLDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

