/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.univariatestats;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMeta;
import org.pentaho.di.trans.steps.univariatestats.UnivariateStatsMetaFunction;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class UnivariateStatsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = UnivariateStatsMeta.class;
    private Label m_wlStepname;
    private Text m_wStepname;
    private FormData m_fdlStepname;
    private FormData m_fdStepname;
    private Label m_wlFields;
    private TableView m_wFields;
    private FormData m_fdlFields;
    private FormData m_fdFields;
    private UnivariateStatsMeta m_currentMeta;
    private UnivariateStatsMeta m_originalMeta;
    private Map<String, Integer> m_inputFields;
    private ColumnInfo[] m_colinf;

    public UnivariateStatsDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.m_currentMeta = (UnivariateStatsMeta)in;
        this.m_originalMeta = (UnivariateStatsMeta)this.m_currentMeta.clone();
        this.m_inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.m_currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                UnivariateStatsDialog.this.m_currentMeta.setChanged();
            }
        };
        this.changed = this.m_currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.m_wlStepname = new Label((Composite)this.shell, 131072);
        this.m_wlStepname.setText(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.StepName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlStepname);
        this.m_fdlStepname = new FormData();
        this.m_fdlStepname.left = new FormAttachment(0, 0);
        this.m_fdlStepname.right = new FormAttachment(middle, -margin);
        this.m_fdlStepname.top = new FormAttachment(0, margin);
        this.m_wlStepname.setLayoutData((Object)this.m_fdlStepname);
        this.m_wStepname = new Text((Composite)this.shell, 18436);
        this.m_wStepname.setText(this.stepname);
        this.props.setLook((Control)this.m_wStepname);
        this.m_wStepname.addModifyListener(lsMod);
        this.m_fdStepname = new FormData();
        this.m_fdStepname.left = new FormAttachment(middle, 0);
        this.m_fdStepname.top = new FormAttachment(0, margin);
        this.m_fdStepname.right = new FormAttachment(100, 0);
        this.m_wStepname.setLayoutData((Object)this.m_fdStepname);
        this.m_wlFields = new Label((Composite)this.shell, 0);
        this.m_wlFields.setText(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.m_wlFields);
        this.m_fdlFields = new FormData();
        this.m_fdlFields.left = new FormAttachment(0, 0);
        this.m_fdlFields.top = new FormAttachment((Control)this.m_wStepname, margin);
        this.m_wlFields.setLayoutData((Object)this.m_fdlFields);
        int fieldsRows = this.m_currentMeta.getInputFieldMetaFunctions() != null ? this.m_currentMeta.getNumFieldsToProcess() : 1;
        this.m_colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.InputFieldColumn.Column", (String[])new String[0]), 2, new String[]{""}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.NColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.MeanColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.StdDevColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.MinColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.MaxColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.MedianColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.PercentileColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UnivariateStatsDialog.InterpolateColumn.Column", (String[])new String[0]), 2, new String[]{"True", "False"}, true)};
        this.m_wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.m_colinf, fieldsRows, lsMod, this.props);
        this.m_fdFields = new FormData();
        this.m_fdFields.left = new FormAttachment(0, 0);
        this.m_fdFields.top = new FormAttachment((Control)this.m_wlFields, margin);
        this.m_fdFields.right = new FormAttachment(100, 0);
        this.m_fdFields.bottom = new FormAttachment(100, -50);
        this.m_wFields.setLayoutData(this.m_fdFields);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                StepMeta stepMeta = UnivariateStatsDialog.this.transMeta.findStep(UnivariateStatsDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = UnivariateStatsDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            ValueMetaInterface field = row.getValueMeta(i);
                            if (!field.isNumeric()) continue;
                            UnivariateStatsDialog.this.m_inputFields.put(field.getName(), i);
                        }
                        UnivariateStatsDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        UnivariateStatsDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"UnivariateStatsDialog.Log.UnableToFindInput", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.m_wFields.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                UnivariateStatsDialog.this.shell.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        UnivariateStatsDialog.this.setComboBoxes();
                    }
                });
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                UnivariateStatsDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                UnivariateStatsDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                UnivariateStatsDialog.this.ok();
            }
        };
        this.m_wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                UnivariateStatsDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.m_currentMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        Set<String> keySet = this.m_inputFields.keySet();
        ArrayList<String> entries = new ArrayList<String>(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.m_colinf[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.m_currentMeta.getInputFieldMetaFunctions() != null) {
            for (int i = 0; i < this.m_currentMeta.getNumFieldsToProcess(); ++i) {
                UnivariateStatsMetaFunction fn = this.m_currentMeta.getInputFieldMetaFunctions()[i];
                TableItem item = this.m_wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)fn.getSourceFieldName(), (String)""));
                item.setText(2, Const.NVL((String)(fn.getCalcN() ? "True" : "False"), (String)""));
                item.setText(3, Const.NVL((String)(fn.getCalcMean() ? "True" : "False"), (String)""));
                item.setText(4, Const.NVL((String)(fn.getCalcStdDev() ? "True" : "False"), (String)""));
                item.setText(5, Const.NVL((String)(fn.getCalcMin() ? "True" : "False"), (String)""));
                item.setText(6, Const.NVL((String)(fn.getCalcMax() ? "True" : "False"), (String)""));
                item.setText(7, Const.NVL((String)(fn.getCalcMedian() ? "True" : "False"), (String)""));
                double p = fn.getCalcPercentile();
                NumberFormat pF = NumberFormat.getInstance();
                pF.setMaximumFractionDigits(2);
                String res = p < 0.0 ? "" : pF.format(p * 100.0);
                item.setText(8, Const.NVL((String)res, (String)""));
                item.setText(9, Const.NVL((String)(fn.getInterpolatePercentile() ? "True" : "False"), (String)""));
            }
            this.m_wFields.setRowNums();
            this.m_wFields.optWidth(true);
        }
        this.m_wStepname.selectAll();
        this.m_wStepname.setFocus();
    }

    private void cancel() {
        this.stepname = null;
        this.m_currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.m_wStepname.getText())) {
            return;
        }
        this.stepname = this.m_wStepname.getText();
        int nrNonEmptyFields = this.m_wFields.nrNonEmpty();
        this.m_currentMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.m_wFields.getNonEmpty(i);
            String inputFieldName = item.getText(1);
            boolean n = item.getText(2).equalsIgnoreCase("True");
            boolean mean = item.getText(3).equalsIgnoreCase("True");
            boolean stdDev = item.getText(4).equalsIgnoreCase("True");
            boolean min = item.getText(5).equalsIgnoreCase("True");
            boolean max = item.getText(6).equalsIgnoreCase("True");
            boolean median = item.getText(7).equalsIgnoreCase("True");
            String percentileS = item.getText(8);
            double percentile = -1.0;
            if (percentileS.length() > 0) {
                try {
                    percentile = Double.parseDouble(percentileS);
                    if (percentile < 0.0) {
                        percentile = -1.0;
                    } else if (percentile > 1.0 && percentile <= 100.0) {
                        percentile /= 100.0;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            boolean interpolate = item.getText(9).equalsIgnoreCase("True");
            this.m_currentMeta.getInputFieldMetaFunctions()[i] = new UnivariateStatsMetaFunction(inputFieldName, n, mean, stdDev, min, max, median, percentile, interpolate);
        }
        if (!this.m_originalMeta.equals((Object)this.m_currentMeta)) {
            this.m_currentMeta.setChanged();
            this.changed = this.m_currentMeta.hasChanged();
        }
        this.dispose();
    }
}

