/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.org.jets3t.service.model;

import com.cloudera.com.jamesmurty.utils.XMLBuilder;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;

public class WebsiteConfig {
    private String indexDocumentSuffix = null;
    private String errorDocumentKey = null;

    public WebsiteConfig(String indexDocumentSuffix, String errorDocumentKey) {
        this.indexDocumentSuffix = indexDocumentSuffix;
        this.errorDocumentKey = errorDocumentKey;
    }

    public WebsiteConfig(String indexDocumentSuffix) {
        this(indexDocumentSuffix, null);
    }

    public String getIndexDocumentSuffix() {
        return this.indexDocumentSuffix;
    }

    public String getErrorDocumentKey() {
        return this.errorDocumentKey;
    }

    public boolean isWebsiteConfigActive() {
        return this.indexDocumentSuffix != null;
    }

    public String toXml() throws ParserConfigurationException, FactoryConfigurationError, TransformerException {
        XMLBuilder builder = XMLBuilder.create("WebsiteConfiguration").attr("xmlns", "http://s3.amazonaws.com/doc/2006-03-01/").elem("IndexDocument").elem("Suffix").text(this.indexDocumentSuffix).up().up();
        if (this.errorDocumentKey != null && this.errorDocumentKey.length() > 0) {
            builder.elem("ErrorDocument").elem("Key").text(this.errorDocumentKey);
        }
        return builder.asString();
    }
}

