/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.base;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.AttributesInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.changed.ChangedFlag;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.listeners.ContentChangedListener;
import org.pentaho.di.core.listeners.FilenameChangedListener;
import org.pentaho.di.core.listeners.NameChangedListener;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.parameters.DuplicateParamException;
import org.pentaho.di.core.parameters.NamedParams;
import org.pentaho.di.core.parameters.NamedParamsDefault;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.repository.HasRepositoryInterface;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectory;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.shared.SharedObjects;
import org.pentaho.di.trans.HasDatabasesInterface;
import org.pentaho.di.trans.HasSlaveServersInterface;
import org.pentaho.metastore.api.IMetaStore;

public abstract class AbstractMeta
extends ChangedFlag
implements UndoInterface,
HasDatabasesInterface,
VariableSpace,
EngineMetaInterface,
NamedParams,
HasSlaveServersInterface,
AttributesInterface,
HasRepositoryInterface,
LoggingObjectInterface {
    public static final int TYPE_UNDO_CHANGE = 1;
    public static final int TYPE_UNDO_NEW = 2;
    public static final int TYPE_UNDO_DELETE = 3;
    public static final int TYPE_UNDO_POSITION = 4;
    protected ObjectId objectId;
    protected ObjectRevision objectRevision;
    protected String containerObjectId;
    protected String name;
    protected String description;
    protected String extendedDescription;
    protected String filename;
    protected RepositoryDirectoryInterface directory;
    protected Repository repository;
    protected List<DatabaseMeta> databases;
    protected List<NameChangedListener> nameChangedListeners;
    protected List<FilenameChangedListener> filenameChangedListeners;
    protected List<ContentChangedListener> contentChangedListeners;
    protected List<SlaveServer> slaveServers;
    protected List<NotePadMeta> notes;
    protected ChannelLogTable channelLogTable;
    protected boolean changedNotes;
    protected boolean changedDatabases;
    protected List<TransAction> undo;
    protected Map<String, Map<String, String>> attributesMap;
    protected VariableSpace variables = new Variables();
    protected NamedParams namedParams = new NamedParamsDefault();
    protected LogLevel logLevel = DefaultLogLevel.getLogLevel();
    protected IMetaStore metaStore;
    protected String createdUser;
    protected String modifiedUser;
    protected Date createdDate;
    protected Date modifiedDate;
    protected String sharedObjectsFile;
    protected SharedObjects sharedObjects;
    protected int max_undo;
    protected int undo_position;

    public ObjectId getObjectId() {
        return this.objectId;
    }

    @Override
    public void setObjectId(ObjectId objectId) {
        this.objectId = objectId;
    }

    public String getContainerObjectId() {
        return this.containerObjectId;
    }

    public void setCarteObjectId(String containerObjectId) {
        this.containerObjectId = containerObjectId;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.fireNameChangedListeners(this.name, newName);
        this.name = newName;
        this.setInternalNameKettleVariable(this.variables);
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getExtendedDescription() {
        return this.extendedDescription;
    }

    public void setExtendedDescription(String extendedDescription) {
        this.extendedDescription = extendedDescription;
    }

    @Override
    public void nameFromFilename() {
        if (!Const.isEmpty((String)this.filename)) {
            this.setName(Const.createName((String)this.filename));
        }
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public void setFilename(String newFilename) {
        this.fireFilenameChangedListeners(this.filename, newFilename);
        this.filename = newFilename;
        this.setInternalFilenameKettleVariables(this.variables);
    }

    @Override
    public RepositoryDirectoryInterface getRepositoryDirectory() {
        return this.directory;
    }

    public void setRepositoryDirectory(RepositoryDirectoryInterface directory) {
        this.directory = directory;
        this.setInternalKettleVariables();
    }

    @Override
    public Repository getRepository() {
        return this.repository;
    }

    @Override
    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    @Override
    public void setInternalKettleVariables() {
        this.setInternalKettleVariables(this.variables);
    }

    public abstract void setInternalKettleVariables(VariableSpace var1);

    protected abstract void setInternalFilenameKettleVariables(VariableSpace var1);

    @Override
    public DatabaseMeta findDatabase(String name) {
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if ((ci == null || !ci.getName().equalsIgnoreCase(name)) && !ci.getDisplayName().equalsIgnoreCase(name)) continue;
            return ci;
        }
        return null;
    }

    @Override
    public int nrDatabases() {
        return this.databases.size();
    }

    @Override
    public DatabaseMeta getDatabase(int i) {
        return this.databases.get(i);
    }

    public void addNameChangedListener(NameChangedListener listener) {
        if (this.nameChangedListeners == null) {
            this.nameChangedListeners = new ArrayList<NameChangedListener>();
        }
        this.nameChangedListeners.add(listener);
    }

    public void removeNameChangedListener(NameChangedListener listener) {
        this.nameChangedListeners.remove(listener);
    }

    protected void fireNameChangedListeners(String oldName, String newName) {
        if (this.nameChanged(oldName, newName) && this.nameChangedListeners != null) {
            for (NameChangedListener listener : this.nameChangedListeners) {
                listener.nameChanged(this, oldName, newName);
            }
        }
    }

    public void addFilenameChangedListener(FilenameChangedListener listener) {
        if (this.filenameChangedListeners == null) {
            this.filenameChangedListeners = new ArrayList<FilenameChangedListener>();
        }
        this.filenameChangedListeners.add(listener);
    }

    public void removeFilenameChangedListener(FilenameChangedListener listener) {
        this.filenameChangedListeners.remove(listener);
    }

    protected void fireFilenameChangedListeners(String oldFilename, String newFilename) {
        if (this.nameChanged(oldFilename, newFilename) && this.filenameChangedListeners != null) {
            for (FilenameChangedListener listener : this.filenameChangedListeners) {
                listener.filenameChanged(this, oldFilename, newFilename);
            }
        }
    }

    public void addContentChangedListener(ContentChangedListener listener) {
        if (this.contentChangedListeners == null) {
            this.contentChangedListeners = new ArrayList<ContentChangedListener>();
        }
        this.contentChangedListeners.add(listener);
    }

    public void removeContentChangedListener(ContentChangedListener listener) {
        this.contentChangedListeners.remove(listener);
    }

    protected void fireContentChangedListeners() {
        this.fireContentChangedListeners(true);
    }

    protected void fireContentChangedListeners(boolean ch) {
        block4: {
            if (this.contentChangedListeners == null) break block4;
            if (ch) {
                for (ContentChangedListener listener : this.contentChangedListeners) {
                    listener.contentChanged(this);
                }
            } else {
                for (ContentChangedListener listener : this.contentChangedListeners) {
                    listener.contentSafe(this);
                }
            }
        }
    }

    public void addOrReplaceSlaveServer(SlaveServer slaveServer) {
        int index = this.slaveServers.indexOf(slaveServer);
        if (index < 0) {
            this.slaveServers.add(slaveServer);
        } else {
            SlaveServer previous = this.slaveServers.get(index);
            previous.replaceMeta(slaveServer);
        }
        this.setChanged();
    }

    @Override
    public List<SlaveServer> getSlaveServers() {
        return this.slaveServers;
    }

    public void setSlaveServers(List<SlaveServer> slaveServers) {
        this.slaveServers = slaveServers;
    }

    public SlaveServer findSlaveServer(String serverString) {
        return SlaveServer.findSlaveServer(this.slaveServers, serverString);
    }

    public String[] getSlaveServerNames() {
        return SlaveServer.getSlaveServerNames(this.slaveServers);
    }

    @Override
    public void addUndo(Object[] from, Object[] to, int[] pos, Point[] prev, Point[] curr, int type_of_change, boolean nextAlso) {
        while (this.undo.size() > this.undo_position + 1 && this.undo.size() > 0) {
            int last = this.undo.size() - 1;
            this.undo.remove(last);
        }
        TransAction ta = new TransAction();
        switch (type_of_change) {
            case 1: {
                ta.setChanged(from, to, pos);
                break;
            }
            case 3: {
                ta.setDelete(from, pos);
                break;
            }
            case 2: {
                ta.setNew(from, pos);
                break;
            }
            case 4: {
                ta.setPosition(from, pos, prev, curr);
                break;
            }
        }
        this.undo.add(ta);
        ++this.undo_position;
        if (this.undo.size() > this.max_undo) {
            this.undo.remove(0);
            --this.undo_position;
        }
    }

    public void clearUndo() {
        this.undo = new ArrayList<TransAction>();
        this.undo_position = -1;
    }

    @Override
    public TransAction nextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        ++this.undo_position;
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewNextUndo() {
        int size = this.undo.size();
        if (size == 0 || this.undo_position >= size - 1) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position + 1);
        return retval;
    }

    @Override
    public TransAction previousUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        --this.undo_position;
        return retval;
    }

    @Override
    public TransAction viewThisUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public TransAction viewPreviousUndo() {
        if (this.undo.isEmpty() || this.undo_position < 0) {
            return null;
        }
        TransAction retval = this.undo.get(this.undo_position);
        return retval;
    }

    @Override
    public int getMaxUndo() {
        return this.max_undo;
    }

    @Override
    public void setMaxUndo(int mu) {
        this.max_undo = mu;
        while (this.undo.size() > mu && this.undo.size() > 0) {
            this.undo.remove(0);
        }
    }

    public int getUndoSize() {
        if (this.undo == null) {
            return 0;
        }
        return this.undo.size();
    }

    public void setAttributesMap(Map<String, Map<String, String>> attributesMap) {
        this.attributesMap = attributesMap;
    }

    public Map<String, Map<String, String>> getAttributesMap() {
        return this.attributesMap;
    }

    public void setAttribute(String groupName, String key, String value) {
        Map<String, String> attributes = this.getAttributes(groupName);
        if (attributes == null) {
            attributes = new HashMap<String, String>();
            this.attributesMap.put(groupName, attributes);
        }
        attributes.put(key, value);
    }

    public void setAttributes(String groupName, Map<String, String> attributes) {
        this.attributesMap.put(groupName, attributes);
    }

    public Map<String, String> getAttributes(String groupName) {
        return this.attributesMap.get(groupName);
    }

    public String getAttribute(String groupName, String key) {
        Map<String, String> attributes = this.attributesMap.get(groupName);
        if (attributes == null) {
            return null;
        }
        return attributes.get(key);
    }

    public void addNote(int p, NotePadMeta ni) {
        this.notes.add(p, ni);
        this.changedNotes = true;
    }

    public void addNote(NotePadMeta ni) {
        this.notes.add(ni);
        this.changedNotes = true;
    }

    public NotePadMeta getNote(int x, int y) {
        int s = this.notes.size();
        for (int i = s - 1; i >= 0; --i) {
            NotePadMeta ni = this.notes.get(i);
            Point loc = ni.getLocation();
            Point p = new Point(loc.x, loc.y);
            if (x < p.x || x > p.x + ni.width + 10 || y < p.y || y > p.y + ni.height + 10) continue;
            return ni;
        }
        return null;
    }

    public NotePadMeta getNote(int i) {
        return this.notes.get(i);
    }

    public List<NotePadMeta> getNotes() {
        return this.notes;
    }

    public List<NotePadMeta> getSelectedNotes() {
        ArrayList<NotePadMeta> selection = new ArrayList<NotePadMeta>();
        for (NotePadMeta note : this.notes) {
            if (!note.isSelected()) continue;
            selection.add(note);
        }
        return selection;
    }

    public int indexOfNote(NotePadMeta ni) {
        return this.notes.indexOf(ni);
    }

    public void lowerNote(int p) {
        if (p > 0 && p < this.notes.size()) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(0, note);
            this.changedNotes = true;
        }
    }

    public int nrNotes() {
        return this.notes.size();
    }

    public void raiseNote(int p) {
        if (p >= 0 && p < this.notes.size() - 1) {
            NotePadMeta note = this.notes.remove(p);
            this.notes.add(note);
            this.changedNotes = true;
        }
    }

    public void removeNote(int i) {
        if (i < 0 || i >= this.notes.size()) {
            return;
        }
        this.notes.remove(i);
        this.changedNotes = true;
    }

    public boolean haveNotesChanged() {
        if (this.changedNotes) {
            return true;
        }
        for (int i = 0; i < this.nrNotes(); ++i) {
            NotePadMeta note = this.getNote(i);
            if (!note.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public int[] getNoteIndexes(List<NotePadMeta> notes) {
        int[] retval = new int[notes.size()];
        for (int i = 0; i < notes.size(); ++i) {
            retval[i] = this.indexOfNote(notes.get(i));
        }
        return retval;
    }

    public ChannelLogTable getChannelLogTable() {
        return this.channelLogTable;
    }

    @Override
    public void addOrReplaceDatabase(DatabaseMeta databaseMeta) {
        int index = this.databases.indexOf(databaseMeta);
        if (index < 0) {
            this.addDatabase(databaseMeta);
        } else {
            DatabaseMeta previous = this.getDatabase(index);
            previous.replaceMeta(databaseMeta);
        }
        this.changedDatabases = true;
    }

    @Override
    public void addDatabase(DatabaseMeta ci) {
        this.databases.add(ci);
        Collections.sort(this.databases, DatabaseMeta.comparator);
        this.changedDatabases = true;
    }

    @Override
    public void addDatabase(int p, DatabaseMeta ci) {
        this.databases.add(p, ci);
        this.changedDatabases = true;
    }

    @Override
    public List<DatabaseMeta> getDatabases() {
        return this.databases;
    }

    public String[] getDatabaseNames() {
        String[] names = new String[this.databases.size()];
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.databases.get(i).getName();
        }
        return names;
    }

    @Override
    public int indexOfDatabase(DatabaseMeta di) {
        return this.databases.indexOf(di);
    }

    @Override
    public void setDatabases(List<DatabaseMeta> databases) {
        Collections.sort(databases, DatabaseMeta.comparator);
        this.databases = databases;
    }

    @Override
    public boolean haveConnectionsChanged() {
        if (this.changedDatabases) {
            return true;
        }
        for (int i = 0; i < this.nrDatabases(); ++i) {
            DatabaseMeta ci = this.getDatabase(i);
            if (!ci.hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void removeDatabase(int i) {
        if (i < 0 || i >= this.databases.size()) {
            return;
        }
        this.databases.remove(i);
        this.changedDatabases = true;
    }

    public void clearChangedDatabases() {
        this.changedDatabases = false;
        for (int i = 0; i < this.nrDatabases(); ++i) {
            this.getDatabase(i).setChanged(false);
        }
    }

    public void setChannelLogTable(ChannelLogTable channelLogTable) {
        this.channelLogTable = channelLogTable;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Const.isEmpty((String)variableName) && !Const.isEmpty((String)(value = this.environmentSubstitute(variableName)))) {
            return ValueMeta.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void addParameterDefinition(String key, String defValue, String description) throws DuplicateParamException {
        this.namedParams.addParameterDefinition(key, defValue, description);
    }

    public String getParameterDescription(String key) throws UnknownParamException {
        return this.namedParams.getParameterDescription(key);
    }

    public String getParameterDefault(String key) throws UnknownParamException {
        return this.namedParams.getParameterDefault(key);
    }

    public String getParameterValue(String key) throws UnknownParamException {
        return this.namedParams.getParameterValue(key);
    }

    public String[] listParameters() {
        return this.namedParams.listParameters();
    }

    public void setParameterValue(String key, String value) throws UnknownParamException {
        this.namedParams.setParameterValue(key, value);
    }

    public void eraseParameters() {
        this.namedParams.eraseParameters();
    }

    public void clearParameters() {
        this.namedParams.clearParameters();
    }

    public void copyParametersFrom(NamedParams params) {
        this.namedParams.copyParametersFrom(params);
    }

    public void activateParameters() {
        String[] keys;
        for (String key : keys = this.listParameters()) {
            String defValue;
            String value;
            try {
                value = this.getParameterValue(key);
            }
            catch (UnknownParamException e) {
                value = "";
            }
            try {
                defValue = this.getParameterDefault(key);
            }
            catch (UnknownParamException e) {
                defValue = "";
            }
            if (Const.isEmpty((String)value)) {
                this.setVariable(key, defValue);
                continue;
            }
            this.setVariable(key, value);
        }
    }

    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public IMetaStore getMetaStore() {
        return this.metaStore;
    }

    public void setMetaStore(IMetaStore metaStore) {
        this.metaStore = metaStore;
    }

    public String getSharedObjectsFile() {
        return this.sharedObjectsFile;
    }

    public void setSharedObjectsFile(String sharedObjectsFile) {
        this.sharedObjectsFile = sharedObjectsFile;
    }

    public SharedObjects getSharedObjects() {
        return this.sharedObjects;
    }

    public void setSharedObjects(SharedObjects sharedObjects) {
        this.sharedObjects = sharedObjects;
    }

    protected abstract void setInternalNameKettleVariable(VariableSpace var1);

    @Override
    public Date getCreatedDate() {
        return this.createdDate;
    }

    @Override
    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    @Override
    public void setCreatedUser(String createdUser) {
        this.createdUser = createdUser;
    }

    @Override
    public String getCreatedUser() {
        return this.createdUser;
    }

    @Override
    public void setModifiedDate(Date modifiedDate) {
        this.modifiedDate = modifiedDate;
    }

    @Override
    public Date getModifiedDate() {
        return this.modifiedDate;
    }

    @Override
    public void setModifiedUser(String modifiedUser) {
        this.modifiedUser = modifiedUser;
    }

    @Override
    public String getModifiedUser() {
        return this.modifiedUser;
    }

    public void clear() {
        this.setName(null);
        this.setFilename(null);
        this.notes = new ArrayList<NotePadMeta>();
        this.databases = new ArrayList<DatabaseMeta>();
        this.slaveServers = new ArrayList<SlaveServer>();
        this.channelLogTable = ChannelLogTable.getDefault(this, this);
        this.attributesMap = new HashMap<String, Map<String, String>>();
        this.max_undo = 100;
        this.clearUndo();
        this.clearChanged();
        this.setChanged(false);
        this.channelLogTable = ChannelLogTable.getDefault(this, this);
        this.createdUser = "-";
        this.createdDate = new Date();
        this.modifiedUser = "-";
        this.modifiedDate = new Date();
        this.directory = new RepositoryDirectory();
        this.description = null;
        this.extendedDescription = null;
    }

    @Override
    public void clearChanged() {
        this.clearChangedDatabases();
        this.changedNotes = false;
        for (int i = 0; i < this.nrNotes(); ++i) {
            this.getNote(i).setChanged(false);
        }
        super.clearChanged();
    }

    @Override
    public void setChanged(boolean ch) {
        if (ch) {
            this.setChanged();
        } else {
            this.clearChanged();
        }
        this.fireContentChangedListeners(ch);
    }

    @Override
    public boolean canSave() {
        return true;
    }

    @Override
    public boolean hasChanged() {
        if (super.hasChanged()) {
            return true;
        }
        if (this.haveConnectionsChanged()) {
            return true;
        }
        return this.haveNotesChanged();
    }

    public Date getRegistrationDate() {
        return null;
    }

    public LoggingObjectInterface getParent() {
        return null;
    }

    public String getObjectName() {
        return this.getName();
    }

    public String getObjectCopy() {
        return null;
    }

    public ObjectRevision getObjectRevision() {
        return this.objectRevision;
    }

    public void setObjectRevision(ObjectRevision objectRevision) {
        this.objectRevision = objectRevision;
    }

    private boolean nameChanged(String oldName, String newName) {
        if (oldName == null && newName == null) {
            return false;
        }
        if (oldName == null && newName != null) {
            return true;
        }
        return oldName.equals(newName);
    }

    protected boolean shouldOverwrite(OverwritePrompter prompter, Props props, String message, String rememberMessage) {
        boolean overwrite;
        boolean askOverwrite = Props.isInitialized() ? props.askAboutReplacingDatabaseConnections() : false;
        boolean bl = overwrite = Props.isInitialized() ? props.replaceExistingDatabaseConnections() : true;
        if (askOverwrite && prompter != null) {
            overwrite = prompter.overwritePrompt(message, rememberMessage, "AskAboutReplacingDatabases");
        }
        return overwrite;
    }
}

