/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ftpsget;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.ftp4che.util.ftpfile.FTPFile;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ftpsget.FTPSConnection;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class JobEntryFTPSGet
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private static Class<?> PKG = JobEntryFTPSGet.class;
    private String serverName = null;
    private String userName;
    private String password;
    private String FTPSDirectory;
    private String targetDirectory;
    private String wildcard;
    private boolean binaryMode;
    private int timeout;
    private boolean remove;
    private boolean onlyGettingNewFiles;
    private boolean activeConnection;
    private boolean movefiles = false;
    private String movetodirectory = null;
    private boolean adddate = false;
    private boolean addtime = false;
    private boolean SpecifyFormat = false;
    private String date_time_format;
    private boolean AddDateBeforeExtension = false;
    private boolean isaddresult = true;
    private boolean createmovefolder = false;
    private String port = "21";
    private String proxyHost;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private int connectionType = 0;
    public int ifFileExistsSkip = 0;
    public String SifFileExistsSkip = "ifFileExistsSkip";
    public int ifFileExistsCreateUniq = 1;
    public String SifFileExistsCreateUniq = "ifFileExistsCreateUniq";
    public int ifFileExistsFail = 2;
    public String SifFileExistsFail = "ifFileExistsFail";
    public int ifFileExists;
    public String SifFileExists;
    public String SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String nr_limit = "10";
    private String success_condition = this.SUCCESS_IF_NO_ERRORS;
    long NrErrors = 0L;
    long NrfilesRetrieved = 0L;
    boolean successConditionBroken = false;
    int limitFiles = 0;
    String localFolder = null;
    String realMoveToFolder = null;
    static String FILE_SEPARATOR = "/";

    public JobEntryFTPSGet(String n) {
        super(n, "");
        this.ifFileExists = this.ifFileExistsSkip;
        this.SifFileExists = this.SifFileExistsSkip;
    }

    public JobEntryFTPSGet() {
        this("");
    }

    @Override
    public Object clone() {
        JobEntryFTPSGet je = (JobEntryFTPSGet)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"port", (String)this.port));
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"FTPSdirectory", (String)this.FTPSDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"binary", (boolean)this.binaryMode));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"remove", (boolean)this.remove));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"active", (boolean)this.activeConnection));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movefiles", (boolean)this.movefiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"AddDateBeforeExtension", (boolean)this.AddDateBeforeExtension));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isaddresult", (boolean)this.isaddresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createmovefolder", (boolean)this.createmovefolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_host", (String)this.proxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_port", (String)this.proxyPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_username", (String)this.proxyUsername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"proxy_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ifFileExists", (String)this.SifFileExists));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit", (String)this.nr_limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"connection_type", (String)FTPSConnection.getConnectionTypeCode(this.connectionType)));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep, IMetaStore metaStore) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.port = XMLHandler.getTagValue((Node)entrynode, (String)"port");
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.FTPSDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"FTPSdirectory");
            this.targetDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.binaryMode = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"binary"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)10000);
            this.remove = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"remove"));
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.activeConnection = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"active"));
            this.movefiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"movefiles"));
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.AddDateBeforeExtension = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"AddDateBeforeExtension"));
            String addresult = XMLHandler.getTagValue((Node)entrynode, (String)"isaddresult");
            this.isaddresult = Const.isEmpty((String)addresult) ? true : "Y".equalsIgnoreCase(addresult);
            this.createmovefolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createmovefolder"));
            this.proxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_host");
            this.proxyPort = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_port");
            this.proxyUsername = XMLHandler.getTagValue((Node)entrynode, (String)"proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"proxy_password"));
            this.SifFileExists = XMLHandler.getTagValue((Node)entrynode, (String)"ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.success_condition = Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
            this.connectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)XMLHandler.getTagValue((Node)entrynode, (String)"connection_type"), (String)""));
        }
        catch (Exception xe) {
            throw new KettleXMLException("Unable to load job entry of type 'FTPS' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, IMetaStore metaStore, ObjectId id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            this.port = rep.getJobEntryAttributeString(id_jobentry, "port");
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.FTPSDirectory = rep.getJobEntryAttributeString(id_jobentry, "FTPSdirectory");
            this.targetDirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.binaryMode = rep.getJobEntryAttributeBoolean(id_jobentry, "binary");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.remove = rep.getJobEntryAttributeBoolean(id_jobentry, "remove");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.activeConnection = rep.getJobEntryAttributeBoolean(id_jobentry, "active");
            this.movefiles = rep.getJobEntryAttributeBoolean(id_jobentry, "movefiles");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.AddDateBeforeExtension = rep.getJobEntryAttributeBoolean(id_jobentry, "AddDateBeforeExtension");
            String addToResult = rep.getStepAttributeString(id_jobentry, "add_to_result_filenames");
            this.isaddresult = Const.isEmpty((String)addToResult) ? true : rep.getStepAttributeBoolean(id_jobentry, "add_to_result_filenames");
            this.createmovefolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createmovefolder");
            this.proxyHost = rep.getJobEntryAttributeString(id_jobentry, "proxy_host");
            this.proxyPort = rep.getJobEntryAttributeString(id_jobentry, "proxy_port");
            this.proxyUsername = rep.getJobEntryAttributeString(id_jobentry, "proxy_username");
            this.proxyPassword = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "proxy_password"));
            this.SifFileExists = rep.getJobEntryAttributeString(id_jobentry, "ifFileExists");
            this.ifFileExists = Const.isEmpty((String)this.SifFileExists) ? this.ifFileExistsSkip : (this.SifFileExists.equals(this.SifFileExistsCreateUniq) ? this.ifFileExistsCreateUniq : (this.SifFileExists.equals(this.SifFileExistsFail) ? this.ifFileExistsFail : this.ifFileExistsSkip));
            this.nr_limit = rep.getJobEntryAttributeString(id_jobentry, "nr_limit");
            this.success_condition = Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "success_condition"), (String)this.SUCCESS_IF_NO_ERRORS);
            this.connectionType = FTPSConnection.getConnectionTypeByCode(Const.NVL((String)rep.getJobEntryAttributeString(id_jobentry, "connection_type"), (String)""));
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'FTPS' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_job) throws KettleException {
        try {
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "port", this.port);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "FTPSdirectory", this.FTPSDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "targetdirectory", this.targetDirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "binary", this.binaryMode);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "remove", this.remove);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "active", this.activeConnection);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movefiles", this.movefiles);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "AddDateBeforeExtension", this.AddDateBeforeExtension);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "isaddresult", this.isaddresult);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "createmovefolder", this.createmovefolder);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_host", this.proxyHost);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_port", this.proxyPort);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_username", this.proxyUsername);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "proxy_password", Encr.encryptPasswordIfNotUsingVariables((String)this.proxyPassword));
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "ifFileExists", this.SifFileExists);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "nr_limit", this.nr_limit);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getObjectId(), "connection_type", FTPSConnection.getConnectionType(this.connectionType));
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'FTPS' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setLimit(String nr_limitin) {
        this.nr_limit = nr_limitin;
    }

    public String getLimit() {
        return this.nr_limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    public void setCreateMoveFolder(boolean createmovefolderin) {
        this.createmovefolder = createmovefolderin;
    }

    public boolean isCreateMoveFolder() {
        return this.createmovefolder;
    }

    public void setAddDateBeforeExtension(boolean AddDateBeforeExtension) {
        this.AddDateBeforeExtension = AddDateBeforeExtension;
    }

    public boolean isAddDateBeforeExtension() {
        return this.AddDateBeforeExtension;
    }

    public void setAddToResult(boolean isaddresultin) {
        this.isaddresult = isaddresultin;
    }

    public boolean isAddToResult() {
        return this.isaddresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public boolean isMoveFiles() {
        return this.movefiles;
    }

    public void setMoveFiles(boolean movefilesin) {
        this.movefiles = movefilesin;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public void setMoveToDirectory(String movetoin) {
        this.movetodirectory = movetoin;
    }

    public boolean isBinaryMode() {
        return this.binaryMode;
    }

    public void setBinaryMode(boolean binaryMode) {
        this.binaryMode = binaryMode;
    }

    public String getFTPSDirectory() {
        return this.FTPSDirectory;
    }

    public void setFTPSDirectory(String directory) {
        this.FTPSDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getTargetDirectory() {
        return this.targetDirectory;
    }

    public void setTargetDirectory(String targetDirectory) {
        this.targetDirectory = targetDirectory;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setRemove(boolean remove) {
        this.remove = remove;
    }

    public boolean getRemove() {
        return this.remove;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFilesin) {
        this.onlyGettingNewFiles = onlyGettingNewFilesin;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public Result execute(Result previousResult, int nr) throws KettleException {
        this.logBasic(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.Started", (String[])new String[]{this.serverName}));
        result = previousResult;
        result.setNrErrors(1L);
        result.setResult(false);
        this.NrErrors = 0L;
        this.NrfilesRetrieved = 0L;
        this.successConditionBroken = false;
        exitjobentry = false;
        this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
        if (this.movefiles && Const.isEmpty((String)this.movetodirectory)) {
            this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.MoveToFolderEmpty", (String[])new String[0]));
            return result;
        }
        this.localFolder = this.environmentSubstitute(this.targetDirectory);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.Start", (String[])new String[0]));
        }
        connection = null;
        try {
            realServername = this.environmentSubstitute(this.serverName);
            realUsername = this.environmentSubstitute(this.userName);
            realPassword = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.password));
            realPort = Const.toInt((String)this.environmentSubstitute(this.port), (int)0);
            connection = new FTPSConnection(this.getConnectionType(), realServername, realPort, realUsername, realPassword);
            this.buildFTPSConnection(connection);
            if (this.movefiles && !Const.isEmpty((String)this.movetodirectory)) {
                this.realMoveToFolder = this.normalizePath(this.environmentSubstitute(this.movetodirectory));
                folderExist = connection.isDirectoryExists(this.realMoveToFolder);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.CheckMoveToFolder", (String[])new String[]{this.realMoveToFolder}));
                }
                if (!folderExist) {
                    if (this.createmovefolder) {
                        connection.createDirectory(this.realMoveToFolder);
                        if (this.isDetailed()) {
                            this.logDetailed(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.MoveToFolderCreated", (String[])new String[]{this.realMoveToFolder}));
                        }
                    } else {
                        this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.MoveToFolderNotExist", (String[])new String[0]));
                        exitjobentry = true;
                        ++this.NrErrors;
                    }
                }
            }
            if (!exitjobentry) {
                pattern = null;
                if (!Const.isEmpty((String)this.wildcard)) {
                    realWildcard = this.environmentSubstitute(this.wildcard);
                    pattern = Pattern.compile(realWildcard);
                }
                if (!this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS)) {
                    this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                }
                this.downloadFiles(connection, connection.getWorkingDirectory(), pattern, result);
            }
            ** if (connection == null) goto lbl-1000
        }
        catch (Exception e) {
            try {
                if (!this.successConditionBroken && !exitjobentry) {
                    this.updateErrors();
                }
                this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.ErrorGetting", (String[])new String[]{e.getMessage()}));
                ** if (connection == null) goto lbl-1000
            }
            catch (Throwable var12_16) {
                if (connection != null) {
                    try {
                        connection.disconnect();
                    }
                    catch (Exception e) {
                        this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                    }
                }
                throw var12_16;
            }
lbl-1000:
            // 1 sources

            {
                try {
                    connection.disconnect();
                }
                catch (Exception e) {
                    this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.ErrorQuitting", (String[])new String[]{e.getMessage()}));
                }
            }
lbl-1000:
            // 2 sources

            {
            }
        }
lbl-1000:
        // 1 sources

        {
            try {
                connection.disconnect();
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(JobEntryFTPSGet.PKG, (String)"JobEntryFTPS.ErrorQuitting", (String[])new String[]{e.getMessage()}));
            }
        }
lbl-1000:
        // 2 sources

        {
        }
        result.setNrErrors(this.NrErrors);
        result.setNrFilesRetrieved(this.NrfilesRetrieved);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        if (exitjobentry) {
            result.setResult(false);
        }
        this.displayResults();
        return result;
    }

    private void downloadFiles(FTPSConnection connection, String folder, Pattern pattern, Result result) throws KettleException {
        List<FTPFile> fileList = connection.getFileList(folder);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.FoundNFiles", (Object[])new Object[]{fileList.size()}));
        }
        for (int i = 0; i < fileList.size(); ++i) {
            boolean getIt;
            if (this.parentJob.isStopped()) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFTPS.JobStopped", (String[])new String[0]));
            }
            if (this.successConditionBroken) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"JobEntryFTPS.SuccesConditionBroken", (Object[])new Object[]{this.NrErrors}));
            }
            FTPFile file = fileList.get(i);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.AnalysingFile", (String[])new String[]{file.getPath(), file.getName(), file.getMode(), file.getDate().toString(), file.getFileType() == 0 ? "File" : "Folder", String.valueOf(file.getSize())}));
            }
            if (file.isDirectory() || file.isLink() || !(getIt = true)) continue;
            try {
                if (pattern != null) {
                    Matcher matcher = pattern.matcher(file.getName());
                    getIt = matcher.matches();
                }
                if (!getIt) continue;
                String localFilename = this.returnTargetFilename(file.getName());
                if (this.onlyGettingNewFiles && (!this.onlyGettingNewFiles || !this.needsDownload(localFilename))) continue;
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.GettingFile", (String[])new String[]{file.getName(), this.targetDirectory}));
                }
                connection.downloadFile(file, this.returnTargetFilename(file.getName()));
                this.updateRetrievedFiles();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.GotFile", (String[])new String[]{file.getName()}));
                }
                this.addFilenameToResultFilenames(result, localFilename);
                if (this.remove) {
                    connection.deleteFile(file);
                    if (!this.isDetailed() || !this.isDetailed()) continue;
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.DeletedFile", (String[])new String[]{file.getName()}));
                    continue;
                }
                if (!this.movefiles) continue;
                connection.moveToFolder(file, this.realMoveToFolder);
                if (!this.isDetailed()) continue;
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.MovedFile", (String[])new String[]{file.getName(), this.realMoveToFolder}));
                continue;
            }
            catch (Exception e) {
                this.updateErrors();
                this.logError(BaseMessages.getString(PKG, (String)"JobFTPS.UnexpectedError", (String[])new String[]{e.toString()}));
            }
        }
    }

    public String normalizePath(String path) throws Exception {
        String normalizedPath = path.replaceAll("\\\\", FILE_SEPARATOR);
        while (normalizedPath.endsWith("\\") || normalizedPath.endsWith(FILE_SEPARATOR)) {
            normalizedPath = normalizedPath.substring(0, normalizedPath.length() - 1);
        }
        return normalizedPath;
    }

    private void addFilenameToResultFilenames(Result result, String filename) throws KettleException {
        if (this.isaddresult) {
            FileObject targetFile = null;
            try {
                targetFile = KettleVFS.getFileObject((String)filename);
                ResultFile resultFile = new ResultFile(0, targetFile, this.parentJob.getJobname(), this.toString());
                resultFile.setComment(BaseMessages.getString(PKG, (String)"JobEntryFTPS.Downloaded", (String[])new String[]{this.serverName}));
                result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.FileAddedToResult", (String[])new String[]{filename}));
                }
            }
            catch (Exception e) {
                throw new KettleException((Throwable)e);
            }
            finally {
                try {
                    targetFile.close();
                    targetFile = null;
                }
                catch (Exception e) {}
            }
        }
    }

    private void displayResults() {
        if (this.isDetailed()) {
            this.logDetailed("=======================================");
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.Log.Info.FilesInError", (String[])new String[]{"" + this.NrErrors}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.Log.Info.FilesRetrieved", (String[])new String[]{"" + this.NrfilesRetrieved}));
            this.logDetailed("=======================================");
        }
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrfilesRetrieved >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_DOWNLOADED) || this.NrErrors <= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0L && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= (long)this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private void updateRetrievedFiles() {
        ++this.NrfilesRetrieved;
    }

    private String returnTargetFilename(String filename) {
        String retval = null;
        if (filename == null) {
            return null;
        }
        retval = filename;
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(".");
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval.substring(0, lastindexOfDot);
        }
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        if (this.isAddDateBeforeExtension()) {
            retval = retval + retval.substring(lastindexOfDot, lenstring);
        }
        retval = this.localFolder + Const.FILE_SEPARATOR + retval;
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    protected boolean needsDownload(String filename) {
        boolean retval = false;
        File file = new File(filename);
        if (!file.exists()) {
            if (this.isDebug()) {
                this.logDebug(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTPS.LocalFileNotExists", (String[])new String[0]), filename);
            }
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsCreateUniq) {
            if (this.isDebug()) {
                this.logDebug(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTPS.LocalFileExists", (String[])new String[0]), filename);
            }
            int lenstring = filename.length();
            int lastindexOfDot = filename.lastIndexOf(46);
            if (lastindexOfDot == -1) {
                lastindexOfDot = lenstring;
            }
            filename = filename.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + filename.substring(lastindexOfDot, lenstring);
            return true;
        }
        if (this.ifFileExists == this.ifFileExistsFail) {
            this.logError(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTPS.LocalFileExists", (String[])new String[0]), filename);
            this.updateErrors();
        } else if (this.isDebug()) {
            this.logDebug(this.toString(), BaseMessages.getString(PKG, (String)"JobEntryFTPS.LocalFileExists", (String[])new String[0]), filename);
        }
        return retval;
    }

    public boolean isActiveConnection() {
        return this.activeConnection;
    }

    public int getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(int type) {
        this.connectionType = type;
    }

    public void setActiveConnection(boolean passive) {
        this.activeConnection = passive;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta, VariableSpace space, Repository repository, IMetaStore metaStore) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }

    void buildFTPSConnection(FTPSConnection connection) throws Exception {
        if (!Const.isEmpty((String)this.proxyHost)) {
            int proxyport;
            String realProxy_host = this.environmentSubstitute(this.proxyHost);
            String realProxy_username = this.environmentSubstitute(this.proxyUsername);
            String realProxy_password = Encr.decryptPasswordOptionallyEncrypted((String)this.environmentSubstitute(this.proxyPassword));
            connection.setProxyHost(realProxy_host);
            if (!Const.isEmpty((String)realProxy_username)) {
                connection.setProxyUser(realProxy_username);
            }
            if (!Const.isEmpty((String)realProxy_password)) {
                connection.setProxyPassword(realProxy_password);
            }
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.OpenedProxyConnectionOn", (String[])new String[]{realProxy_host}));
            }
            if ((proxyport = Const.toInt((String)this.environmentSubstitute(this.proxyPort), (int)21)) != 0) {
                connection.setProxyPort(proxyport);
            }
        } else if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.OpenedConnectionTo", (String[])new String[]{connection.getHostName()}));
        }
        if (this.activeConnection) {
            connection.setPassiveMode(false);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.SetActive", (String[])new String[0]));
            }
        } else {
            connection.setPassiveMode(true);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.SetPassive", (String[])new String[0]));
            }
        }
        connection.setTimeOut(this.timeout);
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.SetTimeout", (String[])new String[]{String.valueOf(this.timeout)}));
        }
        connection.connect();
        if (this.isBinaryMode()) {
            connection.setBinaryMode(true);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.SetBinary", (String[])new String[0]));
            }
        }
        if (this.isDetailed()) {
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.LoggedIn", (String[])new String[]{connection.getUserName()}));
            this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.WorkingDirectory", (String[])new String[]{connection.getWorkingDirectory()}));
        }
        if (!Const.isEmpty((String)this.FTPSDirectory)) {
            String realFTPSDirectory = this.environmentSubstitute(this.FTPSDirectory);
            realFTPSDirectory = this.normalizePath(realFTPSDirectory);
            connection.changeDirectory(realFTPSDirectory);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryFTPS.ChangedDir", (String[])new String[]{realFTPSDirectory}));
            }
        }
    }
}

