/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.autodoc;

import java.awt.Point;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Paper;
import java.util.List;
import javax.swing.table.TableModel;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.trans.steps.autodoc.AutoDocOptionsInterface;
import org.pentaho.di.trans.steps.autodoc.KettleFileTableModel;
import org.pentaho.di.trans.steps.autodoc.ReportSubjectLocation;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.Element;
import org.pentaho.reporting.engine.classic.core.Group;
import org.pentaho.reporting.engine.classic.core.GroupBody;
import org.pentaho.reporting.engine.classic.core.GroupDataBody;
import org.pentaho.reporting.engine.classic.core.ItemBand;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.PageDefinition;
import org.pentaho.reporting.engine.classic.core.RelationalGroup;
import org.pentaho.reporting.engine.classic.core.ReportFooter;
import org.pentaho.reporting.engine.classic.core.ReportHeader;
import org.pentaho.reporting.engine.classic.core.SimplePageDefinition;
import org.pentaho.reporting.engine.classic.core.TableDataFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.ContentElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.LabelElementFactory;
import org.pentaho.reporting.engine.classic.core.elementfactory.TextFieldElementFactory;
import org.pentaho.reporting.engine.classic.core.function.Expression;
import org.pentaho.reporting.engine.classic.core.modules.misc.beanshell.BSHExpression;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.CSVReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.RTFReportUtil;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.ExcelReportUtil;
import org.pentaho.reporting.engine.classic.core.style.TextStyleKeys;

public class KettleReportBuilder {
    private static final float DEF_FONT_HEIGHT = 12.0f;
    private static final int DEF_LABEL_WIDTH = 120;
    private static final int DEF_TEXT_WIDTH = 630;
    private static final boolean DEF_LABEL_UNDERLINE = false;
    private static final boolean DEF_LABEL_BOLD = false;
    private static final boolean DEF_LABEL_ITALIC = true;
    private List<ReportSubjectLocation> filenames;
    private MasterReport report;
    private String targetFilename;
    private AutoDocOptionsInterface options;
    private LoggingObjectInterface parentObject;

    public KettleReportBuilder(LoggingObjectInterface parentObject, List<ReportSubjectLocation> locations, String targetFilename, AutoDocOptionsInterface options) {
        this.parentObject = parentObject;
        this.filenames = locations;
        this.targetFilename = targetFilename;
        this.options = options;
    }

    private static int createTextField(ItemBand details, String labelText, String fieldName, int labelWidth, int textWidth, int pagePosition, float fontHeight, boolean labelUnderline, boolean labelBold, boolean labelItalic) {
        ItemBand rowBand = new ItemBand();
        rowBand.setLayout("row");
        LabelElementFactory labelElementFactory = new LabelElementFactory();
        labelElementFactory.setText(labelText);
        labelElementFactory.setAbsolutePosition((Point2D)new Point(0, pagePosition));
        labelElementFactory.setMinimumWidth(Float.valueOf(labelWidth));
        labelElementFactory.setMinimumHeight(Float.valueOf(fontHeight));
        labelElementFactory.setUnderline(Boolean.valueOf(labelUnderline));
        labelElementFactory.setBold(Boolean.valueOf(labelBold));
        labelElementFactory.setItalic(Boolean.valueOf(labelItalic));
        labelElementFactory.setDynamicHeight(Boolean.valueOf(true));
        Element label = labelElementFactory.createElement();
        rowBand.addElement(label);
        TextFieldElementFactory textFactory = new TextFieldElementFactory();
        textFactory.setFieldname(fieldName);
        textFactory.setAbsolutePosition((Point2D)new Point(labelWidth, pagePosition));
        textFactory.setMinimumWidth(Float.valueOf(textWidth));
        textFactory.setMinimumHeight(Float.valueOf(fontHeight));
        textFactory.setOverflowY(Boolean.valueOf(false));
        textFactory.setDynamicHeight(Boolean.valueOf(true));
        Element element = textFactory.createElement();
        element.setDynamicContent(true);
        rowBand.addElement(element);
        details.addElement((Element)rowBand);
        return (int)((float)pagePosition + fontHeight);
    }

    private static int createTextField(ItemBand details, String labelText, String fieldName, int pagePosition) {
        return KettleReportBuilder.createTextField(details, labelText, fieldName, 120, 630, pagePosition, 12.0f, false, false, true);
    }

    public void createReport() throws Exception {
        this.report = new MasterReport();
        KettleFileTableModel transMetaTableModel = new KettleFileTableModel(this.parentObject, this.filenames);
        TableDataFactory dataFactory = new TableDataFactory("default", (TableModel)transMetaTableModel);
        this.report.setDataFactory((DataFactory)dataFactory);
        ReportHeader reportHeader = new ReportHeader();
        this.report.setReportHeader(reportHeader);
        ReportFooter reportFooter = new ReportFooter();
        this.report.setReportFooter(reportFooter);
        RelationalGroup group = new RelationalGroup();
        group.addField("filename");
        GroupDataBody groupData = new GroupDataBody();
        ItemBand itemBand = new ItemBand();
        itemBand.setVisible(true);
        itemBand.setLayout("auto");
        groupData.setItemBand(itemBand);
        group.setBody((GroupBody)groupData);
        this.report.setRootGroup((Group)group);
        int pagePosition = 0;
        reportHeader.getStyle().setStyleProperty(TextStyleKeys.BOLD, (Object)true);
        pagePosition = KettleReportBuilder.createTextField(itemBand, "Filename: ", "filename", pagePosition);
        if (this.options.isIncludingName()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Name: ", "name", pagePosition);
        }
        if (this.options.isIncludingDescription()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Description: ", "description", pagePosition);
        }
        if (this.options.isIncludingExtendedDescription()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Long description: ", "extended_description", pagePosition);
        }
        if (this.options.isIncludingLoggingConfiguration()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Logging: ", "logging", pagePosition);
        }
        if (this.options.isIncludingCreated()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Creation: ", "creation", pagePosition);
        }
        if (this.options.isIncludingModified()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Modification: ", "modification", pagePosition);
        }
        if (this.options.isIncludingLastExecutionResult()) {
            pagePosition = KettleReportBuilder.createTextField(itemBand, "Last execution result: : ", "last_exec_result", pagePosition);
        }
        if (this.options.isIncludingImage()) {
            String packName = KettleReportBuilder.class.getPackage().getName();
            String bshCode = "Object getValue() { " + Const.CR + "  return new " + packName + ".TransJobDrawable(dataRow, " + (this.options.getOutputType() == OutputType.PDF ? "true" : "false") + ");" + Const.CR + "}";
            BSHExpression bshExpression = new BSHExpression();
            bshExpression.setExpression(bshCode);
            bshExpression.setName("getImage");
            this.report.addExpression((Expression)bshExpression);
            ContentElementFactory contentElementFactory = new ContentElementFactory();
            contentElementFactory.setName("image");
            contentElementFactory.setAbsolutePosition((Point2D)new Point(0, pagePosition));
            contentElementFactory.setMinimumWidth(Float.valueOf(750.0f));
            contentElementFactory.setMaximumWidth(Float.valueOf(750.0f));
            contentElementFactory.setMinimumHeight(Float.valueOf(400.0f));
            contentElementFactory.setMaximumHeight(Float.valueOf(750.0f));
            contentElementFactory.setScale(Boolean.valueOf(true));
            contentElementFactory.setDynamicHeight(Boolean.valueOf(true));
            Element imageElement = contentElementFactory.createElement();
            imageElement.setAttributeExpression("http://reporting.pentaho.org/namespaces/engine/attributes/core", "value", (Expression)bshExpression);
            imageElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "image-encoding-quality", (Object)"9");
            imageElement.setAttribute("http://reporting.pentaho.org/namespaces/engine/attributes/core", "image-encoding-type", (Object)"PNG");
            ItemBand imageBand = new ItemBand();
            imageBand.setLayout("row");
            imageBand.addElement(imageElement);
            itemBand.addElement((Element)imageBand);
        }
        Paper a4Paper = new Paper();
        double paperWidth = 8.26;
        double paperHeight = 11.69;
        a4Paper.setSize(paperWidth * 72.0, paperHeight * 72.0);
        double leftMargin = 0.78;
        double rightMargin = 0.78;
        double topMargin = 0.08;
        double bottomMargin = 0.78;
        a4Paper.setImageableArea(leftMargin * 72.0, topMargin * 72.0, (paperWidth - leftMargin - rightMargin) * 72.0, (paperHeight - topMargin - bottomMargin) * 72.0);
        PageFormat pageFormat = new PageFormat();
        pageFormat.setOrientation(0);
        pageFormat.setPaper(a4Paper);
        SimplePageDefinition pageDefinition = new SimplePageDefinition(pageFormat);
        this.report.setPageDefinition((PageDefinition)pageDefinition);
    }

    public void render() throws Exception {
        this.createReport();
        switch (this.options.getOutputType()) {
            case PDF: {
                PdfReportUtil.createPDF((MasterReport)this.report, (String)this.targetFilename);
                break;
            }
            case DOC: {
                RTFReportUtil.createRTF((MasterReport)this.report, (String)this.targetFilename);
                break;
            }
            case XLS: {
                ExcelReportUtil.createXLS((MasterReport)this.report, (String)this.targetFilename);
                break;
            }
            case HTML: {
                HtmlReportUtil.createDirectoryHTML((MasterReport)this.report, (String)this.targetFilename);
                break;
            }
            case CSV: {
                CSVReportUtil.createCSV((MasterReport)this.report, (String)this.targetFilename);
                break;
            }
        }
    }

    public static enum OutputType {
        PDF,
        HTML,
        DOC,
        XLS,
        CSV,
        METADATA;

    }
}

