/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.dimensionlookup;

import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;

public class DimensionCache
implements Comparator<Object[]> {
    private RowMetaInterface rowMeta;
    private List<Object[]> rowCache;
    private int[] keyIndexes;
    private int fromDateIndex;
    private int toDateIndex;

    public DimensionCache(RowMetaInterface rowMeta, int[] keyIndexes, int fromDateIndex, int toDateIndex) {
        this.rowMeta = rowMeta;
        this.keyIndexes = keyIndexes;
        this.fromDateIndex = fromDateIndex;
        this.toDateIndex = toDateIndex;
    }

    public void addRow(Object[] row) {
        this.rowCache.add(row);
    }

    public Object[] getRow(int index) {
        return this.rowCache.get(index);
    }

    public void addRow(int index, Object[] row) {
        this.rowCache.add(index, row);
    }

    public int lookupRow(Object[] lookupRowData) throws KettleException {
        try {
            Object[] row;
            int cmp;
            int insertionPoint;
            int index = Collections.binarySearch(this.rowCache, lookupRowData, this);
            if (index < 0 && (insertionPoint = -(index + 1)) < this.rowCache.size() - 1 && (cmp = this.rowMeta.compare(row = this.rowCache.get(insertionPoint), lookupRowData, this.keyIndexes)) == 0) {
                Date fromDate = this.rowMeta.getDate(row, this.fromDateIndex);
                Date toDate = this.rowMeta.getDate(row, this.toDateIndex);
                Date lookupDate = this.rowMeta.getDate(lookupRowData, this.fromDateIndex);
                if (fromDate == null && toDate != null) {
                    if (toDate.compareTo(lookupDate) > 0) {
                        return insertionPoint;
                    }
                    throw new KettleException("Key sorting problem detected during row cache lookup: the lookup date of the row retrieved is higher than or equal to the end of the date range.");
                }
                if (fromDate != null && toDate == null) {
                    if (fromDate.compareTo(lookupDate) <= 0) {
                        return insertionPoint;
                    }
                    throw new KettleException("Key sorting problem detected during row cache lookup: the lookup date of the row retrieved is lower than or equal to the start of the date range.");
                }
                if (fromDate.compareTo(lookupDate) <= 0 && toDate.compareTo(lookupDate) > 0) {
                    return insertionPoint;
                }
            }
            return index;
        }
        catch (RuntimeException e) {
            throw new KettleException((Throwable)e);
        }
    }

    public void sortRows() {
        Collections.sort(this.rowCache, this);
    }

    @Override
    public int compare(Object[] o1, Object[] o2) {
        try {
            int cmp = this.rowMeta.compare(o1, o2, this.keyIndexes);
            if (cmp != 0) {
                return cmp;
            }
            ValueMetaInterface fromDateMeta = this.rowMeta.getValueMeta(this.fromDateIndex);
            ValueMetaInterface toDateMeta = this.rowMeta.getValueMeta(this.toDateIndex);
            Date fromDate = fromDateMeta.getDate(o1[this.fromDateIndex]);
            Date toDate = toDateMeta.getDate(o1[this.toDateIndex]);
            Date lookupDate = fromDateMeta.getDate(o2[this.fromDateIndex]);
            if (toDate != null) {
                int cmpTo = lookupDate.compareTo(toDate);
                if (fromDate == null && cmpTo < 0) {
                    return 0;
                }
                int cmpFrom = lookupDate.compareTo(fromDate);
                if (fromDate != null && cmpFrom >= 0 && cmpTo < 0) {
                    return 0;
                }
            }
            return fromDateMeta.compare(o1[this.fromDateIndex], o2[this.fromDateIndex]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RowMetaInterface getRowMeta() {
        return this.rowMeta;
    }

    public void setRowMeta(RowMetaInterface rowMeta) {
        this.rowMeta = rowMeta;
    }

    public List<Object[]> getRowCache() {
        return this.rowCache;
    }

    public void setRowCache(List<Object[]> rowCache) {
        this.rowCache = rowCache;
    }

    public int[] getKeyIndexes() {
        return this.keyIndexes;
    }

    public void setKeyIndexes(int[] keyIndexes) {
        this.keyIndexes = keyIndexes;
    }

    public int getFromDateIndex() {
        return this.fromDateIndex;
    }

    public void setFromDateIndex(int fromDateIndex) {
        this.fromDateIndex = fromDateIndex;
    }

    public int getToDateIndex() {
        return this.toDateIndex;
    }

    public void setToDateIndex(int toDateIndex) {
        this.toDateIndex = toDateIndex;
    }
}

