/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.monetdbbulkloader;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.KettleAttributeInterface;
import org.pentaho.di.core.ProvidesDatabaseConnectionInformation;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.database.MonetDBDatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInjectionMetaEntry;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInjectionInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoader;
import org.pentaho.di.trans.steps.monetdbbulkloader.MonetDBBulkLoaderData;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class MonetDBBulkLoaderMeta
extends BaseStepMeta
implements StepMetaInjectionInterface,
StepMetaInterface,
ProvidesDatabaseConnectionInformation {
    private static Class<?> PKG = MonetDBBulkLoaderMeta.class;
    private String dbConnectionName;
    private String schemaName;
    private String tableName;
    private String logFile;
    private DatabaseMeta databaseMeta;
    private String[] fieldTable;
    private String[] fieldStream;
    private boolean[] fieldFormatOk;
    private String fieldSeparator;
    private String fieldEnclosure;
    private String NULLrepresentation;
    private String encoding;
    private boolean truncate = false;
    private boolean fullyQuoteSQL;
    private boolean autoSchema = false;
    private boolean autoStringWidths = false;
    private String bufferSize;

    public boolean isAutoStringWidths() {
        return this.autoStringWidths;
    }

    public void setAutoStringWidths(boolean autoStringWidths) {
        this.autoStringWidths = autoStringWidths;
    }

    public boolean isTruncate() {
        return this.truncate;
    }

    public void setTruncate(boolean truncate) {
        this.truncate = truncate;
    }

    public boolean isFullyQuoteSQL() {
        return this.fullyQuoteSQL;
    }

    public void setFullyQuoteSQL(boolean fullyQuoteSQLbool) {
        this.fullyQuoteSQL = fullyQuoteSQLbool;
    }

    public boolean isAutoSchema() {
        return this.autoSchema;
    }

    public void setAutoSchema(boolean autoSchema) {
        this.autoSchema = autoSchema;
    }

    @Override
    public DatabaseMeta getDatabaseMeta() {
        return this.databaseMeta;
    }

    public DatabaseMeta getDatabaseMeta(MonetDBBulkLoader loader) {
        return this.databaseMeta;
    }

    public void setDatabaseMeta(DatabaseMeta database) {
        this.databaseMeta = database;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String[] getFieldTable() {
        return this.fieldTable;
    }

    public void setFieldTable(String[] fieldTable) {
        this.fieldTable = fieldTable;
    }

    public String[] getFieldStream() {
        return this.fieldStream;
    }

    public void setFieldStream(String[] fieldStream) {
        this.fieldStream = fieldStream;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrvalues) {
        this.fieldTable = new String[nrvalues];
        this.fieldStream = new String[nrvalues];
        this.fieldFormatOk = new boolean[nrvalues];
    }

    @Override
    public Object clone() {
        MonetDBBulkLoaderMeta retval = (MonetDBBulkLoaderMeta)super.clone();
        int nrvalues = this.fieldTable.length;
        retval.allocate(nrvalues);
        for (int i = 0; i < nrvalues; ++i) {
            retval.fieldTable[i] = this.fieldTable[i];
            retval.fieldStream[i] = this.fieldStream[i];
        }
        return retval;
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.dbConnectionName = XMLHandler.getTagValue((Node)stepnode, (String)"connection");
            this.databaseMeta = DatabaseMeta.findDatabase(databases, (String)this.dbConnectionName);
            this.schemaName = XMLHandler.getTagValue((Node)stepnode, (String)"schema");
            this.tableName = XMLHandler.getTagValue((Node)stepnode, (String)"table");
            this.bufferSize = XMLHandler.getTagValue((Node)stepnode, (String)"buffer_size");
            this.logFile = XMLHandler.getTagValue((Node)stepnode, (String)"log_file");
            this.truncate = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"truncate"));
            this.fullyQuoteSQL = "Y".equals(XMLHandler.getTagValue((Node)stepnode, (String)"fully_quote_sql"));
            this.fieldSeparator = XMLHandler.getTagValue((Node)stepnode, (String)"field_separator");
            if (this.fieldSeparator == null) {
                this.fieldSeparator = "|";
            }
            this.fieldEnclosure = XMLHandler.getTagValue((Node)stepnode, (String)"field_enclosure");
            if (this.fieldEnclosure == null) {
                this.fieldEnclosure = "\"";
            }
            this.NULLrepresentation = XMLHandler.getTagValue((Node)stepnode, (String)"null_representation");
            if (this.NULLrepresentation == null) {
                this.NULLrepresentation = "null";
            }
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
            int nrvalues = XMLHandler.countNodes((Node)stepnode, (String)"mapping");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                Node vnode = XMLHandler.getSubNodeByNr((Node)stepnode, (String)"mapping", (int)i);
                this.fieldTable[i] = XMLHandler.getTagValue((Node)vnode, (String)"stream_name");
                this.fieldStream[i] = XMLHandler.getTagValue((Node)vnode, (String)"field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatOk[i] = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)vnode, (String)"field_format_ok"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.UnableToReadStepInfoFromXML", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void setDefault() {
        this.fieldTable = null;
        this.databaseMeta = null;
        this.schemaName = "";
        this.tableName = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.DefaultTableName", (String[])new String[0]);
        this.bufferSize = "100000";
        this.logFile = "";
        this.truncate = false;
        this.fullyQuoteSQL = true;
        this.fieldSeparator = "|";
        this.fieldEnclosure = "\"";
        this.NULLrepresentation = "";
        this.encoding = "UTF-8";
        this.allocate(0);
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"connection", (String)this.dbConnectionName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"buffer_size", (String)this.bufferSize));
        retval.append("    ").append(XMLHandler.addTagValue((String)"schema", (String)this.schemaName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"table", (String)this.tableName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"log_file", (String)this.logFile));
        retval.append("    ").append(XMLHandler.addTagValue((String)"truncate", (boolean)this.truncate));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fully_quote_sql", (boolean)this.fullyQuoteSQL));
        retval.append("    ").append(XMLHandler.addTagValue((String)"field_separator", (String)this.fieldSeparator));
        retval.append("    ").append(XMLHandler.addTagValue((String)"field_enclosure", (String)this.fieldEnclosure));
        retval.append("    ").append(XMLHandler.addTagValue((String)"null_representation", (String)this.NULLrepresentation));
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        for (int i = 0; i < this.fieldTable.length; ++i) {
            retval.append("      <mapping>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"stream_name", (String)this.fieldTable[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_name", (String)this.fieldStream[i]));
            retval.append("        ").append(XMLHandler.addTagValue((String)"field_format_ok", (boolean)this.fieldFormatOk[i]));
            retval.append("      </mapping>").append(Const.CR);
        }
        return retval.toString();
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.databaseMeta = rep.loadDatabaseMetaFromStepAttribute(id_step, "id_connection", databases);
            this.bufferSize = rep.getStepAttributeString(id_step, "buffer_size");
            this.dbConnectionName = rep.getStepAttributeString(id_step, "db_connection_name");
            this.schemaName = rep.getStepAttributeString(id_step, "schema");
            this.tableName = rep.getStepAttributeString(id_step, "table");
            this.logFile = rep.getStepAttributeString(id_step, "log_file");
            this.fieldSeparator = rep.getStepAttributeString(id_step, "field_separator");
            if (this.fieldSeparator == null) {
                this.fieldEnclosure = "\"";
            }
            this.fieldEnclosure = rep.getStepAttributeString(id_step, "field_enclosure");
            if (this.fieldEnclosure == null) {
                this.fieldEnclosure = "\"";
            }
            this.NULLrepresentation = rep.getStepAttributeString(id_step, "null_representation");
            if (this.NULLrepresentation == null) {
                this.NULLrepresentation = "";
            }
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            if (this.encoding == null) {
                this.encoding = "UTF-8";
            }
            this.truncate = Boolean.parseBoolean(rep.getStepAttributeString(id_step, "truncate"));
            this.fullyQuoteSQL = Boolean.parseBoolean(rep.getStepAttributeString(id_step, "fully_quote_sql"));
            int nrvalues = rep.countNrStepAttributes(id_step, "stream_name");
            this.allocate(nrvalues);
            for (int i = 0; i < nrvalues; ++i) {
                this.fieldTable[i] = rep.getStepAttributeString(id_step, i, "stream_name");
                this.fieldStream[i] = rep.getStepAttributeString(id_step, i, "field_name");
                if (this.fieldStream[i] == null) {
                    this.fieldStream[i] = this.fieldTable[i];
                }
                this.fieldFormatOk[i] = rep.getStepAttributeBoolean(id_step, i, "field_format_ok");
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.UnexpectedErrorReadingStepInfoFromRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveDatabaseMetaStepAttribute(id_transformation, id_step, "id_connection", this.databaseMeta);
            rep.saveStepAttribute(id_transformation, id_step, "db_connection_name", this.dbConnectionName);
            rep.saveStepAttribute(id_transformation, id_step, "schema", this.schemaName);
            rep.saveStepAttribute(id_transformation, id_step, "table", this.tableName);
            rep.saveStepAttribute(id_transformation, id_step, "buffer_size", this.bufferSize);
            rep.saveStepAttribute(id_transformation, id_step, "log_file", this.logFile);
            rep.saveStepAttribute(id_transformation, id_step, "truncate", this.truncate);
            rep.saveStepAttribute(id_transformation, id_step, "fully_quote_sql", this.fullyQuoteSQL);
            rep.saveStepAttribute(id_transformation, id_step, "field_separator", this.fieldSeparator);
            rep.saveStepAttribute(id_transformation, id_step, "field_enclosure", this.fieldEnclosure);
            rep.saveStepAttribute(id_transformation, id_step, "null_representation", this.NULLrepresentation);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            for (int i = 0; i < this.fieldTable.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, i, "stream_name", this.fieldTable[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", this.fieldStream[i]);
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format_ok", this.fieldFormatOk[i]);
            }
            if (this.databaseMeta != null) {
                rep.insertStepDatabase(id_transformation, id_step, this.databaseMeta.getObjectId());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.UnableToSaveStepInfoToRepository", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    @Override
    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        String error_message = "";
        if (this.databaseMeta != null) {
            Database db = new Database(loggingObject, this.databaseMeta);
            db.shareVariablesWith((VariableSpace)transMeta);
            try {
                boolean error_found;
                boolean first;
                db.connect();
                if (!Const.isEmpty((String)this.tableName)) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TableNameOK", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_found = false;
                    error_message = "";
                    String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                    RowMetaInterface r = db.getTableFields(schemaTable);
                    if (r != null) {
                        cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.TableExists", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                        first = true;
                        error_found = false;
                        error_message = "";
                        for (int i = 0; i < this.fieldTable.length; ++i) {
                            String field = this.fieldTable[i];
                            ValueMetaInterface v = r.searchValueMeta(field);
                            if (v != null) continue;
                            if (first) {
                                first = false;
                                error_message = error_message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsToLoadInTargetTable", (String[])new String[0]) + Const.CR;
                            }
                            error_found = true;
                            error_message = error_message + "\t\t" + field + Const.CR;
                        }
                        cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.AllFieldsFoundInTargetTable", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    } else {
                        error_message = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.CouldNotReadTableInfo", (String[])new String[0]);
                        cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                        remarks.add((CheckResultInterface)cr);
                    }
                }
                if (prev != null && prev.size() > 0) {
                    cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.StepReceivingDatas", (String[])new String[]{prev.size() + ""}), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                    first = true;
                    error_message = "";
                    error_found = false;
                    for (int i = 0; i < this.fieldStream.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v != null) continue;
                        if (first) {
                            first = false;
                            error_message = error_message + BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsInInput", (String[])new String[0]) + Const.CR;
                        }
                        error_found = true;
                        error_message = error_message + "\t\t" + this.fieldStream[i] + Const.CR;
                    }
                    cr = error_found ? new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.AllFieldsFoundInInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                    remarks.add((CheckResultInterface)cr);
                }
                error_message = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.MissingFieldsInInput3", (String[])new String[0]) + Const.CR;
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            catch (KettleException e) {
                error_message = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.DatabaseErrorOccurred", (String[])new String[0]) + e.getMessage();
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
            finally {
                db.disconnect();
            }
        } else {
            error_message = BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.InvalidConnection", (String[])new String[0]);
            cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.StepReceivingInfoFromOtherSteps", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.CheckResult.NoInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    public SQLStatement getTableDdl(TransMeta transMeta, String stepname, boolean autoSchema, MonetDBBulkLoaderData data, boolean safeMode) throws KettleException {
        String name = stepname;
        StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderDialog.StepMeta.Title", (String[])new String[0]), name, this);
        RowMetaInterface prev = transMeta.getPrevStepFields(stepname);
        SQLStatement sql = this.getSQLStatements(transMeta, stepMeta, prev, autoSchema, data, safeMode);
        return sql;
    }

    public RowMetaInterface updateFields(TransMeta transMeta, String stepname, MonetDBBulkLoaderData data) throws KettleStepException {
        RowMetaInterface prev = transMeta.getPrevStepFields(stepname);
        return this.updateFields(prev, data);
    }

    public RowMetaInterface updateFields(RowMetaInterface prev, MonetDBBulkLoaderData data) {
        RowMeta tableFields = new RowMeta();
        List fields = prev.getValueMetaList();
        this.fieldTable = new String[fields.size()];
        this.fieldStream = new String[fields.size()];
        this.fieldFormatOk = new boolean[fields.size()];
        int idx = 0;
        for (ValueMetaInterface field : fields) {
            ValueMetaInterface tableField = field.clone();
            tableFields.addValueMeta(tableField);
            this.fieldTable[idx] = field.getName();
            this.fieldStream[idx] = field.getName();
            this.fieldFormatOk[idx] = true;
        }
        data.keynrs = new int[this.getFieldStream().length];
        for (int i = 0; i < data.keynrs.length; ++i) {
            data.keynrs[i] = i;
        }
        return tableFields;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLStatement getSQLStatements(TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, boolean autoSchema, MonetDBBulkLoaderData data, boolean safeMode) throws KettleStepException {
        SQLStatement retval = new SQLStatement(stepMeta.getName(), this.databaseMeta, null);
        if (this.databaseMeta != null) {
            if (prev != null && prev.size() > 0) {
                RowMeta tableFields;
                if (autoSchema) {
                    tableFields = this.updateFields(prev, data);
                } else {
                    tableFields = new RowMeta();
                    for (int i = 0; i < this.fieldTable.length; ++i) {
                        ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                        if (v == null) continue;
                        ValueMetaInterface tableField = v.clone();
                        tableField.setName(this.fieldTable[i]);
                        tableFields.addValueMeta(tableField);
                    }
                }
                if (!Const.isEmpty((String)this.tableName)) {
                    Database db = new Database(loggingObject, this.databaseMeta);
                    db.shareVariablesWith((VariableSpace)transMeta);
                    try {
                        String cr_table;
                        db.connect();
                        String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(transMeta.environmentSubstitute(this.schemaName), transMeta.environmentSubstitute(this.tableName));
                        MonetDBDatabaseMeta.safeModeLocal.set(safeMode);
                        String sql = cr_table = db.getDDL(schemaTable, (RowMetaInterface)tableFields, null, false, null, true);
                        if (sql.length() == 0) {
                            retval.setSQL(null);
                        }
                        retval.setSQL(sql);
                    }
                    catch (KettleException e) {
                        retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                    }
                    finally {
                        db.disconnect();
                        MonetDBDatabaseMeta.safeModeLocal.remove();
                    }
                } else {
                    retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NoTableDefinedOnConnection", (String[])new String[0]));
                }
            } else {
                retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NotReceivingAnyFields", (String[])new String[0]));
            }
        } else {
            retval.setError(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.GetSQL.NoConnectionDefined", (String[])new String[0]));
        }
        return retval;
    }

    @Override
    public void analyseImpact(List<DatabaseImpact> impact, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, Repository repository, IMetaStore metaStore) throws KettleStepException {
        if (prev != null) {
            for (int i = 0; i < this.fieldTable.length; ++i) {
                ValueMetaInterface v = prev.searchValueMeta(this.fieldStream[i]);
                DatabaseImpact ii = new DatabaseImpact(3, transMeta.getName(), stepMeta.getName(), this.databaseMeta.getDatabaseName(), transMeta.environmentSubstitute(this.tableName), this.fieldTable[i], this.fieldStream[i], v != null ? v.getOrigin() : "?", "", "Type = " + v.toStringMeta());
                impact.add(ii);
            }
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new MonetDBBulkLoader(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new MonetDBBulkLoaderData();
    }

    @Override
    public DatabaseMeta[] getUsedDatabaseConnections() {
        if (this.databaseMeta != null) {
            return new DatabaseMeta[]{this.databaseMeta};
        }
        return super.getUsedDatabaseConnections();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public RowMetaInterface getRequiredFields(VariableSpace space) throws KettleException {
        String realTableName = space.environmentSubstitute(this.tableName);
        String realSchemaName = space.environmentSubstitute(this.schemaName);
        if (this.databaseMeta == null) throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.ConnectionNotDefined", (String[])new String[0]));
        Database db = new Database(loggingObject, this.databaseMeta);
        try {
            db.connect();
            if (Const.isEmpty((String)realTableName)) throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.TableNotSpecified", (String[])new String[0]));
            String schemaTable = this.databaseMeta.getQuotedSchemaTableCombination(realSchemaName, realTableName);
            if (db.checkTableExists(schemaTable)) {
                RowMetaInterface rowMetaInterface = db.getTableFields(schemaTable);
                return rowMetaInterface;
            }
            try {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.TableNotFound", (String[])new String[0]));
            }
            catch (Exception e) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"MonetDBBulkLoaderMeta.Exception.ErrorGettingFields", (String[])new String[0]), (Throwable)e);
            }
        }
        finally {
            db.disconnect();
        }
    }

    @Override
    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getLogFile() {
        return this.logFile;
    }

    public void setLogFile(String logFile) {
        this.logFile = logFile;
    }

    public String getFieldSeparator() {
        return this.fieldSeparator;
    }

    public void setFieldSeparator(String fieldSeparatorStr) {
        this.fieldSeparator = fieldSeparatorStr;
    }

    public String getFieldEnclosure() {
        return this.fieldEnclosure;
    }

    public void setFieldEnclosure(String fieldEnclosureStr) {
        this.fieldEnclosure = fieldEnclosureStr;
    }

    public String getNULLrepresentation() {
        return this.NULLrepresentation;
    }

    public void setNULLrepresentation(String NULLrepresentationStr) {
        this.NULLrepresentation = NULLrepresentationStr;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(String bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean[] getFieldFormatOk() {
        return this.fieldFormatOk;
    }

    public void setFieldFormatOk(boolean[] fieldFormatOk) {
        this.fieldFormatOk = fieldFormatOk;
    }

    @Override
    public String getMissingDatabaseConnectionInformationMessage() {
        return null;
    }

    public void setDbConnectionName(String dbConnectionName) {
        this.dbConnectionName = dbConnectionName;
    }

    public String getDbConnectionName() {
        return this.dbConnectionName;
    }

    @Override
    public StepMetaInjectionInterface getStepMetaInjectionInterface() {
        return this;
    }

    @Override
    public List<StepInjectionMetaEntry> getStepInjectionMetadataEntries() {
        return this.getStepInjectionMetadataEntries(PKG);
    }

    @Override
    public void injectStepMetadataEntries(List<StepInjectionMetaEntry> metadata) {
        for (StepInjectionMetaEntry entry : metadata) {
            KettleAttributeInterface attr = this.findAttribute(entry.getKey());
            if (entry.getValueType() != 0) {
                if (entry.getKey().equals("SCHEMA")) {
                    this.schemaName = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("TABLE")) {
                    this.tableName = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("LOGFILE")) {
                    this.logFile = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("FIELD_SEPARATOR")) {
                    this.fieldSeparator = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("FIELD_ENCLOSURE")) {
                    this.fieldEnclosure = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("NULL_REPRESENTATION")) {
                    this.setNULLrepresentation((String)entry.getValue());
                    continue;
                }
                if (entry.getKey().equals("ENCODING")) {
                    this.encoding = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("BUFFER_SIZE")) {
                    this.bufferSize = (String)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("TRUNCATE")) {
                    this.truncate = (Boolean)entry.getValue();
                    continue;
                }
                if (entry.getKey().equals("FULLY_QUOTE_SQL")) {
                    this.fullyQuoteSQL = (Boolean)entry.getValue();
                    continue;
                }
                throw new RuntimeException("Unhandled metadata injection of attribute: " + attr.toString() + " - " + attr.getDescription());
            }
            if (attr.getKey().equals("MAPPINGS")) {
                List<StepInjectionMetaEntry> selectMappings = entry.getDetails();
                this.fieldTable = new String[selectMappings.size()];
                this.fieldStream = new String[selectMappings.size()];
                this.fieldFormatOk = new boolean[selectMappings.size()];
                for (int row = 0; row < selectMappings.size(); ++row) {
                    StepInjectionMetaEntry selectField = selectMappings.get(row);
                    List<StepInjectionMetaEntry> fieldAttributes = selectField.getDetails();
                    for (int i = 0; i < fieldAttributes.size(); ++i) {
                        StepInjectionMetaEntry fieldAttribute = fieldAttributes.get(i);
                        KettleAttributeInterface fieldAttr = this.findAttribute(fieldAttribute.getKey());
                        Object attributeValue = fieldAttribute.getValue();
                        if (attributeValue == null) continue;
                        if (fieldAttr.getKey().equals("STREAMNAME")) {
                            this.getFieldStream()[row] = (String)attributeValue;
                            continue;
                        }
                        if (fieldAttr.getKey().equals("FIELDNAME")) {
                            this.getFieldTable()[row] = (String)attributeValue;
                            continue;
                        }
                        if (fieldAttr.getKey().equals("FIELD_FORMAT_OK")) {
                            this.getFieldFormatOk()[row] = (Boolean)attributeValue;
                            continue;
                        }
                        throw new RuntimeException("Unhandled metadata injection of attribute: " + fieldAttr.toString() + " - " + fieldAttr.getDescription());
                    }
                }
            }
            if (Const.isEmpty((String[])this.getFieldStream())) continue;
            for (int i = 0; i < this.getFieldStream().length; ++i) {
                this.logDetailed("row " + Integer.toString(i) + ": stream=" + this.getFieldStream()[i] + " : table=" + this.getFieldTable()[i]);
            }
        }
    }

    @Override
    public List<StepInjectionMetaEntry> extractStepMetadataEntries() throws KettleException {
        return null;
    }
}

