/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.salesforceinput;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceConnectionUtils;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInput;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputData;
import org.pentaho.di.trans.steps.salesforceinput.SalesforceInputField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

public class SalesforceInputMeta
extends BaseStepMeta
implements StepMetaInterface {
    public static String DATE_TIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    private static Class<?> PKG = SalesforceInputMeta.class;
    private boolean includeSQL;
    private String sqlField;
    private boolean includeTimestamp;
    private String timestampField;
    private boolean includeTargetURL;
    private String targetURLField;
    private boolean includeModule;
    private String moduleField;
    private boolean includeDeletionDate;
    private String deletionDateField;
    private boolean includeRowNumber;
    private String rowNumberField;
    private String targeturl;
    private String username;
    private String password;
    private String module;
    private String condition;
    private String timeout;
    private String rowLimit;
    private SalesforceInputField[] inputFields;
    private boolean specifyQuery;
    private boolean useCompression;
    private String query;
    private int nrFields;
    private String readTo;
    private String readFrom;
    private int recordsFilter;
    private boolean queryAll;

    public SalesforceInputField[] getInputFields() {
        return this.inputFields;
    }

    public void setInputFields(SalesforceInputField[] inputFields) {
        this.inputFields = inputFields;
    }

    public String getUserName() {
        return this.username;
    }

    public void setUserName(String user_name) {
        this.username = user_name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String passwd) {
        this.password = passwd;
    }

    public String getModule() {
        return this.module;
    }

    public void setModule(String module) {
        this.module = module;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public boolean isSpecifyQuery() {
        return this.specifyQuery;
    }

    public void setSpecifyQuery(boolean specifyQuery) {
        this.specifyQuery = specifyQuery;
    }

    public boolean isUsingCompression() {
        return this.useCompression;
    }

    public void setUseCompression(boolean useCompression) {
        this.useCompression = useCompression;
    }

    public boolean isQueryAll() {
        return this.queryAll;
    }

    public void setQueryAll(boolean value) {
        this.queryAll = value;
    }

    public String getCondition() {
        return this.condition;
    }

    public void setCondition(String condition) {
        this.condition = condition;
    }

    public String getTargetURL() {
        return this.targeturl;
    }

    public void setTargetURL(String urlvalue) {
        this.targeturl = urlvalue;
    }

    public void setTargetURLField(String TargetURLField) {
        this.targetURLField = TargetURLField;
    }

    public void setSQLField(String sqlField) {
        this.sqlField = sqlField;
    }

    public void setTimestampField(String timestampField) {
        this.timestampField = timestampField;
    }

    public void setModuleField(String module_field) {
        this.moduleField = module_field;
    }

    public int getRecordsFilter() {
        return this.recordsFilter;
    }

    public void setRecordsFilter(int recordsFilter) {
        this.recordsFilter = recordsFilter;
    }

    public boolean includeTargetURL() {
        return this.includeTargetURL;
    }

    public boolean includeSQL() {
        return this.includeSQL;
    }

    public void setIncludeSQL(boolean includeSQL) {
        this.includeSQL = includeSQL;
    }

    public boolean includeTimestamp() {
        return this.includeTimestamp;
    }

    public void setIncludeTimestamp(boolean includeTimestamp) {
        this.includeTimestamp = includeTimestamp;
    }

    public boolean includeModule() {
        return this.includeTargetURL;
    }

    public void setIncludeTargetURL(boolean includeTargetURL) {
        this.includeTargetURL = includeTargetURL;
    }

    public void setIncludeModule(boolean includemodule) {
        this.includeModule = includemodule;
    }

    public boolean includeRowNumber() {
        return this.includeRowNumber;
    }

    public void setIncludeRowNumber(boolean includeRowNumber) {
        this.includeRowNumber = includeRowNumber;
    }

    public boolean includeDeletionDate() {
        return this.includeDeletionDate;
    }

    public void setIncludeDeletionDate(boolean includeDeletionDate) {
        this.includeDeletionDate = includeDeletionDate;
    }

    public String getRowLimit() {
        return this.rowLimit;
    }

    public String getTimeOut() {
        return this.timeout;
    }

    public void setRowLimit(String rowLimit) {
        this.rowLimit = rowLimit;
    }

    public void setTimeOut(String TimeOut) {
        this.timeout = TimeOut;
    }

    public String getRowNumberField() {
        return this.rowNumberField;
    }

    public String getDeletionDateField() {
        return this.deletionDateField;
    }

    public void setDeletionDateField(String value) {
        this.deletionDateField = value;
    }

    public String getTargetURLField() {
        return this.targetURLField;
    }

    public String getReadFrom() {
        return this.readFrom;
    }

    public void setReadFrom(String readFrom) {
        this.readFrom = readFrom;
    }

    public String getReadTo() {
        return this.readTo;
    }

    public void setReadTo(String readTo) {
        this.readTo = readTo;
    }

    public String getSQLField() {
        return this.sqlField;
    }

    public String getTimestampField() {
        return this.timestampField;
    }

    public String getModuleField() {
        return this.moduleField;
    }

    public void setRowNumberField(String rowNumberField) {
        this.rowNumberField = rowNumberField;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    @Override
    public Object clone() {
        SalesforceInputMeta retval = (SalesforceInputMeta)super.clone();
        int nrFields = this.inputFields.length;
        retval.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            if (this.inputFields[i] == null) continue;
            retval.inputFields[i] = (SalesforceInputField)this.inputFields[i].clone();
        }
        return retval;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"targeturl", (String)this.targeturl));
        retval.append("    " + XMLHandler.addTagValue((String)"username", (String)this.username));
        retval.append("    " + XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.password), (boolean)false, (String[])new String[0]));
        retval.append("    " + XMLHandler.addTagValue((String)"module", (String)this.module));
        retval.append("    " + XMLHandler.addTagValue((String)"condition", (String)this.condition));
        retval.append("    " + XMLHandler.addTagValue((String)"specifyQuery", (boolean)this.specifyQuery));
        retval.append("    " + XMLHandler.addTagValue((String)"query", (String)this.query));
        retval.append("    " + XMLHandler.addTagValue((String)"include_targeturl", (boolean)this.includeTargetURL));
        retval.append("    " + XMLHandler.addTagValue((String)"targeturl_field", (String)this.targetURLField));
        retval.append("    " + XMLHandler.addTagValue((String)"include_module", (boolean)this.includeModule));
        retval.append("    " + XMLHandler.addTagValue((String)"module_field", (String)this.moduleField));
        retval.append("    " + XMLHandler.addTagValue((String)"include_rownum", (boolean)this.includeRowNumber));
        retval.append("    " + XMLHandler.addTagValue((String)"include_deletion_date", (boolean)this.includeDeletionDate));
        retval.append("    " + XMLHandler.addTagValue((String)"deletion_date_field", (String)this.deletionDateField));
        retval.append("    " + XMLHandler.addTagValue((String)"rownum_field", (String)this.rowNumberField));
        retval.append("    " + XMLHandler.addTagValue((String)"include_sql", (boolean)this.includeSQL));
        retval.append("    " + XMLHandler.addTagValue((String)"sql_field", (String)this.sqlField));
        retval.append("    " + XMLHandler.addTagValue((String)"include_Timestamp", (boolean)this.includeTimestamp));
        retval.append("    " + XMLHandler.addTagValue((String)"timestamp_field", (String)this.timestampField));
        retval.append("    " + XMLHandler.addTagValue((String)"read_from", (String)this.readFrom));
        retval.append("    " + XMLHandler.addTagValue((String)"read_to", (String)this.readTo));
        retval.append("    " + XMLHandler.addTagValue((String)"records_filter", (String)SalesforceConnectionUtils.getRecordsFilterCode(this.recordsFilter)));
        retval.append("    " + XMLHandler.addTagValue((String)"useCompression", (boolean)this.useCompression));
        retval.append("    " + XMLHandler.addTagValue((String)"queryAll", (boolean)this.queryAll));
        retval.append("    <fields>" + Const.CR);
        for (int i = 0; i < this.inputFields.length; ++i) {
            SalesforceInputField field = this.inputFields[i];
            retval.append(field.getXML());
        }
        retval.append("      </fields>" + Const.CR);
        retval.append("    " + XMLHandler.addTagValue((String)"limit", (String)this.rowLimit));
        retval.append("    " + XMLHandler.addTagValue((String)"timeout", (String)this.timeout));
        return retval.toString();
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.targeturl = XMLHandler.getTagValue((Node)stepnode, (String)"targeturl");
            this.username = XMLHandler.getTagValue((Node)stepnode, (String)"username");
            this.password = XMLHandler.getTagValue((Node)stepnode, (String)"password");
            if (this.password != null && this.password.startsWith("Encrypted")) {
                this.password = Encr.decryptPassword((String)this.password.replace("Encrypted", "").replace(" ", ""));
            }
            this.module = XMLHandler.getTagValue((Node)stepnode, (String)"module");
            this.condition = XMLHandler.getTagValue((Node)stepnode, (String)"condition");
            this.query = XMLHandler.getTagValue((Node)stepnode, (String)"query");
            this.specifyQuery = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"specifyQuery"));
            this.includeTargetURL = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_targeturl"));
            this.targetURLField = XMLHandler.getTagValue((Node)stepnode, (String)"targeturl_field");
            this.includeModule = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_module"));
            this.moduleField = XMLHandler.getTagValue((Node)stepnode, (String)"module_field");
            this.includeRowNumber = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_rownum"));
            this.includeDeletionDate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_deletion_date"));
            this.rowNumberField = XMLHandler.getTagValue((Node)stepnode, (String)"rownum_field");
            this.deletionDateField = XMLHandler.getTagValue((Node)stepnode, (String)"deletion_date_field");
            this.includeSQL = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_sql"));
            this.sqlField = XMLHandler.getTagValue((Node)stepnode, (String)"targetsql_field");
            this.includeTimestamp = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"include_Timestamp"));
            this.timestampField = XMLHandler.getTagValue((Node)stepnode, (String)"timestamp_field");
            this.readFrom = XMLHandler.getTagValue((Node)stepnode, (String)"read_from");
            this.readTo = XMLHandler.getTagValue((Node)stepnode, (String)"read_to");
            this.recordsFilter = SalesforceConnectionUtils.getRecordsFilterByCode(Const.NVL((String)XMLHandler.getTagValue((Node)stepnode, (String)"records_filter"), (String)""));
            this.useCompression = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"useCompression"));
            this.queryAll = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"queryAll"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrFields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                SalesforceInputField field;
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.inputFields[i] = field = new SalesforceInputField(fnode);
            }
            this.timeout = XMLHandler.getTagValue((Node)stepnode, (String)"timeout");
            this.rowLimit = XMLHandler.getTagValue((Node)stepnode, (String)"limit");
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void allocate(int nrfields) {
        this.inputFields = new SalesforceInputField[nrfields];
    }

    public int getNrFields() {
        return this.nrFields;
    }

    @Override
    public void setDefault() {
        this.includeDeletionDate = false;
        this.queryAll = false;
        this.readFrom = "";
        this.readTo = "";
        this.nrFields = 0;
        this.specifyQuery = false;
        this.query = "";
        this.targeturl = "https://www.salesforce.com/services/Soap/u/21.0";
        this.password = "";
        this.module = "Account";
        this.condition = "";
        this.includeTargetURL = false;
        this.targetURLField = "";
        this.includeModule = false;
        this.moduleField = "";
        this.includeRowNumber = false;
        this.rowNumberField = "";
        this.deletionDateField = "";
        this.useCompression = false;
        this.includeSQL = false;
        this.sqlField = "";
        this.includeTimestamp = false;
        this.timestampField = "";
        int nrFields = 0;
        this.allocate(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            this.inputFields[i] = new SalesforceInputField("field" + (i + 1));
        }
        this.rowLimit = "0";
        this.timeout = "60000";
    }

    @Override
    public void getFields(RowMetaInterface r, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v;
        for (int i = 0; i < this.inputFields.length; ++i) {
            SalesforceInputField field = this.inputFields[i];
            int type = field.getType();
            if (type == 0) {
                type = 2;
            }
            try {
                ValueMetaInterface v2 = ValueMetaFactory.createValueMeta((String)space.environmentSubstitute(field.getName()), (int)type);
                v2.setLength(field.getLength());
                v2.setPrecision(field.getPrecision());
                v2.setOrigin(name);
                v2.setConversionMask(field.getFormat());
                v2.setDecimalSymbol(field.getDecimalSymbol());
                v2.setGroupingSymbol(field.getGroupSymbol());
                v2.setCurrencySymbol(field.getCurrencySymbol());
                r.addValueMeta(v2);
                continue;
            }
            catch (Exception e) {
                throw new KettleStepException((Throwable)e);
            }
        }
        if (this.includeTargetURL && !Const.isEmpty((String)this.targetURLField)) {
            v = new ValueMeta(space.environmentSubstitute(this.targetURLField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeModule && !Const.isEmpty((String)this.moduleField)) {
            v = new ValueMeta(space.environmentSubstitute(this.moduleField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeSQL && !Const.isEmpty((String)this.sqlField)) {
            v = new ValueMeta(space.environmentSubstitute(this.sqlField), 2);
            v.setLength(250);
            v.setPrecision(-1);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeTimestamp && !Const.isEmpty((String)this.timestampField)) {
            v = new ValueMeta(space.environmentSubstitute(this.timestampField), 3);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeRowNumber && !Const.isEmpty((String)this.rowNumberField)) {
            v = new ValueMeta(space.environmentSubstitute(this.rowNumberField), 5);
            v.setLength(10, 0);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
        if (this.includeDeletionDate && !Const.isEmpty((String)this.deletionDateField)) {
            v = new ValueMeta(space.environmentSubstitute(this.deletionDateField), 3);
            v.setOrigin(name);
            r.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.targeturl = rep.getStepAttributeString(id_step, "targeturl");
            this.username = rep.getStepAttributeString(id_step, "username");
            this.password = rep.getStepAttributeString(id_step, "password");
            if (this.password != null && this.password.startsWith("Encrypted")) {
                this.password = Encr.decryptPassword((String)this.password.replace("Encrypted", "").replace(" ", ""));
            }
            this.module = rep.getStepAttributeString(id_step, "module");
            this.condition = rep.getStepAttributeString(id_step, "condition");
            this.query = rep.getStepAttributeString(id_step, "query");
            this.specifyQuery = rep.getStepAttributeBoolean(id_step, "specifyQuery");
            this.includeTargetURL = rep.getStepAttributeBoolean(id_step, "include_targeturl");
            this.targetURLField = rep.getStepAttributeString(id_step, "targeturl_field");
            this.includeModule = rep.getStepAttributeBoolean(id_step, "include_module");
            this.moduleField = rep.getStepAttributeString(id_step, "module_field");
            this.includeRowNumber = rep.getStepAttributeBoolean(id_step, "include_rownum");
            this.includeDeletionDate = rep.getStepAttributeBoolean(id_step, "include_deletion_date");
            this.rowNumberField = rep.getStepAttributeString(id_step, "rownum_field");
            this.deletionDateField = rep.getStepAttributeString(id_step, "deletion_date_field");
            this.includeSQL = rep.getStepAttributeBoolean(id_step, "include_sql");
            this.sqlField = rep.getStepAttributeString(id_step, "sql_field");
            this.includeTimestamp = rep.getStepAttributeBoolean(id_step, "include_Timestamp");
            this.timestampField = rep.getStepAttributeString(id_step, "timestamp_field");
            this.rowLimit = rep.getStepAttributeString(id_step, "limit");
            this.timeout = rep.getStepAttributeString(id_step, "timeout");
            this.readFrom = rep.getStepAttributeString(id_step, "read_from");
            this.readTo = rep.getStepAttributeString(id_step, "read_to");
            this.recordsFilter = SalesforceConnectionUtils.getRecordsFilterByCode(Const.NVL((String)rep.getStepAttributeString(id_step, "records_filter"), (String)""));
            this.useCompression = rep.getStepAttributeBoolean(id_step, "useCompression");
            this.queryAll = rep.getStepAttributeBoolean(id_step, "queryAll");
            int nrFields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrFields);
            for (int i = 0; i < nrFields; ++i) {
                SalesforceInputField field = new SalesforceInputField();
                field.setName(rep.getStepAttributeString(id_step, i, "field_name"));
                field.setField(rep.getStepAttributeString(id_step, i, "field_attribut"));
                field.setIdLookup(rep.getStepAttributeBoolean(id_step, i, "field_idlookup"));
                field.setType(ValueMeta.getType((String)rep.getStepAttributeString(id_step, i, "field_type")));
                field.setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                field.setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                field.setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                field.setGroupSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                field.setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                field.setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                field.setTrimType(SalesforceInputField.getTrimTypeByCode(rep.getStepAttributeString(id_step, i, "field_trim_type")));
                field.setRepeated(rep.getStepAttributeBoolean(id_step, i, "field_repeat"));
                this.inputFields[i] = field;
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInputMeta.Exception.ErrorReadingRepository", (String[])new String[0]), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "targeturl", this.targeturl);
            rep.saveStepAttribute(id_transformation, id_step, "username", this.username);
            rep.saveStepAttribute(id_transformation, id_step, "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveStepAttribute(id_transformation, id_step, "module", this.module);
            rep.saveStepAttribute(id_transformation, id_step, "condition", this.condition);
            rep.saveStepAttribute(id_transformation, id_step, "query", this.query);
            rep.saveStepAttribute(id_transformation, id_step, "specifyQuery", this.specifyQuery);
            rep.saveStepAttribute(id_transformation, id_step, "include_targeturl", this.includeTargetURL);
            rep.saveStepAttribute(id_transformation, id_step, "targeturl_field", this.targetURLField);
            rep.saveStepAttribute(id_transformation, id_step, "include_module", this.includeModule);
            rep.saveStepAttribute(id_transformation, id_step, "module_field", this.moduleField);
            rep.saveStepAttribute(id_transformation, id_step, "include_rownum", this.includeRowNumber);
            rep.saveStepAttribute(id_transformation, id_step, "include_deletion_date", this.includeDeletionDate);
            rep.saveStepAttribute(id_transformation, id_step, "include_sql", this.includeSQL);
            rep.saveStepAttribute(id_transformation, id_step, "sql_field", this.sqlField);
            rep.saveStepAttribute(id_transformation, id_step, "include_Timestamp", this.includeTimestamp);
            rep.saveStepAttribute(id_transformation, id_step, "timestamp_field", this.timestampField);
            rep.saveStepAttribute(id_transformation, id_step, "rownum_field", this.rowNumberField);
            rep.saveStepAttribute(id_transformation, id_step, "deletion_date_field", this.deletionDateField);
            rep.saveStepAttribute(id_transformation, id_step, "limit", this.rowLimit);
            rep.saveStepAttribute(id_transformation, id_step, "timeout", this.timeout);
            rep.saveStepAttribute(id_transformation, id_step, "read_from", this.readFrom);
            rep.saveStepAttribute(id_transformation, id_step, "read_to", this.readTo);
            rep.saveStepAttribute(id_transformation, id_step, "records_filter", SalesforceConnectionUtils.getRecordsFilterCode(this.recordsFilter));
            rep.saveStepAttribute(id_transformation, id_step, "useCompression", this.useCompression);
            rep.saveStepAttribute(id_transformation, id_step, "queryAll", this.queryAll);
            for (int i = 0; i < this.inputFields.length; ++i) {
                SalesforceInputField field = this.inputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribut", field.getField());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_idlookup", field.isIdLookup());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_trim_type", field.getTrimTypeCode());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_repeat", field.isRepeated());
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"SalesforceInputMeta.Exception.ErrorSavingToRepository", (String[])new String[]{"" + id_step}), (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr = input.length > 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInputExpected", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoInput", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.targeturl) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoURL", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.URLOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.username) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoUsername", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.UsernameOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = Const.isEmpty((String)this.module) ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoModule", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.ModuleOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        cr = this.inputFields.length == 0 ? new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoFields", (String[])new String[0]), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.FieldsOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
        if (this.includeTargetURL && Const.isEmpty((String)this.targetURLField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTargetURLField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeSQL && Const.isEmpty((String)this.sqlField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoSQLField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeModule && Const.isEmpty((String)this.moduleField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoModuleField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeTimestamp && Const.isEmpty((String)this.timestampField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoTimestampField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeRowNumber && Const.isEmpty((String)this.rowNumberField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoRowNumberField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        if (this.includeDeletionDate && Const.isEmpty((String)this.deletionDateField)) {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"SalesforceInputMeta.CheckResult.NoDeletionDateField", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new SalesforceInput(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new SalesforceInputData();
    }
}

