/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.rel.rules;

import java.util.ArrayList;
import org.eigenbase.rel.RelNode;
import org.eigenbase.rel.UnionRel;
import org.eigenbase.relopt.RelOptRule;
import org.eigenbase.relopt.RelOptRuleCall;
import org.eigenbase.util.Util;

public class CombineUnionsRule
extends RelOptRule {
    public static final CombineUnionsRule INSTANCE = new CombineUnionsRule();

    private CombineUnionsRule() {
        super(CombineUnionsRule.operand(UnionRel.class, CombineUnionsRule.operand(RelNode.class, CombineUnionsRule.any()), CombineUnionsRule.operand(RelNode.class, CombineUnionsRule.any())));
    }

    public void onMatch(RelOptRuleCall call) {
        UnionRel bottomUnionRel;
        UnionRel topUnionRel = (UnionRel)call.rel(0);
        if (call.rel(2) instanceof UnionRel) {
            bottomUnionRel = (UnionRel)call.rel(2);
        } else if (call.rel(1) instanceof UnionRel) {
            bottomUnionRel = (UnionRel)call.rel(1);
        } else {
            return;
        }
        if (!topUnionRel.all || !bottomUnionRel.all) {
            return;
        }
        ArrayList<RelNode> unionInputs = new ArrayList<RelNode>();
        if (call.rel(2) instanceof UnionRel) {
            assert (topUnionRel.getInputs().size() == 2);
            unionInputs.add(topUnionRel.getInput(0));
            unionInputs.addAll(bottomUnionRel.getInputs());
        } else {
            unionInputs.addAll(bottomUnionRel.getInputs());
            unionInputs.addAll(Util.skip(topUnionRel.getInputs()));
        }
        assert (unionInputs.size() == bottomUnionRel.getInputs().size() + topUnionRel.getInputs().size() - 1);
        UnionRel newUnionRel = new UnionRel(topUnionRel.getCluster(), unionInputs, true);
        call.transformTo(newUnionRel);
    }
}

