/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.relopt;

import java.util.HashMap;
import java.util.Map;
import org.eigenbase.rel.RelNode;
import org.eigenbase.relopt.RelOptCluster;
import org.eigenbase.relopt.RelOptPlanner;
import org.eigenbase.reltype.RelDataTypeFactory;
import org.eigenbase.rex.RexBuilder;
import org.eigenbase.rex.RexFieldAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelOptQuery {
    public static final String CORREL_PREFIX = "$cor";
    private final Map<DeferredLookup, String> mapDeferredToCorrel = new HashMap<DeferredLookup, String>();
    final Map<String, RelNode> mapCorrelToRel = new HashMap<String, RelNode>();
    private final RelOptPlanner planner;
    private int nextCorrel = 0;

    public RelOptQuery(RelOptPlanner planner) {
        this.planner = planner;
    }

    public static int getCorrelOrdinal(String correlName) {
        assert (correlName.startsWith(CORREL_PREFIX));
        return Integer.parseInt(correlName.substring(CORREL_PREFIX.length()));
    }

    public Map<DeferredLookup, String> getMapDeferredToCorrel() {
        return this.mapDeferredToCorrel;
    }

    public RelOptCluster createCluster(RelDataTypeFactory typeFactory, RexBuilder rexBuilder) {
        return new RelOptCluster(this, this.planner, typeFactory, rexBuilder);
    }

    public String createCorrel() {
        int n = this.nextCorrel++;
        return CORREL_PREFIX + n;
    }

    public String createCorrelUnresolved(DeferredLookup deferredLookup) {
        int n = this.nextCorrel++;
        String name = CORREL_PREFIX + n;
        this.mapDeferredToCorrel.put(deferredLookup, name);
        return name;
    }

    public RelNode lookupCorrel(String name) {
        return this.mapCorrelToRel.get(name);
    }

    public void mapCorrel(String name, RelNode rel) {
        this.mapCorrelToRel.put(name, rel);
    }

    public static interface DeferredLookup {
        public RexFieldAccess getFieldAccess(String var1);
    }
}

