/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.resource;

import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import org.eigenbase.resource.ResourceInstance;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceDefinition {
    public final String key;
    public final String baseMessage;
    private final String[] props;
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public ResourceDefinition(String key, String baseMessage) {
        this(key, baseMessage, null);
    }

    public ResourceDefinition(String key, String baseMessage, String[] props) {
        this.key = key;
        this.baseMessage = baseMessage;
        if (props == null) {
            props = EMPTY_STRING_ARRAY;
        }
        assert (props.length % 2 == 0) : "Must have even number of property names/values";
        this.props = props;
    }

    public String getKey() {
        return this.key;
    }

    public Properties getProperties() {
        Properties properties = new Properties();
        for (int i = 0; i < this.props.length; ++i) {
            String prop = this.props[i];
            String value = this.props[++i];
            properties.setProperty(prop, value);
        }
        return properties;
    }

    public List<ArgType> getArgTypes() {
        return ResourceDefinition.getArgTypes(this.baseMessage);
    }

    public ResourceInstance instantiate(ResourceBundle bundle, Object[] args) {
        return new Instance(bundle, this, args);
    }

    protected static List<ArgType> getArgTypes(String message) {
        MessageFormat format = new MessageFormat(message);
        Format[] argFormats = format.getFormatsByArgumentIndex();
        ArrayList<ArgType> argTypes = new ArrayList<ArgType>();
        for (Format argFormat : argFormats) {
            argTypes.add(ResourceDefinition.formatToType(argFormat));
        }
        return argTypes;
    }

    private static ArgType formatToType(Format format) {
        if (format == null) {
            return ArgType.STRING;
        }
        if (format instanceof NumberFormat) {
            return ArgType.NUMBER;
        }
        if (format instanceof DateFormat) {
            return ArgType.DATE;
        }
        return ArgType.STRING;
    }

    private static class Instance
    implements ResourceInstance {
        ResourceDefinition definition;
        ResourceBundle bundle;
        Object[] args;

        public Instance(ResourceBundle bundle, ResourceDefinition definition, Object[] args) {
            this.definition = definition;
            this.bundle = bundle;
            this.args = args;
        }

        public String toString() {
            String message = this.bundle.getString(this.definition.key);
            MessageFormat format = new MessageFormat(message);
            format.setLocale(this.bundle.getLocale());
            return format.format(this.args);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum ArgType {
        STRING,
        NUMBER,
        DATE;

    }
}

