/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql;

import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlJoin;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlLiteral;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.SqlNodeList;
import org.eigenbase.sql.SqlOperator;
import org.eigenbase.sql.SqlSyntax;
import org.eigenbase.sql.SqlWriter;
import org.eigenbase.sql.parser.SqlParserPos;
import org.eigenbase.util.Util;

public class SqlJoinOperator
extends SqlOperator {
    private static final SqlWriter.FrameType FRAME_TYPE = SqlWriter.FrameTypeEnum.create("USING");

    public SqlJoinOperator() {
        super("JOIN", SqlKind.JOIN, 16, true, null, null, null);
    }

    public SqlSyntax getSyntax() {
        return SqlSyntax.SPECIAL;
    }

    public SqlCall createCall(SqlLiteral functionQualifier, SqlParserPos pos, SqlNode ... operands) {
        assert (functionQualifier == null);
        return new SqlJoin(pos, operands[0], (SqlLiteral)operands[1], (SqlLiteral)operands[2], operands[3], (SqlLiteral)operands[4], operands[5]);
    }

    public SqlCall createCall(SqlNode left, SqlLiteral isNatural, SqlLiteral joinType, SqlNode right, SqlLiteral conditionType, SqlNode condition, SqlParserPos pos) {
        return this.createCall(pos, left, isNatural, joinType, right, conditionType, condition);
    }

    public void unparse(SqlWriter writer, SqlCall call, int leftPrec, int rightPrec) {
        SqlJoin join = (SqlJoin)call;
        join.left.unparse(writer, leftPrec, this.getLeftPrec());
        String natural = "";
        if (join.isNatural()) {
            natural = "NATURAL ";
        }
        switch (join.getJoinType()) {
            case COMMA: {
                writer.sep(",", true);
                break;
            }
            case CROSS: {
                writer.sep(natural + "CROSS JOIN");
                break;
            }
            case FULL: {
                writer.sep(natural + "FULL JOIN");
                break;
            }
            case INNER: {
                writer.sep(natural + "INNER JOIN");
                break;
            }
            case LEFT: {
                writer.sep(natural + "LEFT JOIN");
                break;
            }
            case RIGHT: {
                writer.sep(natural + "RIGHT JOIN");
                break;
            }
            default: {
                throw Util.unexpected(join.getJoinType());
            }
        }
        join.right.unparse(writer, this.getRightPrec(), rightPrec);
        if (join.condition != null) {
            switch (join.getConditionType()) {
                case USING: {
                    writer.keyword("USING");
                    assert (join.condition instanceof SqlNodeList);
                    SqlWriter.Frame frame = writer.startList(FRAME_TYPE, "(", ")");
                    join.condition.unparse(writer, 0, 0);
                    writer.endList(frame);
                    break;
                }
                case ON: {
                    writer.keyword("ON");
                    join.condition.unparse(writer, leftPrec, rightPrec);
                    break;
                }
                default: {
                    throw Util.unexpected(join.getConditionType());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum JoinType implements SqlLiteral.SqlSymbol
    {
        INNER,
        FULL,
        CROSS,
        LEFT,
        RIGHT,
        COMMA;


        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ConditionType implements SqlLiteral.SqlSymbol
    {
        NONE,
        ON,
        USING;


        public SqlLiteral symbol(SqlParserPos pos) {
            return SqlLiteral.createSymbol(this, pos);
        }
    }
}

