/*
 * Decompiled with CFR 0.152.
 */
package org.eigenbase.sql.validate;

import org.eigenbase.sql.SqlCall;
import org.eigenbase.sql.SqlKind;
import org.eigenbase.sql.SqlNode;
import org.eigenbase.sql.util.SqlBasicVisitor;
import org.eigenbase.util.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AggFinder
extends SqlBasicVisitor<Void> {
    private final boolean over;

    AggFinder(boolean over) {
        this.over = over;
    }

    public SqlNode findAgg(SqlNode node) {
        try {
            node.accept(this);
            return null;
        }
        catch (Util.FoundOne e) {
            Util.swallow(e, null);
            return (SqlNode)e.getNode();
        }
    }

    @Override
    public Void visit(SqlCall call) {
        if (call.getOperator().isAggregator()) {
            throw new Util.FoundOne(call);
        }
        if (call.isA(SqlKind.QUERY)) {
            return null;
        }
        if (call.getKind() == SqlKind.OVER) {
            if (this.over) {
                throw new Util.FoundOne(call);
            }
            return null;
        }
        return (Void)super.visit(call);
    }
}

