/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.authorize;

import com.google.common.annotations.VisibleForTesting;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.util.StringUtils;

@InterfaceAudience.Private
public class ProxyUsers {
    private static final String CONF_HOSTS = ".hosts";
    public static final String CONF_GROUPS = ".groups";
    public static final String CONF_HADOOP_PROXYUSER = "hadoop.proxyuser.";
    public static final String CONF_HADOOP_PROXYUSER_RE = "hadoop\\.proxyuser\\.";
    public static final String CONF_HADOOP_PROXYSERVERS = "hadoop.proxyservers";
    private static boolean init = false;
    private static Map<String, Collection<String>> proxyGroups = new HashMap<String, Collection<String>>();
    private static Map<String, Collection<String>> proxyHosts = new HashMap<String, Collection<String>>();
    private static Collection<String> proxyServers = new HashSet<String>();

    public static void refreshSuperUserGroupsConfiguration() {
        ProxyUsers.refreshSuperUserGroupsConfiguration(new Configuration());
    }

    public static synchronized void refreshSuperUserGroupsConfiguration(Configuration conf) {
        proxyGroups.clear();
        proxyHosts.clear();
        proxyServers.clear();
        String regex = "hadoop\\.proxyuser\\.[^.]*\\.groups";
        Map<String, String> allMatchKeys = conf.getValByRegex(regex);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            proxyGroups.put(entry.getKey(), StringUtils.getTrimmedStringCollection(entry.getValue()));
        }
        regex = "hadoop\\.proxyuser\\.[^.]*\\.hosts";
        allMatchKeys = conf.getValByRegex(regex);
        for (Map.Entry<String, String> entry : allMatchKeys.entrySet()) {
            proxyHosts.put(entry.getKey(), StringUtils.getTrimmedStringCollection(entry.getValue()));
        }
        for (String host : conf.getTrimmedStrings(CONF_HADOOP_PROXYSERVERS)) {
            InetSocketAddress addr = new InetSocketAddress(host, 0);
            if (addr.isUnresolved()) continue;
            proxyServers.add(addr.getAddress().getHostAddress());
        }
        init = true;
    }

    public static synchronized boolean isProxyServer(String remoteAddr) {
        if (!init) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        return proxyServers.contains(remoteAddr);
    }

    public static String getProxySuperuserGroupConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_GROUPS;
    }

    public static String getProxySuperuserIpConfKey(String userName) {
        return CONF_HADOOP_PROXYUSER + userName + CONF_HOSTS;
    }

    public static synchronized void authorize(UserGroupInformation user, String remoteAddress, Configuration newConf) throws AuthorizationException {
        if (!init) {
            ProxyUsers.refreshSuperUserGroupsConfiguration();
        }
        if (user.getRealUser() == null) {
            return;
        }
        boolean groupAuthorized = false;
        boolean ipAuthorized = false;
        UserGroupInformation superUser = user.getRealUser();
        Collection<String> allowedUserGroups = proxyGroups.get(ProxyUsers.getProxySuperuserGroupConfKey(superUser.getShortUserName()));
        if (ProxyUsers.isWildcardList(allowedUserGroups)) {
            groupAuthorized = true;
        } else if (allowedUserGroups != null && !allowedUserGroups.isEmpty()) {
            for (String group : user.getGroupNames()) {
                if (!allowedUserGroups.contains(group)) continue;
                groupAuthorized = true;
                break;
            }
        }
        if (!groupAuthorized) {
            throw new AuthorizationException("User: " + superUser.getUserName() + " is not allowed to impersonate " + user.getUserName());
        }
        Collection<String> ipList = proxyHosts.get(ProxyUsers.getProxySuperuserIpConfKey(superUser.getShortUserName()));
        if (ProxyUsers.isWildcardList(ipList)) {
            ipAuthorized = true;
        } else if (ipList != null && !ipList.isEmpty()) {
            for (String allowedHost : ipList) {
                InetAddress hostAddr;
                try {
                    hostAddr = InetAddress.getByName(allowedHost);
                }
                catch (UnknownHostException e) {
                    continue;
                }
                if (!hostAddr.getHostAddress().equals(remoteAddress)) continue;
                ipAuthorized = true;
            }
        }
        if (!ipAuthorized) {
            throw new AuthorizationException("Unauthorized connection for super-user: " + superUser.getUserName() + " from IP " + remoteAddress);
        }
    }

    private static boolean isWildcardList(Collection<String> list) {
        return list != null && list.size() == 1 && list.contains("*");
    }

    @VisibleForTesting
    public static Map<String, Collection<String>> getProxyGroups() {
        return proxyGroups;
    }

    @VisibleForTesting
    public static Map<String, Collection<String>> getProxyHosts() {
        return proxyHosts;
    }
}

