/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public final class ByteBufferUtils {
    private static final int VALUE_MASK = 127;
    private static final int NEXT_BIT_SHIFT = 7;
    private static final int NEXT_BIT_MASK = 128;

    private ByteBufferUtils() {
    }

    public static void writeVLong(ByteBuffer out, long i) {
        if (i >= -112L && i <= 127L) {
            out.put((byte)i);
            return;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        out.put((byte)len);
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            out.put((byte)((i & mask) >> shiftbits));
        }
    }

    public static long readVLong(ByteBuffer in) {
        byte firstByte = in.get();
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = in.get();
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int putCompressedInt(OutputStream out, int value) throws IOException {
        int i = 0;
        int tmpvalue = value;
        do {
            byte b = (byte)(tmpvalue & 0x7F);
            if ((tmpvalue >>>= 7) != 0) {
                b = (byte)(b | 0xFFFFFF80);
            }
            out.write(b);
            ++i;
        } while (tmpvalue != 0);
        return i;
    }

    public static void putInt(OutputStream out, int value) throws IOException {
        for (int i = 3; i >= 0; --i) {
            out.write((byte)(value >>> i * 8));
        }
    }

    public static void moveBufferToStream(OutputStream out, ByteBuffer in, int length) throws IOException {
        ByteBufferUtils.copyBufferToStream(out, in, in.position(), length);
        ByteBufferUtils.skip(in, length);
    }

    public static void copyBufferToStream(OutputStream out, ByteBuffer in, int offset, int length) throws IOException {
        if (in.hasArray()) {
            out.write(in.array(), in.arrayOffset() + offset, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.write(in.get(offset + i));
            }
        }
    }

    public static int putLong(OutputStream out, long value, int fitInBytes) throws IOException {
        long tmpValue = value;
        for (int i = 0; i < fitInBytes; ++i) {
            out.write((byte)(tmpValue & 0xFFL));
            tmpValue >>>= 8;
        }
        return fitInBytes;
    }

    public static int longFitsIn(long value) {
        if (value < 0L) {
            return 8;
        }
        if (value < 0x100000000L) {
            if (value < 65536L) {
                if (value < 256L) {
                    return 1;
                }
                return 2;
            }
            if (value < 0x1000000L) {
                return 3;
            }
            return 4;
        }
        if (value < 0x1000000000000L) {
            if (value < 0x10000000000L) {
                return 5;
            }
            return 6;
        }
        if (value < 0x100000000000000L) {
            return 7;
        }
        return 8;
    }

    public static int intFitsIn(int value) {
        if (value < 0) {
            return 4;
        }
        if (value < 65536) {
            if (value < 256) {
                return 1;
            }
            return 2;
        }
        if (value <= 0x1000000) {
            return 3;
        }
        return 4;
    }

    public static int readCompressedInt(InputStream input) throws IOException {
        byte b;
        int result = 0;
        int i = 0;
        do {
            b = (byte)input.read();
            result += (b & 0x7F) << 7 * i;
            if (++i <= 5) continue;
            throw new IllegalStateException("Corrupted compressed int (too long: " + (i + 1) + " bytes)");
        } while (0 != (b & 0x80));
        return result;
    }

    public static int readCompressedInt(ByteBuffer buffer) {
        byte b = buffer.get();
        if ((b & 0x80) != 0) {
            return (b & 0x7F) + (ByteBufferUtils.readCompressedInt(buffer) << 7);
        }
        return b & 0x7F;
    }

    public static long readLong(InputStream in, int fitInBytes) throws IOException {
        long tmpLong = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLong |= ((long)in.read() & 0xFFL) << 8 * i;
        }
        return tmpLong;
    }

    public static long readLong(ByteBuffer in, int fitInBytes) {
        long tmpLength = 0L;
        for (int i = 0; i < fitInBytes; ++i) {
            tmpLength |= ((long)in.get() & 0xFFL) << (int)(8L * (long)i);
        }
        return tmpLength;
    }

    public static void copyFromStreamToBuffer(ByteBuffer out, DataInputStream in, int length) throws IOException {
        if (out.hasArray()) {
            in.readFully(out.array(), out.position() + out.arrayOffset(), length);
            ByteBufferUtils.skip(out, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.put(in.readByte());
            }
        }
    }

    public static ByteBuffer drainInputStreamToBuffer(InputStream is) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(4096);
        IOUtils.copyBytes((InputStream)is, (OutputStream)baos, (int)4096, (boolean)true);
        ByteBuffer buffer = ByteBuffer.wrap(baos.toByteArray());
        buffer.rewind();
        return buffer;
    }

    public static void copyFromBufferToBuffer(ByteBuffer out, ByteBuffer in, int sourceOffset, int length) {
        if (in.hasArray() && out.hasArray()) {
            System.arraycopy(in.array(), sourceOffset + in.arrayOffset(), out.array(), out.position() + out.arrayOffset(), length);
            ByteBufferUtils.skip(out, length);
        } else {
            for (int i = 0; i < length; ++i) {
                out.put(in.get(sourceOffset + i));
            }
        }
    }

    public static int findCommonPrefix(ByteBuffer buffer, int offsetLeft, int offsetRight, int limit) {
        int prefix;
        for (prefix = 0; prefix < limit && buffer.get(offsetLeft + prefix) == buffer.get(offsetRight + prefix); ++prefix) {
        }
        return prefix;
    }

    public static int findCommonPrefix(byte[] left, int leftOffset, int leftLength, byte[] right, int rightOffset, int rightLength) {
        int result;
        int length = Math.min(leftLength, rightLength);
        for (result = 0; result < length && left[leftOffset + result] == right[rightOffset + result]; ++result) {
        }
        return result;
    }

    public static boolean arePartsEqual(ByteBuffer buffer, int offsetLeft, int lengthLeft, int offsetRight, int lengthRight) {
        if (lengthLeft != lengthRight) {
            return false;
        }
        if (buffer.hasArray()) {
            return 0 == Bytes.compareTo(buffer.array(), buffer.arrayOffset() + offsetLeft, lengthLeft, buffer.array(), buffer.arrayOffset() + offsetRight, lengthRight);
        }
        for (int i = 0; i < lengthRight; ++i) {
            if (buffer.get(offsetLeft + i) == buffer.get(offsetRight + i)) continue;
            return false;
        }
        return true;
    }

    public static void skip(ByteBuffer buffer, int length) {
        buffer.position(buffer.position() + length);
    }

    public static void extendLimit(ByteBuffer buffer, int numBytes) {
        buffer.limit(buffer.limit() + numBytes);
    }

    public static byte[] toBytes(ByteBuffer buffer, int startPosition) {
        int originalPosition = buffer.position();
        byte[] output = new byte[buffer.limit() - startPosition];
        buffer.position(startPosition);
        buffer.get(output);
        buffer.position(originalPosition);
        return output;
    }
}

