/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage;

import com.microsoft.windowsazure.storage.GeoReplicationStats;
import com.microsoft.windowsazure.storage.OperationContext;
import com.microsoft.windowsazure.storage.ServiceStats;
import com.microsoft.windowsazure.storage.StorageException;
import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

final class ServiceStatsDeserializer {
    private static final String GEO_REPLICATION_NAME = "GeoReplication";
    private static final String STATUS_NAME = "Status";
    private static final String LAST_SYNC_TIME_NAME = "LastSyncTime";

    ServiceStatsDeserializer() {
    }

    protected static ServiceStats readServiceStatsFromStream(InputStream inStream, OperationContext context) throws XMLStreamException, StorageException, ParseException {
        ServiceStats serviceStats = new ServiceStats();
        GeoReplicationStats geoReplicationStats = new GeoReplicationStats();
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(inStream);
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        eventType = xmlr.next();
        xmlr.require(1, null, "StorageServiceStats");
        eventType = xmlr.next();
        xmlr.require(1, null, GEO_REPLICATION_NAME);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 1) {
                String name = xmlr.getName().toString();
                if (name.equals(STATUS_NAME)) {
                    geoReplicationStats.setStatus(GeoReplicationStats.getGeoReplicationStatus(DeserializationHelper.readElementFromXMLReader(xmlr, STATUS_NAME)));
                    xmlr.require(2, null, STATUS_NAME);
                    continue;
                }
                if (name.equals(LAST_SYNC_TIME_NAME)) {
                    String lastSyncTime = DeserializationHelper.readElementFromXMLReader(xmlr, LAST_SYNC_TIME_NAME);
                    geoReplicationStats.setLastSyncTime(Utility.isNullOrEmpty(lastSyncTime) ? null : Utility.parseRFC1123DateFromStringInGMT(lastSyncTime));
                    xmlr.require(2, null, LAST_SYNC_TIME_NAME);
                    continue;
                }
                throw new StorageException("InvalidXmlDocument", "The response received is invalid or improperly formatted.", 306, null, null);
            }
            if (eventType != 2 || !xmlr.getName().toString().equals("StorageServiceStats")) continue;
        }
        serviceStats.setGeoReplication(geoReplicationStats);
        return serviceStats;
    }
}

