/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.storage.core;

import com.microsoft.windowsazure.storage.core.DeserializationHelper;
import com.microsoft.windowsazure.storage.core.SharedAccessPolicy;
import com.microsoft.windowsazure.storage.core.Utility;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class SharedAccessPolicyDeserializer {
    public static <T extends SharedAccessPolicy> HashMap<String, T> getAccessIdentifiers(InputStream stream, Class<T> cls) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException {
        XMLStreamReader xmlr = DeserializationHelper.createXMLStreamReaderFromStream(stream);
        HashMap policies = new HashMap();
        int eventType = xmlr.getEventType();
        xmlr.require(7, null, null);
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType != 1 || !name.equals("SignedIdentifiers")) continue;
            SharedAccessPolicyDeserializer.readPolicies(xmlr, policies, cls);
        }
        return policies;
    }

    private static <T extends SharedAccessPolicy> void readPolicies(XMLStreamReader xmlr, HashMap<String, T> policies, Class<T> cls) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "SignedIdentifiers");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("SignedIdentifier")) {
                SharedAccessPolicyDeserializer.readSignedIdentifier(xmlr, policies, cls);
                continue;
            }
            if (eventType != 2 || !name.equals("SignedIdentifiers")) continue;
            break;
        }
        xmlr.require(2, null, "SignedIdentifiers");
    }

    private static <T extends SharedAccessPolicy> void readSignedIdentifier(XMLStreamReader xmlr, HashMap<String, T> policies, Class<T> cls) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "SignedIdentifier");
        String id = null;
        Object policy = null;
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("Id")) {
                id = DeserializationHelper.readElementFromXMLReader(xmlr, "Id");
                continue;
            }
            if (eventType == 1 && name.equals("AccessPolicy")) {
                policy = SharedAccessPolicyDeserializer.readPolicyFromXML(xmlr, cls);
                continue;
            }
            if (eventType != 2 || !name.equals("SignedIdentifier")) continue;
            policies.put(id, policy);
            break;
        }
        xmlr.require(2, null, "SignedIdentifier");
    }

    private static <T extends SharedAccessPolicy> T readPolicyFromXML(XMLStreamReader xmlr, Class<T> cls) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "AccessPolicy");
        SharedAccessPolicy retPolicy = (SharedAccessPolicy)cls.newInstance();
        while (xmlr.hasNext()) {
            String tempString;
            eventType = xmlr.next();
            if (eventType != 1 && eventType != 2) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("Permission")) {
                retPolicy.setPermissionsFromString(DeserializationHelper.readElementFromXMLReader(xmlr, "Permission"));
                continue;
            }
            if (eventType == 1 && name.equals("Start")) {
                tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "Start");
                retPolicy.setSharedAccessStartTime(Utility.parseISO8061LongDateFromString(tempString));
                continue;
            }
            if (eventType == 1 && name.equals("Expiry")) {
                tempString = DeserializationHelper.readElementFromXMLReader(xmlr, "Expiry");
                retPolicy.setSharedAccessExpiryTime(Utility.parseISO8061LongDateFromString(tempString));
                continue;
            }
            if (eventType != 2 || !name.equals("AccessPolicy")) continue;
            break;
        }
        xmlr.require(2, null, "AccessPolicy");
        return (T)retPolicy;
    }
}

