/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.mapred;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class TableRecordReaderImpl {
    static final Log LOG = LogFactory.getLog(TableRecordReaderImpl.class);
    private byte[] startRow;
    private byte[] endRow;
    private byte[] lastRow;
    private Filter trrRowFilter;
    private ResultScanner scanner;
    private HTable htable;
    private byte[][] trrInputColumns;

    public void restart(byte[] firstRow) throws IOException {
        if (this.endRow != null && this.endRow.length > 0) {
            if (this.trrRowFilter != null) {
                Scan scan = new Scan(firstRow, this.endRow);
                scan.addColumns(this.trrInputColumns);
                scan.setFilter(this.trrRowFilter);
                scan.setCacheBlocks(false);
                this.scanner = this.htable.getScanner(scan);
            } else {
                LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary(firstRow) + ", endRow: " + Bytes.toStringBinary(this.endRow)));
                Scan scan = new Scan(firstRow, this.endRow);
                scan.addColumns(this.trrInputColumns);
                this.scanner = this.htable.getScanner(scan);
            }
        } else {
            LOG.debug((Object)("TIFB.restart, firstRow: " + Bytes.toStringBinary(firstRow) + ", no endRow"));
            Scan scan = new Scan(firstRow);
            scan.addColumns(this.trrInputColumns);
            this.scanner = this.htable.getScanner(scan);
        }
    }

    public void init() throws IOException {
        this.restart(this.startRow);
    }

    byte[] getStartRow() {
        return this.startRow;
    }

    public void setHTable(HTable htable) {
        this.htable = htable;
    }

    public void setInputColumns(byte[][] inputColumns) {
        this.trrInputColumns = inputColumns;
    }

    public void setStartRow(byte[] startRow) {
        this.startRow = startRow;
    }

    public void setEndRow(byte[] endRow) {
        this.endRow = endRow;
    }

    public void setRowFilter(Filter rowFilter) {
        this.trrRowFilter = rowFilter;
    }

    public void close() {
        this.scanner.close();
    }

    public ImmutableBytesWritable createKey() {
        return new ImmutableBytesWritable();
    }

    public Result createValue() {
        return new Result();
    }

    public long getPos() {
        return 0L;
    }

    public float getProgress() {
        return 0.0f;
    }

    public boolean next(ImmutableBytesWritable key, Result value) throws IOException {
        Result result;
        try {
            result = this.scanner.next();
        }
        catch (UnknownScannerException e) {
            LOG.debug((Object)("recovered from " + StringUtils.stringifyException((Throwable)e)));
            this.restart(this.lastRow);
            this.scanner.next();
            result = this.scanner.next();
        }
        if (result != null && result.size() > 0) {
            key.set(result.getRow());
            this.lastRow = key.get();
            Writables.copyWritable(result, (Writable)value);
            return true;
        }
        return false;
    }
}

