/*
 * Decompiled with CFR 0.152.
 */
package rat.analysis;

import rat.report.RatReportFailedException;
import rat.report.claim.IClaimReporter;

public class Claims {
    public static final String LICENSE_APPROVAL_PREDICATE = "license-approval";
    public static final String LICENSE_FAMILY_PREDICATE = "license-family";
    public static final String HEADER_SAMPLE_PREDICATE = "header-sample";
    public static final String HEADER_TYPE_PREDICATE = "header-type";
    public static final String ASL_CODE = "AL   ";
    public static final String OASIS_CODE = "OASIS";
    public static final String W3CD_CODE = "W3CD ";
    public static final String W3C_CODE = "W3C  ";
    public static final String DOJO = "DOJO ";

    public static void reportHeaderSampleClaim(String sample, String subject, IClaimReporter reporter) throws RatReportFailedException {
        reporter.claim(subject, HEADER_SAMPLE_PREDICATE, sample, true);
    }

    public static void reportGeneratedHeaderTypeClaim(String subject, IClaimReporter reporter) throws RatReportFailedException {
        Claims.reportHeaderTypeClaim("GEN  ", subject, reporter);
    }

    public static void reportHeaderTypeClaim(String type, String subject, IClaimReporter reporter) throws RatReportFailedException {
        reporter.claim(subject, HEADER_TYPE_PREDICATE, type, false);
    }

    public static void reportGeneratedClaims(String subject, String notes, IClaimReporter reporter) throws RatReportFailedException {
        Claims.reportHeaderSampleClaim(notes, subject, reporter);
        Claims.reportGeneratedHeaderTypeClaim(subject, reporter);
    }

    public static void reportStandardClaims(String subject, String notes, String code, String name, IClaimReporter reporter) throws RatReportFailedException {
        Claims.reportHeaderTypeClaim(code, subject, reporter);
        Claims.reportHeaderSampleClaim(notes, subject, reporter);
        reporter.claim(subject, LICENSE_FAMILY_PREDICATE, name, false);
    }

    public static void reportLicenseApprovalClaim(CharSequence subject, boolean isAcceptable, IClaimReporter reporter) throws RatReportFailedException {
        String approvalValue = Boolean.toString(isAcceptable);
        reporter.claim(subject, LICENSE_APPROVAL_PREDICATE, approvalValue, false);
    }
}

