/*
 * Decompiled with CFR 0.152.
 */
package rat.document.impl;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import rat.document.IDocument;
import rat.document.IDocumentCollection;
import rat.document.UnreadableArchiveException;
import rat.document.impl.DocumentImplUtils;

public class MonolithicFileDocument
implements IDocument {
    private final File file;
    private final String name;

    public MonolithicFileDocument(File file) {
        this.file = file;
        this.name = DocumentImplUtils.toName(file);
    }

    public IDocumentCollection readArchive() throws IOException {
        throw new UnreadableArchiveException("This file is not an archive");
    }

    public Reader reader() throws IOException {
        return new FileReader(this.file);
    }

    public String getName() {
        return this.name;
    }
}

