/*
 * Decompiled with CFR 0.152.
 */
package rat.document.impl.guesser;

import java.util.Arrays;
import java.util.List;
import rat.document.IDocument;
import rat.document.IDocumentMatcher;
import rat.document.impl.guesser.GuessUtils;

public class NoteGuesser
implements IDocumentMatcher {
    public static final String[] NOTE_FILE_NAMES = new String[]{"NOTICE", "LICENSE", "LICENSE.TXT", "NOTICE.TXT", "INSTALL", "INSTALL.TXT", "README", "README.TXT", "NEWS", "NEWS.TXT", "AUTHOR", "AUTHOR.TXT", "AUTHORS", "AUTHORS.txt", "CHANGELOG", "CHANGELOG.TXT", "DISCLAIMER", "DISCLAIMER.TXT", "KEYS", "KEYS.TXT", "RELEASE-NOTES", "RELEASE-NOTES.TXT", "RELEASE_NOTES", "RELEASE_NOTES.TXT", "UPGRADE", "UPGRADE.TXT", "STATUS", "STATUS.TXT", "THIRD_PARTY_NOTICES", "THIRD_PARTY_NOTICES.TXT", "COPYRIGHT", "COPYRIGHT.TXT", "BUILDING", "BUILDING.TXT"};
    public static final String[] NOTE_FILE_EXTENSIONS = new String[]{"LICENSE", "LICENSE.TXT", "NOTICE", "NOTICE.TXT"};

    public static final boolean isNote(String name) {
        if (name == null) {
            return false;
        }
        List<String> l = Arrays.asList(NOTE_FILE_NAMES);
        String normalisedName = GuessUtils.normalise(name);
        boolean result = l.contains(name) || l.contains(normalisedName);
        for (int i = 0; !result && i < NOTE_FILE_EXTENSIONS.length; ++i) {
            result = normalisedName.endsWith("." + NOTE_FILE_EXTENSIONS[i]);
        }
        return result;
    }

    public boolean matches(IDocument document) {
        String name = document.getName();
        boolean result = NoteGuesser.isNote(name);
        return result;
    }
}

