/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.impl.sql.compile.ColumnReference;
import org.apache.derby.impl.sql.compile.FromList;
import org.apache.derby.impl.sql.compile.GroupByColumn;
import org.apache.derby.impl.sql.compile.JavaToSQLValueNode;
import org.apache.derby.impl.sql.compile.OrderedColumnList;
import org.apache.derby.impl.sql.compile.PredicateList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.SelectNode;
import org.apache.derby.impl.sql.compile.SubqueryList;
import org.apache.derby.impl.sql.compile.ValueNode;

public class GroupByList
extends OrderedColumnList {
    int numGroupingColsAdded = 0;

    public void addGroupByColumn(GroupByColumn groupByColumn) {
        this.addElement(groupByColumn);
    }

    public GroupByColumn getGroupByColumn(int n) {
        return (GroupByColumn)this.elementAt(n);
    }

    public void printSubNodes(int n) {
    }

    public int getNumNeedToAddGroupingCols() {
        return this.numGroupingColsAdded;
    }

    public void bindGroupByColumns(SelectNode selectNode, Vector vector) throws StandardException {
        int n;
        FromList fromList = selectNode.getFromList();
        ResultColumnList resultColumnList = selectNode.getResultColumns();
        SubqueryList subqueryList = (SubqueryList)this.getNodeFactory().getNode(11, this.getContextManager());
        int n2 = 0;
        int n3 = this.size();
        if (n3 > 32677) {
            throw StandardException.newException("54004");
        }
        for (n = 0; n < n3; ++n) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(n);
            groupByColumn.bindExpression(fromList, subqueryList, vector);
        }
        n = resultColumnList.size();
        for (int i = 0; i < n3; ++i) {
            boolean bl = false;
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            for (int j = 0; j < n; ++j) {
                ColumnReference columnReference;
                ResultColumn resultColumn = (ResultColumn)resultColumnList.elementAt(j);
                if (!(resultColumn.getExpression() instanceof ColumnReference) || !(columnReference = (ColumnReference)resultColumn.getExpression()).isEquivalent(groupByColumn.getColumnExpression())) continue;
                groupByColumn.setColumnPosition(j + 1);
                resultColumn.markAsGroupingColumn();
                bl = true;
                break;
            }
            if (!bl && !selectNode.hasDistinct() && groupByColumn.getColumnExpression() instanceof ColumnReference) {
                ResultColumn resultColumn = (ResultColumn)this.getNodeFactory().getNode(80, groupByColumn.getColumnName(), groupByColumn.getColumnExpression().getClone(), this.getContextManager());
                resultColumn.setVirtualColumnId(resultColumnList.size() + 1);
                resultColumn.markGenerated();
                resultColumn.markAsGroupingColumn();
                resultColumnList.addElement(resultColumn);
                groupByColumn.setColumnPosition(resultColumnList.size());
                resultColumnList.setCountMismatchAllowed(true);
                ++n2;
            }
            if (!(groupByColumn.getColumnExpression() instanceof JavaToSQLValueNode)) continue;
            throw StandardException.newException("42Y30");
        }
        this.numGroupingColsAdded += n2;
    }

    public GroupByColumn findGroupingColumn(ValueNode valueNode) throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            if (!groupByColumn.getColumnExpression().isEquivalent(valueNode)) continue;
            return groupByColumn;
        }
        return null;
    }

    public void remapColumnReferencesToExpressions() throws StandardException {
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            ValueNode valueNode = groupByColumn.getColumnExpression().remapColumnReferencesToExpressions();
            groupByColumn.setColumnExpression(valueNode);
        }
    }

    public String toString() {
        return "";
    }

    public void preprocess(int n, FromList fromList, SubqueryList subqueryList, PredicateList predicateList) throws StandardException {
        for (int i = 0; i < this.size(); ++i) {
            GroupByColumn groupByColumn = (GroupByColumn)this.elementAt(i);
            groupByColumn.setColumnExpression(groupByColumn.getColumnExpression().preprocess(n, fromList, subqueryList, predicateList));
        }
    }
}

