/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AutoProgressor;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.RecordReader;
import org.apache.hadoop.hive.ql.exec.RecordWriter;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.StringUtils;

public class ScriptOperator
extends Operator<ScriptDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final transient LongWritable deserialize_error_count = new LongWritable();
    private final transient LongWritable serialize_error_count = new LongWritable();
    transient Thread outThread = null;
    transient Thread errThread = null;
    transient Process scriptPid = null;
    transient Configuration hconf;
    transient Serializer scriptInputSerializer;
    transient Deserializer scriptOutputDeserializer;
    volatile transient Throwable scriptError = null;
    transient RecordWriter scriptOutWriter = null;
    static final String IO_EXCEPTION_BROKEN_PIPE_STRING = "Broken pipe";
    transient AutoProgressor autoProgressor;
    transient boolean firstRow;

    static String safeEnvVarName(String var) {
        StringBuilder safe = new StringBuilder();
        int len = var.length();
        for (int i = 0; i < len; ++i) {
            int c = var.charAt(i);
            int s = c >= 48 && c <= 57 || c >= 65 && c <= 90 || c >= 97 && c <= 122 ? c : 95;
            safe.append((char)s);
        }
        return safe.toString();
    }

    static void addJobConfToEnvironment(Configuration conf, Map<String, String> env) {
        for (Map.Entry en : conf) {
            String name = (String)en.getKey();
            String value = conf.get(name);
            name = ScriptOperator.safeEnvVarName(name);
            env.put(name, value);
        }
    }

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        this.firstRow = true;
        this.statsMap.put(Counter.DESERIALIZE_ERRORS, this.deserialize_error_count);
        this.statsMap.put(Counter.SERIALIZE_ERRORS, this.serialize_error_count);
        try {
            this.hconf = hconf;
            this.scriptOutputDeserializer = ((ScriptDesc)this.conf).getScriptOutputInfo().getDeserializerClass().newInstance();
            this.scriptOutputDeserializer.initialize(hconf, ((ScriptDesc)this.conf).getScriptOutputInfo().getProperties());
            this.scriptInputSerializer = (Serializer)((Object)((ScriptDesc)this.conf).getScriptInputInfo().getDeserializerClass().newInstance());
            this.scriptInputSerializer.initialize(hconf, ((ScriptDesc)this.conf).getScriptInputInfo().getProperties());
            this.outputObjInspector = this.scriptOutputDeserializer.getObjectInspector();
            this.initializeChildren(hconf);
        }
        catch (Exception e) {
            throw new HiveException("Cannot initialize ScriptOperator", e);
        }
    }

    boolean isBrokenPipeException(IOException e) {
        return e.getMessage().compareToIgnoreCase(IO_EXCEPTION_BROKEN_PIPE_STRING) == 0;
    }

    boolean allowPartialConsumption() {
        return HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.ALLOWPARTIALCONSUMP);
    }

    void displayBrokenPipeInfo() {
        this.LOG.info((Object)"The script did not consume all input data. This is considered as an error.");
        this.LOG.info((Object)("set " + HiveConf.ConfVars.ALLOWPARTIALCONSUMP.toString() + "=true; to ignore it."));
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        if (this.firstRow) {
            this.firstRow = false;
            try {
                String[] cmdArgs = ScriptOperator.splitArgs(((ScriptDesc)this.conf).getScriptCmd());
                String prog = cmdArgs[0];
                File currentDir = new File(".").getAbsoluteFile();
                if (!new File(prog).isAbsolute()) {
                    PathFinder finder = new PathFinder("PATH");
                    finder.prependPathComponent(currentDir.toString());
                    File f = finder.getAbsolutePath(prog);
                    if (f != null) {
                        cmdArgs[0] = f.getAbsolutePath();
                    }
                    f = null;
                }
                String[] wrappedCmdArgs = this.addWrapper(cmdArgs);
                this.LOG.info((Object)("Executing " + Arrays.asList(wrappedCmdArgs)));
                this.LOG.info((Object)("tablename=" + this.hconf.get(HiveConf.ConfVars.HIVETABLENAME.varname)));
                this.LOG.info((Object)("partname=" + this.hconf.get(HiveConf.ConfVars.HIVEPARTITIONNAME.varname)));
                this.LOG.info((Object)("alias=" + this.alias));
                ProcessBuilder pb = new ProcessBuilder(wrappedCmdArgs);
                Map<String, String> env = pb.environment();
                ScriptOperator.addJobConfToEnvironment(this.hconf, env);
                env.put(ScriptOperator.safeEnvVarName(HiveConf.ConfVars.HIVEALIAS.varname), String.valueOf(this.alias));
                String idEnvVarName = HiveConf.getVar(this.hconf, HiveConf.ConfVars.HIVESCRIPTIDENVVAR);
                String idEnvVarVal = this.getOperatorId();
                env.put(ScriptOperator.safeEnvVarName(idEnvVarName), idEnvVarVal);
                this.scriptPid = pb.start();
                DataOutputStream scriptOut = new DataOutputStream(new BufferedOutputStream(this.scriptPid.getOutputStream()));
                DataInputStream scriptIn = new DataInputStream(new BufferedInputStream(this.scriptPid.getInputStream()));
                DataInputStream scriptErr = new DataInputStream(new BufferedInputStream(this.scriptPid.getErrorStream()));
                this.scriptOutWriter = ((ScriptDesc)this.conf).getInRecordWriterClass().newInstance();
                this.scriptOutWriter.initialize(scriptOut, this.hconf);
                RecordReader scriptOutputReader = ((ScriptDesc)this.conf).getOutRecordReaderClass().newInstance();
                scriptOutputReader.initialize(scriptIn, this.hconf, ((ScriptDesc)this.conf).getScriptOutputInfo().getProperties());
                this.outThread = new StreamThread(scriptOutputReader, new OutputStreamProcessor(this.scriptOutputDeserializer.getObjectInspector()), "OutputProcessor");
                RecordReader scriptErrReader = ((ScriptDesc)this.conf).getErrRecordReaderClass().newInstance();
                scriptErrReader.initialize(scriptErr, this.hconf, ((ScriptDesc)this.conf).getScriptErrInfo().getProperties());
                this.errThread = new StreamThread(scriptErrReader, new ErrorStreamProcessor(HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.SCRIPTERRORLIMIT)), "ErrorProcessor");
                if (HiveConf.getBoolVar(this.hconf, HiveConf.ConfVars.HIVESCRIPTAUTOPROGRESS)) {
                    this.autoProgressor = new AutoProgressor(this.getClass().getName(), this.reporter, Utilities.getDefaultNotificationInterval(this.hconf), HiveConf.getIntVar(this.hconf, HiveConf.ConfVars.HIVES_AUTO_PROGRESS_TIMEOUT) * 1000);
                    this.autoProgressor.go();
                }
                this.outThread.start();
                this.errThread.start();
            }
            catch (Exception e) {
                throw new HiveException("Cannot initialize ScriptOperator", e);
            }
        }
        if (this.scriptError != null) {
            throw new HiveException(this.scriptError);
        }
        try {
            Writable res = this.scriptInputSerializer.serialize(row, this.inputObjInspectors[tag]);
            this.scriptOutWriter.write(res);
        }
        catch (SerDeException e) {
            this.LOG.error((Object)("Error in serializing the row: " + e.getMessage()));
            this.scriptError = e;
            this.serialize_error_count.set(this.serialize_error_count.get() + 1L);
            throw new HiveException(e);
        }
        catch (IOException e) {
            if (this.isBrokenPipeException(e) && this.allowPartialConsumption()) {
                this.setDone(true);
                this.LOG.warn((Object)"Got broken pipe during write: ignoring exception and setting operator to done");
            }
            this.LOG.error((Object)("Error in writing to script: " + e.getMessage()));
            if (this.isBrokenPipeException(e)) {
                this.displayBrokenPipeInfo();
            }
            this.scriptError = e;
            throw new HiveException(e);
        }
    }

    @Override
    public void close(boolean abort) throws HiveException {
        boolean new_abort = abort;
        if (!abort) {
            if (this.scriptError != null) {
                throw new HiveException(this.scriptError);
            }
            try {
                try {
                    if (this.scriptOutWriter != null) {
                        this.scriptOutWriter.close();
                    }
                }
                catch (IOException e) {
                    if (this.isBrokenPipeException(e) && this.allowPartialConsumption()) {
                        this.LOG.warn((Object)"Got broken pipe: ignoring exception");
                    }
                    if (this.isBrokenPipeException(e)) {
                        this.displayBrokenPipeInfo();
                    }
                    throw e;
                }
                int exitVal = 0;
                if (this.scriptPid != null) {
                    exitVal = this.scriptPid.waitFor();
                }
                if (exitVal != 0) {
                    this.LOG.error((Object)("Script failed with code " + exitVal));
                    new_abort = true;
                }
            }
            catch (IOException e) {
                this.LOG.error((Object)("Got ioexception: " + e.getMessage()));
                e.printStackTrace();
                new_abort = true;
            }
            catch (InterruptedException e) {}
        } else {
            try {
                final Thread mythread = Thread.currentThread();
                Timer timer = new Timer(true);
                timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        mythread.interrupt();
                    }
                }, 1000L);
                int exitVal = 0;
                if (this.scriptPid != null) {
                    this.scriptPid.waitFor();
                }
                timer.cancel();
                this.LOG.error((Object)("Script exited with code " + exitVal));
            }
            catch (InterruptedException e) {
                this.LOG.error((Object)"Script has not exited yet. It will be killed.");
            }
        }
        try {
            if (this.outThread != null) {
                this.outThread.join(0L);
            }
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception in closing outThread: " + StringUtils.stringifyException((Throwable)e)));
        }
        try {
            if (this.errThread != null) {
                this.errThread.join(0L);
            }
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception in closing errThread: " + StringUtils.stringifyException((Throwable)e)));
        }
        try {
            if (this.scriptPid != null) {
                this.scriptPid.destroy();
            }
        }
        catch (Exception e) {
            this.LOG.warn((Object)("Exception in destroying scriptPid: " + StringUtils.stringifyException((Throwable)e)));
        }
        super.close(new_abort);
        if (new_abort && !abort) {
            throw new HiveException("Hit error while closing ..");
        }
    }

    protected String[] addWrapper(String[] inArgs) {
        int i;
        String wrapper = HiveConf.getVar(this.hconf, HiveConf.ConfVars.SCRIPTWRAPPER);
        if (wrapper == null) {
            return inArgs;
        }
        String[] wrapComponents = ScriptOperator.splitArgs(wrapper);
        int totallength = wrapComponents.length + inArgs.length;
        String[] finalArgv = new String[totallength];
        for (i = 0; i < wrapComponents.length; ++i) {
            finalArgv[i] = wrapComponents[i];
        }
        for (i = 0; i < inArgs.length; ++i) {
            finalArgv[wrapComponents.length + i] = inArgs[i];
        }
        return finalArgv;
    }

    public static String[] splitArgs(String args) {
        boolean OUTSIDE = true;
        int SINGLEQ = 2;
        int DOUBLEQ = 3;
        ArrayList<String> argList = new ArrayList<String>();
        char[] ch = args.toCharArray();
        int clen = ch.length;
        int state = 1;
        int argstart = 0;
        for (int c = 0; c <= clen; ++c) {
            boolean last = c == clen;
            int lastState = state;
            boolean endToken = false;
            if (!last) {
                if (ch[c] == '\'') {
                    if (state == 1) {
                        state = 2;
                    } else if (state == 2) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == '\"') {
                    if (state == 1) {
                        state = 3;
                    } else if (state == 3) {
                        state = 1;
                    }
                    endToken = state != lastState;
                } else if (ch[c] == ' ' && state == 1) {
                    endToken = true;
                }
            }
            if (!last && !endToken) continue;
            if (c != argstart) {
                String a = args.substring(argstart, c);
                argList.add(a);
            }
            argstart = c + 1;
            lastState = state;
        }
        return argList.toArray(new String[0]);
    }

    @Override
    public String getName() {
        return "SCR";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.SCRIPT;
    }

    class StreamThread
    extends Thread {
        RecordReader in;
        StreamProcessor proc;
        String name;

        StreamThread(RecordReader in, StreamProcessor proc, String name) {
            this.in = in;
            this.proc = proc;
            this.name = name;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                long bytes;
                Writable row = this.in.createRow();
                while ((bytes = (long)this.in.next(row)) > 0L) {
                    this.proc.processLine(row);
                }
                ScriptOperator.this.LOG.info((Object)("StreamThread " + this.name + " done"));
            }
            catch (Throwable th) {
                ScriptOperator.this.scriptError = th;
                ScriptOperator.this.LOG.warn((Object)("Exception in StreamThread.run(): " + th.getMessage() + "\nCause: " + th.getCause()));
                ScriptOperator.this.LOG.warn((Object)StringUtils.stringifyException((Throwable)th));
            }
            finally {
                try {
                    if (this.in != null) {
                        this.in.close();
                    }
                    this.proc.close();
                }
                catch (Exception e) {
                    ScriptOperator.this.LOG.warn((Object)(this.name + ": error in closing .."));
                    ScriptOperator.this.LOG.warn((Object)StringUtils.stringifyException((Throwable)e));
                }
            }
        }
    }

    class ErrorStreamProcessor
    implements StreamProcessor {
        private long bytesCopied = 0L;
        private final long maxBytes;
        private long lastReportTime;

        public ErrorStreamProcessor(int maxBytes) {
            this.maxBytes = maxBytes;
            this.lastReportTime = 0L;
        }

        @Override
        public void processLine(Writable line) throws HiveException {
            String stringLine = line.toString();
            int len = 0;
            if (line instanceof Text) {
                len = ((Text)line).getLength();
            } else if (line instanceof BytesWritable) {
                len = ((BytesWritable)line).getSize();
            }
            long now = System.currentTimeMillis();
            if (now - this.lastReportTime > 60000L && ScriptOperator.this.reporter != null) {
                ScriptOperator.this.LOG.info((Object)"ErrorStreamProcessor calling reporter.progress()");
                this.lastReportTime = now;
                ScriptOperator.this.reporter.progress();
            }
            if (this.maxBytes < 0L || this.bytesCopied < this.maxBytes) {
                System.err.println(stringLine);
            }
            if (this.bytesCopied < this.maxBytes && this.bytesCopied + (long)len >= this.maxBytes) {
                System.err.println("Operator " + ScriptOperator.this.id + " " + ScriptOperator.this.getName() + ": exceeding stderr limit of " + this.maxBytes + " bytes, will truncate stderr messages.");
            }
            this.bytesCopied += (long)len;
        }

        @Override
        public void close() {
        }
    }

    class OutputStreamProcessor
    implements StreamProcessor {
        Object row;
        ObjectInspector rowInspector;

        public OutputStreamProcessor(ObjectInspector rowInspector) {
            this.rowInspector = rowInspector;
        }

        @Override
        public void processLine(Writable line) throws HiveException {
            try {
                this.row = ScriptOperator.this.scriptOutputDeserializer.deserialize(line);
            }
            catch (SerDeException e) {
                ScriptOperator.this.deserialize_error_count.set(ScriptOperator.this.deserialize_error_count.get() + 1L);
                return;
            }
            ScriptOperator.this.forward(this.row, this.rowInspector);
        }

        @Override
        public void close() {
        }
    }

    static interface StreamProcessor {
        public void processLine(Writable var1) throws HiveException;

        public void close() throws HiveException;
    }

    public class PathFinder {
        String pathenv;
        String pathSep;
        String fileSep;

        public PathFinder(String envpath) {
            this.pathenv = System.getenv(envpath);
            this.pathSep = System.getProperty("path.separator");
            this.fileSep = System.getProperty("file.separator");
        }

        public void prependPathComponent(String str) {
            this.pathenv = str + this.pathSep + this.pathenv;
        }

        public File getAbsolutePath(String filename) {
            if (this.pathenv == null || this.pathSep == null || this.fileSep == null) {
                return null;
            }
            int val = -1;
            String classvalue = this.pathenv + this.pathSep;
            while ((val = classvalue.indexOf(this.pathSep)) >= 0 && classvalue.length() > 0) {
                String entry = classvalue.substring(0, val).trim();
                File f = new File(entry);
                try {
                    if (f.isDirectory()) {
                        f = new File(entry + this.fileSep + filename);
                    }
                    if (f.isFile() && f.canRead()) {
                        return f;
                    }
                }
                catch (Exception exp) {
                    // empty catch block
                }
                classvalue = classvalue.substring(val + 1).trim();
            }
            return null;
        }
    }

    public static enum Counter {
        DESERIALIZE_ERRORS,
        SERIALIZE_ERRORS;

    }
}

