/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.metadata.annotations;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.datanucleus.ClassConstants;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.MetaDataManager;
import org.datanucleus.metadata.PackageMetaData;
import org.datanucleus.metadata.annotations.AnnotationManager;
import org.datanucleus.metadata.annotations.AnnotationReader;
import org.datanucleus.metadata.annotations.ClassAnnotationHandler;
import org.datanucleus.metadata.annotations.MemberAnnotationHandler;
import org.datanucleus.plugin.ConfigurationElement;
import org.datanucleus.plugin.PluginManager;
import org.datanucleus.util.Localiser;
import org.datanucleus.util.NucleusLogger;

public class AnnotationManagerImpl
implements AnnotationManager {
    protected static final Localiser LOCALISER = Localiser.getInstance("org.datanucleus.Localisation", ClassConstants.NUCLEUS_CONTEXT_LOADER);
    protected final MetaDataManager metadataMgr;
    Map<String, String> annotationReaderLookup = new HashMap<String, String>();
    Map<String, AnnotationReader> annotationReaders = new HashMap<String, AnnotationReader>();
    Set<String> classAnnotationHandlerAnnotations = null;
    Map<String, ClassAnnotationHandler> classAnnotationHandlers = null;
    Set<String> memberAnnotationHandlerAnnotations = null;
    Map<String, MemberAnnotationHandler> memberAnnotationHandlers = null;

    public AnnotationManagerImpl(MetaDataManager metadataMgr) {
        int i;
        this.metadataMgr = metadataMgr;
        PluginManager pluginMgr = metadataMgr.getNucleusContext().getPluginManager();
        ConfigurationElement[] elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.annotations", (String)null, (String)null);
        if (elems != null) {
            for (i = 0; i < elems.length; ++i) {
                this.annotationReaderLookup.put(elems[i].getAttribute("annotation-class"), elems[i].getAttribute("reader"));
            }
        }
        if ((elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.class_annotation_handler", (String)null, (String)null)) != null && elems.length > 0) {
            this.classAnnotationHandlerAnnotations = new HashSet<String>(elems.length);
            this.classAnnotationHandlers = new HashMap<String, ClassAnnotationHandler>(elems.length);
            for (i = 0; i < elems.length; ++i) {
                this.classAnnotationHandlerAnnotations.add(elems[i].getAttribute("annotation-class"));
            }
        }
        if ((elems = pluginMgr.getConfigurationElementsForExtension("org.datanucleus.member_annotation_handler", (String)null, (String)null)) != null && elems.length > 0) {
            this.memberAnnotationHandlerAnnotations = new HashSet<String>(elems.length);
            this.memberAnnotationHandlers = new HashMap<String, MemberAnnotationHandler>(elems.length);
            for (i = 0; i < elems.length; ++i) {
                this.memberAnnotationHandlerAnnotations.add(elems[i].getAttribute("annotation-class"));
            }
        }
    }

    public AbstractClassMetaData getMetaDataForClass(Class cls, PackageMetaData pmd, ClassLoaderResolver clr) {
        if (cls == null) {
            return null;
        }
        Annotation[] annotations = cls.getAnnotations();
        if (annotations == null || annotations.length == 0) {
            return null;
        }
        String readerClassName = null;
        for (int i = 0; i < annotations.length; ++i) {
            String reader = this.annotationReaderLookup.get(annotations[i].annotationType().getName());
            if (reader == null) continue;
            readerClassName = reader;
            break;
        }
        if (readerClassName == null) {
            NucleusLogger.METADATA.debug(LOCALISER.msg("044202", (Object)cls.getName()));
            return null;
        }
        AnnotationReader reader = this.annotationReaders.get(readerClassName);
        if (reader == null) {
            try {
                Class[] ctrArgs = new Class[]{ClassConstants.METADATA_MANAGER};
                Object[] ctrParams = new Object[]{this.metadataMgr};
                PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                reader = (AnnotationReader)pluginMgr.createExecutableExtension("org.datanucleus.annotations", "reader", readerClassName, "reader", ctrArgs, ctrParams);
                this.annotationReaders.put(readerClassName, reader);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn(LOCALISER.msg("MetaData.AnnotationReaderNotFound", (Object)readerClassName));
                return null;
            }
        }
        return reader.getMetaDataForClass(cls, pmd, clr);
    }

    public boolean getClassAnnotationHasHandler(String annotationName) {
        return this.classAnnotationHandlerAnnotations != null && this.classAnnotationHandlerAnnotations.contains(annotationName);
    }

    public boolean getMemberAnnotationHasHandler(String annotationName) {
        return this.memberAnnotationHandlerAnnotations != null && this.memberAnnotationHandlerAnnotations.contains(annotationName);
    }

    public ClassAnnotationHandler getHandlerForClassAnnotation(String annotationName) {
        if (this.classAnnotationHandlerAnnotations == null || !this.classAnnotationHandlerAnnotations.contains(annotationName)) {
            return null;
        }
        ClassAnnotationHandler handler = this.classAnnotationHandlers.get(annotationName);
        if (handler == null) {
            try {
                PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                handler = (ClassAnnotationHandler)pluginMgr.createExecutableExtension("org.datanucleus.class_annotation_handler", "annotation-class", annotationName, "handler", null, null);
                this.classAnnotationHandlers.put(annotationName, handler);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn(LOCALISER.msg("MetaData.ClassAnnotationHandlerNotFound", (Object)annotationName));
                return null;
            }
        }
        return handler;
    }

    public MemberAnnotationHandler getHandlerForMemberAnnotation(String annotationName) {
        if (this.memberAnnotationHandlerAnnotations == null || !this.memberAnnotationHandlerAnnotations.contains(annotationName)) {
            return null;
        }
        MemberAnnotationHandler handler = this.memberAnnotationHandlers.get(annotationName);
        if (handler == null) {
            try {
                PluginManager pluginMgr = this.metadataMgr.getNucleusContext().getPluginManager();
                handler = (MemberAnnotationHandler)pluginMgr.createExecutableExtension("org.datanucleus.member_annotation_handler", "annotation-class", annotationName, "handler", null, null);
                this.memberAnnotationHandlers.put(annotationName, handler);
            }
            catch (Exception e) {
                NucleusLogger.METADATA.warn(LOCALISER.msg("MetaData.MemberAnnotationHandlerNotFound", (Object)annotationName));
                return null;
            }
        }
        return handler;
    }
}

