/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bson.types.BSONTimestamp;
import org.bson.types.Binary;
import org.bson.types.Code;
import org.bson.types.MaxKey;
import org.bson.types.MinKey;
import org.bson.types.ObjectId;
import org.bson.types.Symbol;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowDataUtil;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputMeta;
import org.pentaho.mongo.wrapper.MongoClientWrapper;
import org.pentaho.mongo.wrapper.MongoClientWrapperFactory;
import org.pentaho.mongo.wrapper.collection.MongoCollectionWrapper;
import org.pentaho.mongo.wrapper.cursor.MongoCursorWrapper;
import org.pentaho.mongo.wrapper.field.MongoArrayExpansion;
import org.pentaho.mongo.wrapper.field.MongoField;

public class MongoDbInputData
extends BaseStepData
implements StepDataInterface {
    public static final int MONGO_DEFAULT_PORT = 27017;
    public RowMetaInterface outputRowMeta;
    public MongoClientWrapper clientWrapper;
    public MongoCollectionWrapper collection;
    public MongoCursorWrapper cursor;
    Iterator<DBObject> m_pipelineResult;
    private List<MongoField> m_userFields;
    private MongoArrayExpansion m_expansionHandler;

    protected static MongoArrayExpansion checkFieldPaths(List<MongoField> normalFields, RowMetaInterface outputRowMeta) throws KettleException {
        String expansion = null;
        ArrayList<MongoField> normalList = new ArrayList<MongoField>();
        ArrayList<MongoField> expansionList = new ArrayList<MongoField>();
        for (MongoField f : normalFields) {
            String path = f.m_fieldPath;
            if (path != null && path.lastIndexOf("[*]") >= 0) {
                if (path.indexOf("[*]") != path.lastIndexOf("[*]")) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoInput.ErrorMessage.PathContainsMultipleExpansions", (String[])new String[]{path}));
                }
                String pathPart = path.substring(0, path.lastIndexOf("[*]") + 3);
                if (expansion == null) {
                    expansion = pathPart;
                } else if (!expansion.equals(pathPart)) {
                    throw new KettleException(BaseMessages.getString(MongoDbInputMeta.PKG, (String)"MongoDbInput.ErrorMessage.MutipleDifferentExpansions", (String[])new String[0]));
                }
                expansionList.add(f);
                continue;
            }
            normalList.add(f);
        }
        normalFields.clear();
        for (MongoField f : normalList) {
            normalFields.add(f);
        }
        if (expansionList.size() > 0) {
            ArrayList<MongoField> subFields = new ArrayList<MongoField>();
            for (MongoField ef : expansionList) {
                MongoField subField = new MongoField();
                subField.m_fieldName = ef.m_fieldName;
                String path = ef.m_fieldPath;
                if (path.charAt(path.length() - 2) == '*') {
                    path = "dummy";
                } else {
                    path = path.substring(path.lastIndexOf("[*]") + 3, path.length());
                    path = "$" + path;
                }
                subField.m_fieldPath = path;
                subField.m_indexedVals = ef.m_indexedVals;
                subField.m_kettleType = ef.m_kettleType;
                subFields.add(subField);
            }
            MongoArrayExpansion exp = new MongoArrayExpansion(subFields);
            exp.m_expansionPath = expansion;
            exp.m_outputRowMeta = outputRowMeta;
            return exp;
        }
        return null;
    }

    public void init() throws KettleException {
        if (this.m_userFields != null) {
            this.m_expansionHandler = MongoDbInputData.checkFieldPaths(this.m_userFields, this.outputRowMeta);
            for (MongoField f : this.m_userFields) {
                int outputIndex = this.outputRowMeta.indexOfValue(f.m_fieldName);
                f.init(outputIndex);
            }
            if (this.m_expansionHandler != null) {
                this.m_expansionHandler.init();
            }
        }
    }

    public Object[][] mongoDocumentToKettle(DBObject mongoObj, VariableSpace space) throws KettleException {
        Object[][] result = null;
        if (this.m_expansionHandler != null) {
            this.m_expansionHandler.reset(space);
            result = mongoObj instanceof BasicDBObject ? this.m_expansionHandler.convertToKettleValue((BasicDBObject)mongoObj, space) : this.m_expansionHandler.convertToKettleValue((BasicDBList)mongoObj, space);
        } else {
            result = new Object[1][];
        }
        Object[] normalData = RowDataUtil.allocateRowData((int)this.outputRowMeta.size());
        for (MongoField f : this.m_userFields) {
            Object value = null;
            f.reset(space);
            if (mongoObj instanceof BasicDBObject) {
                value = f.convertToKettleValue((BasicDBObject)mongoObj);
            } else if (mongoObj instanceof BasicDBList) {
                value = f.convertToKettleValue((BasicDBList)mongoObj);
            }
            normalData[f.m_outputIndex] = value;
        }
        if (this.m_expansionHandler == null) {
            result[0] = normalData;
        } else {
            for (int i = 0; i < result.length; ++i) {
                Object[] row = result[i];
                for (MongoField f : this.m_userFields) {
                    row[f.m_outputIndex] = normalData[f.m_outputIndex];
                }
            }
        }
        return result;
    }

    public static String cleansePath(String path) {
        String cleanKey;
        String key;
        int index = path.indexOf("${");
        int endIndex = 0;
        String tempStr = path;
        while (index >= 0 && (endIndex += tempStr.indexOf("}")) > 0 && endIndex > (index += 2) + 1 && endIndex + 1 < (path = path.replace(key = path.substring(index, endIndex), cleanKey = key.replace('.', '_'))).length()) {
            tempStr = path.substring(endIndex + 1, path.length());
            index = tempStr.indexOf("${");
            if (index <= 0) continue;
            index += endIndex;
        }
        return path;
    }

    public void setMongoFields(List<MongoField> fields) {
        this.m_userFields = new ArrayList<MongoField>();
        for (MongoField f : fields) {
            this.m_userFields.add(f.copy());
        }
    }

    protected static int mongoToKettleType(Object fieldValue) {
        if (fieldValue == null) {
            return 2;
        }
        if (fieldValue instanceof Symbol || fieldValue instanceof String || fieldValue instanceof Code || fieldValue instanceof ObjectId || fieldValue instanceof MinKey || fieldValue instanceof MaxKey) {
            return 2;
        }
        if (fieldValue instanceof Date) {
            return 3;
        }
        if (fieldValue instanceof Number) {
            try {
                Integer.parseInt(fieldValue.toString());
                return 5;
            }
            catch (NumberFormatException e) {
                return 1;
            }
        }
        if (fieldValue instanceof Binary) {
            return 8;
        }
        if (fieldValue instanceof BSONTimestamp) {
            return 5;
        }
        return 2;
    }

    protected static void setMinArrayIndexes(MongoField m) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        String temp = m.m_fieldPath;
        String tempComp = m.m_fieldName;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (!innerPart.equals("-")) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] compParts = innerComp.split(":");
            String replace = "[" + compParts[0] + "]";
            updated.append(replace);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldPath = updated.toString();
    }

    protected static void updateMaxArrayIndexes(MongoField m, String update) {
        if (m.m_fieldName.indexOf(91) < 0) {
            return;
        }
        if (m.m_fieldName.split("\\[").length != update.split("\\[").length) {
            throw new IllegalArgumentException("Field path and update path do not seem to contain the same number of array parts!");
        }
        String temp = m.m_fieldName;
        String tempComp = update;
        StringBuffer updated = new StringBuffer();
        while (temp.indexOf(91) >= 0) {
            String firstPart = temp.substring(0, temp.indexOf(91));
            String innerPart = temp.substring(temp.indexOf(91) + 1, temp.indexOf(93));
            if (innerPart.indexOf(58) < 0) {
                updated.append(temp);
                temp = "";
                break;
            }
            updated.append(firstPart);
            String innerComp = tempComp.substring(tempComp.indexOf(91) + 1, tempComp.indexOf(93));
            if (temp.indexOf(93) < temp.length() - 1) {
                temp = temp.substring(temp.indexOf(93) + 1, temp.length());
                tempComp = tempComp.substring(tempComp.indexOf(93) + 1, tempComp.length());
            } else {
                temp = "";
            }
            String[] origParts = innerPart.split(":");
            String[] compParts = innerComp.split(":");
            int origMax = Integer.parseInt(origParts[1]);
            int compMax = Integer.parseInt(compParts[1]);
            if (compMax > origMax) {
                String newRange = "[" + origParts[0] + ":" + compMax + "]";
                updated.append(newRange);
                continue;
            }
            String oldRange = "[" + innerPart + "]";
            updated.append(oldRange);
        }
        if (temp.length() > 0) {
            updated.append(temp);
        }
        m.m_fieldName = updated.toString();
    }

    public static boolean discoverFields(MongoDbInputMeta meta, VariableSpace vars, int docsToSample) throws KettleException {
        MongoClientWrapper clientWrapper = MongoClientWrapperFactory.createMongoClientWrapper(meta, vars, null);
        try {
            List<MongoField> discoveredFields;
            String db = vars.environmentSubstitute(meta.getDbName());
            String collection = vars.environmentSubstitute(meta.getCollection());
            String query = vars.environmentSubstitute(meta.getJsonQuery());
            String fields = vars.environmentSubstitute(meta.getFieldsName());
            int numDocsToSample = docsToSample;
            if (numDocsToSample < 1) {
                numDocsToSample = 100;
            }
            if ((discoveredFields = clientWrapper.discoverFields(db, collection, query, fields, meta.getQueryIsPipeline(), numDocsToSample)).size() > 0) {
                meta.setMongoFields(discoveredFields);
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            if (e instanceof KettleException) {
                throw (KettleException)((Object)e);
            }
            throw new KettleException("Unable to discover fields from MongoDB", (Throwable)e);
        }
        finally {
            clientWrapper.dispose();
        }
        return false;
    }

    public static String indexedValsList(List<String> indexedVals) {
        StringBuffer temp = new StringBuffer();
        for (int i = 0; i < indexedVals.size(); ++i) {
            temp.append(indexedVals.get(i));
            if (i >= indexedVals.size() - 1) continue;
            temp.append(",");
        }
        return temp.toString();
    }

    public static List<String> indexedValsList(String indexedVals) {
        String[] parts = indexedVals.split(",");
        ArrayList<String> list = new ArrayList<String>();
        for (String s : parts) {
            list.add(s.trim());
        }
        return list;
    }
}

