/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.mongodbinput;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.steps.mongodb.MongoDbMeta;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInput;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.mongo.wrapper.field.MongoField;
import org.w3c.dom.Node;

@Step(id="MongoDbInput", image="mongodb-input.png", name="MongoDB Input", description="Reads from a Mongo DB collection", categoryDescription="Big Data")
public class MongoDbInputMeta
extends MongoDbMeta {
    protected static Class<?> PKG = MongoDbInputMeta.class;
    private String jsonFieldName;
    private String fields;
    private boolean m_kerberos;
    private String jsonQuery;
    private boolean m_aggPipeline = false;
    private boolean m_outputJson = true;
    private List<MongoField> m_fields;
    private boolean m_executeForEachIncomingRow = false;

    public void setMongoFields(List<MongoField> fields) {
        this.m_fields = fields;
    }

    public List<MongoField> getMongoFields() {
        return this.m_fields;
    }

    public void setExecuteForEachIncomingRow(boolean e) {
        this.m_executeForEachIncomingRow = e;
    }

    public boolean getExecuteForEachIncomingRow() {
        return this.m_executeForEachIncomingRow;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public Object clone() {
        MongoDbInputMeta retval = (MongoDbInputMeta)((Object)super.clone());
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            String tags;
            Node mongo_fields;
            String executeForEachR;
            this.setHostnames(XMLHandler.getTagValue((Node)stepnode, (String)"hostname"));
            this.setPort(XMLHandler.getTagValue((Node)stepnode, (String)"port"));
            this.setDbName(XMLHandler.getTagValue((Node)stepnode, (String)"db_name"));
            this.fields = XMLHandler.getTagValue((Node)stepnode, (String)"fields_name");
            this.setCollection(XMLHandler.getTagValue((Node)stepnode, (String)"collection"));
            this.jsonFieldName = XMLHandler.getTagValue((Node)stepnode, (String)"json_field_name");
            this.jsonQuery = XMLHandler.getTagValue((Node)stepnode, (String)"json_query");
            this.setAuthenticationUser(XMLHandler.getTagValue((Node)stepnode, (String)"auth_user"));
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)stepnode, (String)"auth_password")));
            this.m_kerberos = false;
            String useKerberos = XMLHandler.getTagValue((Node)stepnode, (String)"auth_kerberos");
            if (!Const.isEmpty((String)useKerberos)) {
                this.m_kerberos = useKerberos.equalsIgnoreCase("Y");
            }
            this.setConnectTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"connect_timeout"));
            this.setSocketTimeout(XMLHandler.getTagValue((Node)stepnode, (String)"socket_timeout"));
            this.setReadPreference(XMLHandler.getTagValue((Node)stepnode, (String)"read_preference"));
            this.m_outputJson = true;
            String outputJson = XMLHandler.getTagValue((Node)stepnode, (String)"output_json");
            if (!Const.isEmpty((String)outputJson)) {
                this.m_outputJson = outputJson.equalsIgnoreCase("Y");
            }
            this.setUseAllReplicaSetMembers("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"use_all_replica_members")));
            String queryIsPipe = XMLHandler.getTagValue((Node)stepnode, (String)"query_is_pipeline");
            if (!Const.isEmpty((String)queryIsPipe)) {
                this.m_aggPipeline = queryIsPipe.equalsIgnoreCase("Y");
            }
            if (!Const.isEmpty((String)(executeForEachR = XMLHandler.getTagValue((Node)stepnode, (String)"execute_for_each_row")))) {
                this.m_executeForEachIncomingRow = executeForEachR.equalsIgnoreCase("Y");
            }
            if ((mongo_fields = XMLHandler.getSubNode((Node)stepnode, (String)"mongo_fields")) != null && XMLHandler.countNodes((Node)mongo_fields, (String)"mongo_field") > 0) {
                int nrfields = XMLHandler.countNodes((Node)mongo_fields, (String)"mongo_field");
                this.m_fields = new ArrayList<MongoField>();
                for (int i = 0; i < nrfields; ++i) {
                    Node fieldNode = XMLHandler.getSubNodeByNr((Node)mongo_fields, (String)"mongo_field", (int)i);
                    MongoField newField = new MongoField();
                    newField.m_fieldName = XMLHandler.getTagValue((Node)fieldNode, (String)"field_name");
                    newField.m_fieldPath = XMLHandler.getTagValue((Node)fieldNode, (String)"field_path");
                    newField.m_kettleType = XMLHandler.getTagValue((Node)fieldNode, (String)"field_type");
                    String indexedVals = XMLHandler.getTagValue((Node)fieldNode, (String)"indexed_vals");
                    if (indexedVals != null && indexedVals.length() > 0) {
                        newField.m_indexedVals = MongoDbInputData.indexedValsList(indexedVals);
                    }
                    this.m_fields.add(newField);
                }
            }
            if (!Const.isEmpty((String)(tags = XMLHandler.getTagValue((Node)stepnode, (String)"tag_sets")))) {
                String[] parts;
                this.setReadPrefTagSets(new ArrayList<String>());
                for (String p : parts = tags.split("#@#")) {
                    this.getReadPrefTagSets().add(p.trim());
                }
            }
        }
        catch (Exception e) {
            throw new KettleXMLException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToLoadStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void setDefault() {
        this.setHostnames("localhost");
        this.setPort("27017");
        this.setDbName("db");
        this.setCollection("collection");
        this.jsonFieldName = "json";
    }

    public void getFields(RowMetaInterface rowMeta, String origin, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (this.m_outputJson || this.m_fields == null || this.m_fields.size() == 0) {
            ValueMeta jsonValueMeta = new ValueMeta(this.jsonFieldName, 2);
            jsonValueMeta.setOrigin(origin);
            rowMeta.addValueMeta((ValueMetaInterface)jsonValueMeta);
        } else {
            for (MongoField f : this.m_fields) {
                ValueMeta vm = new ValueMeta();
                vm.setName(f.m_fieldName);
                vm.setOrigin(origin);
                vm.setType(ValueMeta.getType((String)f.m_kettleType));
                if (f.m_indexedVals != null) {
                    vm.setIndex(f.m_indexedVals.toArray());
                }
                rowMeta.addValueMeta((ValueMetaInterface)vm);
            }
        }
    }

    protected String tagSetsToString() {
        if (this.getReadPrefTagSets() != null && this.getReadPrefTagSets().size() > 0) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.getReadPrefTagSets().size(); ++i) {
                String s = this.getReadPrefTagSets().get(i);
                if (!(s = s.trim()).startsWith("{")) {
                    s = "{" + s;
                }
                if (!s.endsWith("}")) {
                    s = s + "}";
                }
                builder.append(s);
                if (i == this.getReadPrefTagSets().size() - 1) continue;
                builder.append("#@#");
            }
            return builder.toString();
        }
        return null;
    }

    public String getXML() {
        String tags;
        StringBuffer retval = new StringBuffer(300);
        retval.append("    ").append(XMLHandler.addTagValue((String)"hostname", (String)this.getHostnames()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"port", (String)this.getPort()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"use_all_replica_members", (boolean)this.getUseAllReplicaSetMembers()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"db_name", (String)this.getDbName()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"fields_name", (String)this.fields));
        retval.append("    ").append(XMLHandler.addTagValue((String)"collection", (String)this.getCollection()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_field_name", (String)this.jsonFieldName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"json_query", (String)this.jsonQuery));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_user", (String)this.getAuthenticationUser()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getAuthenticationPassword())));
        retval.append("    ").append(XMLHandler.addTagValue((String)"auth_kerberos", (boolean)this.m_kerberos));
        retval.append("    ").append(XMLHandler.addTagValue((String)"connect_timeout", (String)this.getConnectTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"socket_timeout", (String)this.getSocketTimeout()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"read_preference", (String)this.getReadPreference()));
        retval.append("    ").append(XMLHandler.addTagValue((String)"output_json", (boolean)this.m_outputJson));
        retval.append("    ").append(XMLHandler.addTagValue((String)"query_is_pipeline", (boolean)this.m_aggPipeline));
        retval.append("    ").append(XMLHandler.addTagValue((String)"execute_for_each_row", (boolean)this.m_executeForEachIncomingRow));
        if (this.m_fields != null && this.m_fields.size() > 0) {
            retval.append("\n    ").append(XMLHandler.openTag((String)"mongo_fields"));
            for (MongoField f : this.m_fields) {
                retval.append("\n      ").append(XMLHandler.openTag((String)"mongo_field"));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_name", (String)f.m_fieldName));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_path", (String)f.m_fieldPath));
                retval.append("\n        ").append(XMLHandler.addTagValue((String)"field_type", (String)f.m_kettleType));
                if (f.m_indexedVals != null && f.m_indexedVals.size() > 0) {
                    retval.append("\n        ").append(XMLHandler.addTagValue((String)"indexed_vals", (String)MongoDbInputData.indexedValsList(f.m_indexedVals)));
                }
                retval.append("\n      ").append(XMLHandler.closeTag((String)"mongo_field"));
            }
            retval.append("\n    ").append(XMLHandler.closeTag((String)"mongo_fields"));
        }
        if (!Const.isEmpty((String)(tags = this.tagSetsToString()))) {
            retval.append("    ").append(XMLHandler.addTagValue((String)"tag_sets", (String)tags));
        }
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            String tags;
            this.setHostnames(rep.getStepAttributeString(id_step, "hostname"));
            this.setPort(rep.getStepAttributeString(id_step, "port"));
            this.setUseAllReplicaSetMembers(rep.getStepAttributeBoolean(id_step, 0, "use_all_replica_members"));
            this.setDbName(rep.getStepAttributeString(id_step, "db_name"));
            this.fields = rep.getStepAttributeString(id_step, "fields_name");
            this.setCollection(rep.getStepAttributeString(id_step, "collection"));
            this.jsonFieldName = rep.getStepAttributeString(id_step, "json_field_name");
            this.jsonQuery = rep.getStepAttributeString(id_step, "json_query");
            this.setAuthenticationUser(rep.getStepAttributeString(id_step, "auth_user"));
            this.setAuthenticationPassword(Encr.decryptPasswordOptionallyEncrypted((String)rep.getStepAttributeString(id_step, "auth_password")));
            this.m_kerberos = rep.getStepAttributeBoolean(id_step, "auth_kerberos");
            this.setConnectTimeout(rep.getStepAttributeString(id_step, "connect_timeout"));
            this.setSocketTimeout(rep.getStepAttributeString(id_step, "socket_timeout"));
            this.setReadPreference(rep.getStepAttributeString(id_step, "read_preference"));
            this.m_outputJson = rep.getStepAttributeBoolean(id_step, 0, "output_json");
            this.m_aggPipeline = rep.getStepAttributeBoolean(id_step, "query_is_pipeline");
            this.m_executeForEachIncomingRow = rep.getStepAttributeBoolean(id_step, "execute_for_each_row");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            if (nrfields > 0) {
                this.m_fields = new ArrayList<MongoField>();
                for (int i = 0; i < nrfields; ++i) {
                    MongoField newField = new MongoField();
                    newField.m_fieldName = rep.getStepAttributeString(id_step, i, "field_name");
                    newField.m_fieldPath = rep.getStepAttributeString(id_step, i, "field_path");
                    newField.m_kettleType = rep.getStepAttributeString(id_step, i, "field_type");
                    String indexedVals = rep.getStepAttributeString(id_step, i, "indexed_vals");
                    if (indexedVals != null && indexedVals.length() > 0) {
                        newField.m_indexedVals = MongoDbInputData.indexedValsList(indexedVals);
                    }
                    this.m_fields.add(newField);
                }
            }
            if (!Const.isEmpty((String)(tags = rep.getStepAttributeString(id_step, "tag_sets")))) {
                String[] parts;
                this.setReadPrefTagSets(new ArrayList<String>());
                for (String p : parts = tags.split("#@#")) {
                    this.getReadPrefTagSets().add(p.trim());
                }
            }
        }
        catch (Exception e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnexpectedErrorWhileReadingStepInfo", (String[])new String[0]), (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            String tags;
            rep.saveStepAttribute(id_transformation, id_step, "hostname", this.getHostnames());
            rep.saveStepAttribute(id_transformation, id_step, "port", this.getPort());
            rep.saveStepAttribute(id_transformation, id_step, "use_all_replica_members", this.getUseAllReplicaSetMembers());
            rep.saveStepAttribute(id_transformation, id_step, "db_name", this.getDbName());
            rep.saveStepAttribute(id_transformation, id_step, "fields_name", this.fields);
            rep.saveStepAttribute(id_transformation, id_step, "collection", this.getCollection());
            rep.saveStepAttribute(id_transformation, id_step, "json_field_name", this.jsonFieldName);
            rep.saveStepAttribute(id_transformation, id_step, "json_query", this.jsonQuery);
            rep.saveStepAttribute(id_transformation, id_step, "auth_user", this.getAuthenticationUser());
            rep.saveStepAttribute(id_transformation, id_step, "auth_password", Encr.encryptPasswordIfNotUsingVariables((String)this.getAuthenticationPassword()));
            rep.saveStepAttribute(id_transformation, id_step, "auth_kerberos", this.m_kerberos);
            rep.saveStepAttribute(id_transformation, id_step, "connect_timeout", this.getConnectTimeout());
            rep.saveStepAttribute(id_transformation, id_step, "socket_timeout", this.getSocketTimeout());
            rep.saveStepAttribute(id_transformation, id_step, "read_preference", this.getReadPreference());
            rep.saveStepAttribute(id_transformation, id_step, 0, "output_json", this.m_outputJson);
            rep.saveStepAttribute(id_transformation, id_step, 0, "query_is_pipeline", this.m_aggPipeline);
            rep.saveStepAttribute(id_transformation, id_step, 0, "execute_for_each_row", this.m_executeForEachIncomingRow);
            if (this.m_fields != null && this.m_fields.size() > 0) {
                for (int i = 0; i < this.m_fields.size(); ++i) {
                    MongoField f = this.m_fields.get(i);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_name", f.m_fieldName);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_path", f.m_fieldPath);
                    rep.saveStepAttribute(id_transformation, id_step, i, "field_type", f.m_kettleType);
                    if (f.m_indexedVals == null || f.m_indexedVals.size() <= 0) continue;
                    String indexedVals = MongoDbInputData.indexedValsList(f.m_indexedVals);
                    rep.saveStepAttribute(id_transformation, id_step, i, "indexed_vals", indexedVals);
                }
            }
            if (!Const.isEmpty((String)(tags = this.tagSetsToString()))) {
                rep.saveStepAttribute(id_transformation, id_step, "tag_sets", tags);
            }
        }
        catch (KettleException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInputMeta.Exception.UnableToSaveStepInfo", (String[])new String[0]) + id_step, (Throwable)e);
        }
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta tr, Trans trans) {
        return new MongoDbInput(stepMeta, stepDataInterface, cnr, tr, trans);
    }

    public StepDataInterface getStepData() {
        return new MongoDbInputData();
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
    }

    public String getFieldsName() {
        return this.fields;
    }

    public void setFieldsName(String fields) {
        this.fields = fields;
    }

    public String getJsonFieldName() {
        return this.jsonFieldName;
    }

    public void setJsonFieldName(String jsonFieldName) {
        this.jsonFieldName = jsonFieldName;
    }

    @Override
    public void setUseKerberosAuthentication(boolean k) {
        this.m_kerberos = k;
    }

    @Override
    public boolean getUseKerberosAuthentication() {
        return this.m_kerberos;
    }

    public String getJsonQuery() {
        return this.jsonQuery;
    }

    public void setJsonQuery(String jsonQuery) {
        this.jsonQuery = jsonQuery;
    }

    public void setOutputJson(boolean outputJson) {
        this.m_outputJson = outputJson;
    }

    public boolean getOutputJson() {
        return this.m_outputJson;
    }

    public void setQueryIsPipeline(boolean q) {
        this.m_aggPipeline = q;
    }

    public boolean getQueryIsPipeline() {
        return this.m_aggPipeline;
    }
}

