/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.mongo.wrapper.field;

import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.bson.types.Binary;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaFactory;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.steps.mongodbinput.MongoDbInputData;

public class MongoField
implements Comparable<MongoField> {
    protected static Class<?> PKG = MongoField.class;
    public String m_fieldName = "";
    public String m_fieldPath = "";
    public String m_kettleType = "";
    public List<String> m_indexedVals;
    public transient String m_arrayIndexInfo;
    public transient int m_percentageOfSample = -1;
    public transient String m_occurenceFraction = "";
    public transient Class<?> m_mongoType;
    public transient boolean m_disparateTypes;
    public int m_outputIndex;
    private ValueMetaInterface m_tempValueMeta;
    private List<String> m_pathParts;
    private List<String> m_tempParts;

    public MongoField copy() {
        MongoField newF = new MongoField();
        newF.m_fieldName = this.m_fieldName;
        newF.m_fieldPath = this.m_fieldPath;
        newF.m_kettleType = this.m_kettleType;
        newF.m_indexedVals = this.m_indexedVals;
        return newF;
    }

    public void init(int outputIndex) throws KettleException {
        if (Const.isEmpty((String)this.m_fieldPath)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbOutput.Messages.MongoField.Error.NoPathSet", (String[])new String[0]));
        }
        if (this.m_pathParts != null) {
            return;
        }
        String fieldPath = MongoDbInputData.cleansePath(this.m_fieldPath);
        String[] temp = fieldPath.split("\\.");
        this.m_pathParts = new ArrayList<String>();
        for (String part : temp) {
            this.m_pathParts.add(part);
        }
        if (this.m_pathParts.get(0).equals("$")) {
            this.m_pathParts.remove(0);
        } else if (this.m_pathParts.get(0).startsWith("$[")) {
            String r = this.m_pathParts.get(0).substring(1, this.m_pathParts.get(0).length());
            this.m_pathParts.set(0, r);
        }
        this.m_tempParts = new ArrayList<String>();
        this.m_tempValueMeta = ValueMetaFactory.createValueMeta((int)ValueMeta.getType((String)this.m_kettleType));
        this.m_outputIndex = outputIndex;
    }

    public void reset(VariableSpace space) {
        this.m_tempParts.clear();
        for (String part : this.m_pathParts) {
            this.m_tempParts.add(space.environmentSubstitute(part));
        }
    }

    public Object getKettleValue(Object fieldValue) throws KettleException {
        switch (this.m_tempValueMeta.getType()) {
            case 6: {
                fieldValue = fieldValue instanceof Number ? BigDecimal.valueOf(((Number)fieldValue).doubleValue()) : (fieldValue instanceof Date ? new BigDecimal(((Date)fieldValue).getTime()) : new BigDecimal(fieldValue.toString()));
                return this.m_tempValueMeta.getBigNumber(fieldValue);
            }
            case 8: {
                fieldValue = fieldValue instanceof Binary ? (Object)((Binary)fieldValue).getData() : (Object)fieldValue.toString().getBytes();
                return this.m_tempValueMeta.getBinary(fieldValue);
            }
            case 4: {
                fieldValue = fieldValue instanceof Number ? new Boolean(((Number)fieldValue).intValue() != 0) : (fieldValue instanceof Date ? new Boolean(((Date)fieldValue).getTime() != 0L) : new Boolean(fieldValue.toString().equalsIgnoreCase("Y") || fieldValue.toString().equalsIgnoreCase("T") || fieldValue.toString().equalsIgnoreCase("1")));
                return this.m_tempValueMeta.getBoolean(fieldValue);
            }
            case 3: {
                if (fieldValue instanceof Number) {
                    fieldValue = new Date(((Number)fieldValue).longValue());
                } else if (!(fieldValue instanceof Date)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.DateConversion", (String[])new String[]{fieldValue.toString()}));
                }
                return this.m_tempValueMeta.getDate(fieldValue);
            }
            case 5: {
                if (fieldValue instanceof Number) {
                    fieldValue = new Long(((Number)fieldValue).intValue());
                } else if (fieldValue instanceof Binary) {
                    byte[] b = ((Binary)fieldValue).getData();
                    String s = new String(b);
                    fieldValue = new Integer(s);
                } else {
                    fieldValue = new Integer(fieldValue.toString());
                }
                return this.m_tempValueMeta.getInteger(fieldValue);
            }
            case 1: {
                if (fieldValue instanceof Number) {
                    fieldValue = new Double(((Number)fieldValue).doubleValue());
                } else if (fieldValue instanceof Binary) {
                    byte[] b = ((Binary)fieldValue).getData();
                    String s = new String(b);
                    fieldValue = new Double(s);
                } else {
                    fieldValue = new Double(fieldValue.toString());
                }
                return this.m_tempValueMeta.getNumber(fieldValue);
            }
            case 2: {
                return this.m_tempValueMeta.getString(fieldValue);
            }
        }
        return null;
    }

    public Object convertToKettleValue(BasicDBObject mongoObject) throws KettleException {
        Object fieldValue;
        if (mongoObject == null) {
            return null;
        }
        if (this.m_tempParts.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathRecord", (String[])new String[0]));
        }
        String part = this.m_tempParts.remove(0);
        if (part.charAt(0) == '[') {
            return null;
        }
        if (part.indexOf(91) > 0) {
            String arrayPart = part.substring(part.indexOf(91));
            part = part.substring(0, part.indexOf(91));
            this.m_tempParts.add(0, arrayPart);
        }
        if ((fieldValue = mongoObject.get(part)) == null) {
            return null;
        }
        if (this.m_tempParts.size() == 0) {
            return this.getKettleValue(fieldValue);
        }
        if (fieldValue instanceof BasicDBObject) {
            return this.convertToKettleValue((BasicDBObject)fieldValue);
        }
        if (fieldValue instanceof BasicDBList) {
            return this.convertToKettleValue((BasicDBList)fieldValue);
        }
        return null;
    }

    public Object convertToKettleValue(BasicDBList mongoList) throws KettleException {
        if (mongoList == null) {
            return null;
        }
        if (this.m_tempParts.size() == 0) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.MalformedPathArray", (String[])new String[0]));
        }
        String part = this.m_tempParts.remove(0);
        if (part.charAt(0) != '[') {
            return null;
        }
        String index = part.substring(1, part.indexOf(93));
        int arrayI = 0;
        try {
            arrayI = Integer.parseInt(index.trim());
        }
        catch (NumberFormatException e) {
            throw new KettleException(BaseMessages.getString(PKG, (String)"MongoDbInput.ErrorMessage.UnableToParseArrayIndex", (String[])new String[]{index}));
        }
        if (part.indexOf(93) < part.length() - 1) {
            part = part.substring(part.indexOf(93) + 1, part.length());
            this.m_tempParts.add(0, part);
        }
        if (arrayI >= mongoList.size() || arrayI < 0) {
            return null;
        }
        Object element = mongoList.get(arrayI);
        if (element == null) {
            return null;
        }
        if (this.m_tempParts.size() == 0) {
            return this.getKettleValue(element);
        }
        if (element instanceof BasicDBObject) {
            return this.convertToKettleValue((BasicDBObject)element);
        }
        if (element instanceof BasicDBList) {
            return this.convertToKettleValue((BasicDBList)element);
        }
        return null;
    }

    @Override
    public int compareTo(MongoField comp) {
        return this.m_fieldName.compareTo(comp.m_fieldName);
    }
}

