/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.mdr.persistence.btreeimpl.btreestorage;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import org.netbeans.mdr.persistence.StorageException;
import org.netbeans.mdr.persistence.StoragePersistentDataException;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.BtreeDataFile;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.CachedPage;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.ContinuationBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.Converter;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.DeletedBtreeExtent;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.IntHolder;
import org.netbeans.mdr.persistence.btreeimpl.btreestorage.NormalBtreeExtent;

abstract class BtreeExtent {
    static final int NORMAL_MAGIC = 10794;
    static final int CONTINUATION_MAGIC = 27499;
    static final int DELETED_MAGIC = 24415;
    final short chunks;
    public static final int MAX_EXTENT_SIZE = 8192;
    int nextInChain;
    final int myChunkNum;
    boolean headerIsDirty;
    final BtreeDataFile owner;
    static final byte IS_NORMAL = 1;
    static final byte IS_CONTINUATION = 2;
    static final byte IS_DELETED = 3;
    static final String NORMAL_NAME = "normal";
    static final String CONTINUATION_NAME = "continuation";
    static final String DELETED_NAME = "deleted";
    public static final int DUMP_BASIC = 1;
    public static final int DUMP_KEY = 2;
    public static final int DUMP_DATA = 4;
    public static final int DUMP_DATA_CHECKSUM = 8;

    BtreeExtent(BtreeExtent src) {
        this.chunks = src.chunks;
        this.myChunkNum = src.myChunkNum;
        this.owner = src.owner;
        this.headerIsDirty = true;
    }

    BtreeExtent(BtreeDataFile file, int chunkNum, short numChunks) {
        this.owner = file;
        this.chunks = numChunks;
        this.myChunkNum = chunkNum;
        this.headerIsDirty = true;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static final BtreeExtent readExtent(BtreeDataFile dataFile, int chunkNum) throws StorageException {
        BtreeExtent extent = null;
        IntHolder offset = new IntHolder();
        CachedPage page = dataFile.getChunk(chunkNum, offset);
        try {
            short magic = Converter.readShort(page.contents, offset);
            short chunks = Converter.readShort(page.contents, offset);
            switch (magic) {
                case 10794: {
                    extent = new NormalBtreeExtent(dataFile, chunkNum, chunks);
                    break;
                }
                case 27499: {
                    extent = new ContinuationBtreeExtent(dataFile, chunkNum, chunks);
                    break;
                }
                case 24415: {
                    extent = new DeletedBtreeExtent(dataFile, chunkNum, chunks);
                    break;
                }
                default: {
                    throw new StoragePersistentDataException(MessageFormat.format("Bad Magic Number {0} in header at offset {1}", new Integer(magic), new Integer(chunkNum)));
                }
            }
            extent.nextInChain = Converter.readInt(page.contents, offset);
            extent.headerIsDirty = false;
            extent.readHeaderFromPage(page.contents, offset);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            page.unpin();
            throw throwable;
        }
        {
            Object var7_9 = null;
        }
        page.unpin();
        return extent;
    }

    abstract void readHeaderFromPage(byte[] var1, IntHolder var2);

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    final void writeHeader() throws StorageException {
        if (!this.headerIsDirty) {
            return;
        }
        IntHolder offst = new IntHolder();
        CachedPage page = this.owner.getChunk(this.myChunkNum, offst);
        try {
            page.setWritable();
            Converter.writeShort(page.contents, offst, this.getMagic());
            Converter.writeShort(page.contents, offst, this.chunks);
            Converter.writeInt(page.contents, offst, this.nextInChain);
            this.writeHeaderToPage(page, offst.getValue());
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            page.unpin();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        page.unpin();
        this.headerIsDirty = false;
    }

    protected abstract void writeHeaderToPage(CachedPage var1, int var2);

    abstract short getMagic();

    int getSize() {
        return this.chunks;
    }

    void setNext(int next) {
        if (this.nextInChain != next) {
            this.nextInChain = next;
            this.headerIsDirty = true;
        }
    }

    void setNext(BtreeExtent next) {
        this.setNext(next.myChunkNum);
    }

    int getNext() {
        return this.nextInChain;
    }

    int getOffset() {
        return this.myChunkNum;
    }

    abstract byte getType();

    abstract String getTypeName();

    static String getTypeName(int extentType) {
        switch (extentType) {
            case 1: {
                return NORMAL_NAME;
            }
            case 2: {
                return CONTINUATION_NAME;
            }
            case 3: {
                return DELETED_NAME;
            }
        }
        return "unknown";
    }

    void dump(int level, PrintWriter strm) throws StorageException {
        if ((level & 1) != 0) {
            strm.println("Extent: " + this.myChunkNum);
            strm.println("Type: " + this.getClass().getName());
            strm.println("Size: " + this.chunks);
            if (this.nextInChain > 0) {
                strm.println("Next: " + this.nextInChain);
            }
        }
    }

    static void dumpBytesAsHex(InputStream in, PrintWriter out, String indent) {
        try {
            int data;
            int position = 0;
            while ((data = in.read()) >= 0) {
                if (position >= 16) {
                    out.println();
                    position = 0;
                }
                if (position == 0) {
                    out.print(indent);
                } else {
                    out.print("  ");
                }
                String hex = Integer.toHexString(data);
                if (hex.length() == 1) {
                    hex = "0" + hex;
                }
                out.print(hex);
                ++position;
            }
            if (position > 0) {
                out.println();
            }
        }
        catch (IOException exc) {
            out.print("\n\nIO EXCEPTION!\n\n");
        }
    }
}

