/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import com.google.common.base.Charsets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.io.ReadaheadPool;
import org.apache.hadoop.io.SecureIOUtils;
import org.apache.hadoop.mapred.FadvisedChunkedFile;
import org.apache.hadoop.mapred.FadvisedFileRegion;
import org.apache.hadoop.mapred.IndexCache;
import org.apache.hadoop.mapred.IndexRecord;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapreduce.security.SecureShuffleUtils;
import org.apache.hadoop.mapreduce.security.token.JobTokenIdentifier;
import org.apache.hadoop.mapreduce.security.token.JobTokenSecretManager;
import org.apache.hadoop.mapreduce.task.reduce.ShuffleHeader;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.annotation.Metric;
import org.apache.hadoop.metrics2.annotation.Metrics;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MutableCounterInt;
import org.apache.hadoop.metrics2.lib.MutableCounterLong;
import org.apache.hadoop.metrics2.lib.MutableGaugeInt;
import org.apache.hadoop.security.ssl.SSLFactory;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.server.api.ApplicationInitializationContext;
import org.apache.hadoop.yarn.server.api.ApplicationTerminationContext;
import org.apache.hadoop.yarn.server.api.AuxiliaryService;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.ChannelBuffers;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelFutureListener;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipeline;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.Channels;
import org.jboss.netty.channel.ExceptionEvent;
import org.jboss.netty.channel.MessageEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.group.ChannelGroup;
import org.jboss.netty.channel.group.DefaultChannelGroup;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.handler.codec.frame.TooLongFrameException;
import org.jboss.netty.handler.codec.http.DefaultHttpResponse;
import org.jboss.netty.handler.codec.http.HttpChunkAggregator;
import org.jboss.netty.handler.codec.http.HttpMethod;
import org.jboss.netty.handler.codec.http.HttpRequest;
import org.jboss.netty.handler.codec.http.HttpRequestDecoder;
import org.jboss.netty.handler.codec.http.HttpResponse;
import org.jboss.netty.handler.codec.http.HttpResponseEncoder;
import org.jboss.netty.handler.codec.http.HttpResponseStatus;
import org.jboss.netty.handler.codec.http.HttpVersion;
import org.jboss.netty.handler.codec.http.QueryStringDecoder;
import org.jboss.netty.handler.ssl.SslHandler;
import org.jboss.netty.handler.stream.ChunkedWriteHandler;
import org.jboss.netty.util.CharsetUtil;

public class ShuffleHandler
extends AuxiliaryService {
    private static final Log LOG = LogFactory.getLog(ShuffleHandler.class);
    public static final String SHUFFLE_MANAGE_OS_CACHE = "mapreduce.shuffle.manage.os.cache";
    public static final boolean DEFAULT_SHUFFLE_MANAGE_OS_CACHE = true;
    public static final String SHUFFLE_READAHEAD_BYTES = "mapreduce.shuffle.readahead.bytes";
    public static final int DEFAULT_SHUFFLE_READAHEAD_BYTES = 0x400000;
    private static final Pattern IGNORABLE_ERROR_MESSAGE = Pattern.compile("^.*(?:connection.*reset|connection.*closed|broken.*pipe).*$", 2);
    private int port;
    private ChannelFactory selector;
    private final ChannelGroup accepted = new DefaultChannelGroup();
    protected HttpPipelineFactory pipelineFact;
    private int sslFileBufferSize;
    private boolean manageOsCache;
    private int readaheadLength;
    private int maxShuffleConnections;
    private ReadaheadPool readaheadPool = ReadaheadPool.getInstance();
    public static final String MAPREDUCE_SHUFFLE_SERVICEID = "mapreduce_shuffle";
    private static final Map<String, String> userRsrc = new ConcurrentHashMap<String, String>();
    private static final JobTokenSecretManager secretManager = new JobTokenSecretManager();
    public static final String SHUFFLE_PORT_CONFIG_KEY = "mapreduce.shuffle.port";
    public static final int DEFAULT_SHUFFLE_PORT = 13562;
    public static final String SUFFLE_SSL_FILE_BUFFER_SIZE_KEY = "mapreduce.shuffle.ssl.file.buffer.size";
    public static final int DEFAULT_SUFFLE_SSL_FILE_BUFFER_SIZE = 61440;
    public static final String MAX_SHUFFLE_CONNECTIONS = "mapreduce.shuffle.max.connections";
    public static final int DEFAULT_MAX_SHUFFLE_CONNECTIONS = 0;
    public static final String MAX_SHUFFLE_THREADS = "mapreduce.shuffle.max.threads";
    public static final int DEFAULT_MAX_SHUFFLE_THREADS = 0;
    final ShuffleMetrics metrics;

    ShuffleHandler(MetricsSystem ms) {
        super("httpshuffle");
        this.metrics = (ShuffleMetrics)ms.register((Object)new ShuffleMetrics());
    }

    public ShuffleHandler() {
        this(DefaultMetricsSystem.instance());
    }

    public static ByteBuffer serializeMetaData(int port) throws IOException {
        DataOutputBuffer port_dob = new DataOutputBuffer();
        port_dob.writeInt(port);
        return ByteBuffer.wrap(port_dob.getData(), 0, port_dob.getLength());
    }

    public static int deserializeMetaData(ByteBuffer meta) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{meta});
        int port = in.readInt();
        return port;
    }

    public static ByteBuffer serializeServiceData(Token<JobTokenIdentifier> jobToken) throws IOException {
        DataOutputBuffer jobToken_dob = new DataOutputBuffer();
        jobToken.write((DataOutput)jobToken_dob);
        return ByteBuffer.wrap(jobToken_dob.getData(), 0, jobToken_dob.getLength());
    }

    static Token<JobTokenIdentifier> deserializeServiceData(ByteBuffer secret) throws IOException {
        DataInputByteBuffer in = new DataInputByteBuffer();
        in.reset(new ByteBuffer[]{secret});
        Token jt = new Token();
        jt.readFields((DataInput)in);
        return jt;
    }

    public void initializeApplication(ApplicationInitializationContext context) {
        String user = context.getUser();
        ApplicationId appId = context.getApplicationId();
        ByteBuffer secret = context.getApplicationDataForService();
        try {
            Token<JobTokenIdentifier> jt = ShuffleHandler.deserializeServiceData(secret);
            JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
            userRsrc.put(jobId.toString(), user);
            LOG.info((Object)("Added token for " + jobId.toString()));
            secretManager.addTokenForJob(jobId.toString(), jt);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during initApp", (Throwable)e);
        }
    }

    public void stopApplication(ApplicationTerminationContext context) {
        ApplicationId appId = context.getApplicationId();
        JobID jobId = new JobID(Long.toString(appId.getClusterTimestamp()), appId.getId());
        secretManager.removeTokenForJob(jobId.toString());
        userRsrc.remove(jobId.toString());
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.manageOsCache = conf.getBoolean(SHUFFLE_MANAGE_OS_CACHE, true);
        this.readaheadLength = conf.getInt(SHUFFLE_READAHEAD_BYTES, 0x400000);
        this.maxShuffleConnections = conf.getInt(MAX_SHUFFLE_CONNECTIONS, 0);
        int maxShuffleThreads = conf.getInt(MAX_SHUFFLE_THREADS, 0);
        if (maxShuffleThreads == 0) {
            maxShuffleThreads = 2 * Runtime.getRuntime().availableProcessors();
        }
        ThreadFactory bossFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Boss #%d").build();
        ThreadFactory workerFactory = new ThreadFactoryBuilder().setNameFormat("ShuffleHandler Netty Worker #%d").build();
        this.selector = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(bossFactory), (Executor)Executors.newCachedThreadPool(workerFactory), maxShuffleThreads);
        super.serviceInit(new Configuration(conf));
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
        try {
            this.pipelineFact = new HttpPipelineFactory(conf);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
        bootstrap.setPipelineFactory((ChannelPipelineFactory)this.pipelineFact);
        this.port = conf.getInt(SHUFFLE_PORT_CONFIG_KEY, 13562);
        Channel ch = bootstrap.bind((SocketAddress)new InetSocketAddress(this.port));
        this.accepted.add((Object)ch);
        this.port = ((InetSocketAddress)ch.getLocalAddress()).getPort();
        conf.set(SHUFFLE_PORT_CONFIG_KEY, Integer.toString(this.port));
        this.pipelineFact.SHUFFLE.setPort(this.port);
        LOG.info((Object)(this.getName() + " listening on port " + this.port));
        super.serviceStart();
        this.sslFileBufferSize = conf.getInt(SUFFLE_SSL_FILE_BUFFER_SIZE_KEY, 61440);
    }

    protected void serviceStop() throws Exception {
        this.accepted.close().awaitUninterruptibly(10L, TimeUnit.SECONDS);
        if (this.selector != null) {
            ServerBootstrap bootstrap = new ServerBootstrap(this.selector);
            bootstrap.releaseExternalResources();
        }
        if (this.pipelineFact != null) {
            this.pipelineFact.destroy();
        }
        super.serviceStop();
    }

    public synchronized ByteBuffer getMetaData() {
        try {
            return ShuffleHandler.serializeMetaData(this.port);
        }
        catch (IOException e) {
            LOG.error((Object)"Error during getMeta", (Throwable)e);
            return null;
        }
    }

    protected Shuffle getShuffle(Configuration conf) {
        return new Shuffle(conf);
    }

    class Shuffle
    extends SimpleChannelUpstreamHandler {
        private final Configuration conf;
        private final IndexCache indexCache;
        private final LocalDirAllocator lDirAlloc = new LocalDirAllocator("yarn.nodemanager.local-dirs");
        private int port;

        public Shuffle(Configuration conf) {
            this.conf = conf;
            this.indexCache = new IndexCache(new JobConf(conf));
            this.port = conf.getInt(ShuffleHandler.SHUFFLE_PORT_CONFIG_KEY, 13562);
        }

        public void setPort(int port) {
            this.port = port;
        }

        private List<String> splitMaps(List<String> mapq) {
            if (null == mapq) {
                return null;
            }
            ArrayList<String> ret = new ArrayList<String>();
            for (String s : mapq) {
                Collections.addAll(ret, s.split(","));
            }
            return ret;
        }

        public void channelOpen(ChannelHandlerContext ctx, ChannelStateEvent evt) throws Exception {
            if (ShuffleHandler.this.maxShuffleConnections > 0 && ShuffleHandler.this.accepted.size() >= ShuffleHandler.this.maxShuffleConnections) {
                LOG.info((Object)String.format("Current number of shuffle connections (%d) is greater than or equal to the max allowed shuffle connections (%d)", ShuffleHandler.this.accepted.size(), ShuffleHandler.this.maxShuffleConnections));
                evt.getChannel().close();
                return;
            }
            ShuffleHandler.this.accepted.add((Object)evt.getChannel());
            super.channelOpen(ctx, evt);
        }

        public void messageReceived(ChannelHandlerContext ctx, MessageEvent evt) throws Exception {
            String jobId;
            int reduceId;
            HttpRequest request = (HttpRequest)evt.getMessage();
            if (request.getMethod() != HttpMethod.GET) {
                this.sendError(ctx, HttpResponseStatus.METHOD_NOT_ALLOWED);
                return;
            }
            if (!"mapreduce".equals(request.getHeader("name")) || !"1.0.0".equals(request.getHeader("version"))) {
                this.sendError(ctx, "Incompatible shuffle request version", HttpResponseStatus.BAD_REQUEST);
            }
            Map q = new QueryStringDecoder(request.getUri()).getParameters();
            List<String> mapIds = this.splitMaps((List)q.get("map"));
            List reduceQ = (List)q.get("reduce");
            List jobQ = (List)q.get("job");
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RECV: " + request.getUri() + "\n  mapId: " + mapIds + "\n  reduceId: " + reduceQ + "\n  jobId: " + jobQ));
            }
            if (mapIds == null || reduceQ == null || jobQ == null) {
                this.sendError(ctx, "Required param job, map and reduce", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (reduceQ.size() != 1 || jobQ.size() != 1) {
                this.sendError(ctx, "Too many job/reduce parameters", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            try {
                reduceId = Integer.parseInt((String)reduceQ.get(0));
                jobId = (String)jobQ.get(0);
            }
            catch (NumberFormatException e) {
                this.sendError(ctx, "Bad reduce parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            catch (IllegalArgumentException e) {
                this.sendError(ctx, "Bad job parameter", HttpResponseStatus.BAD_REQUEST);
                return;
            }
            String reqUri = request.getUri();
            if (null == reqUri) {
                this.sendError(ctx, HttpResponseStatus.FORBIDDEN);
                return;
            }
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            try {
                this.verifyRequest(jobId, ctx, request, (HttpResponse)response, new URL("http", "", this.port, reqUri));
            }
            catch (IOException e) {
                LOG.warn((Object)"Shuffle failure ", (Throwable)e);
                this.sendError(ctx, e.getMessage(), HttpResponseStatus.UNAUTHORIZED);
                return;
            }
            Channel ch = evt.getChannel();
            ch.write((Object)response);
            ChannelFuture lastMap = null;
            for (String mapId : mapIds) {
                try {
                    lastMap = this.sendMapOutput(ctx, ch, (String)userRsrc.get(jobId), jobId, mapId, reduceId);
                    if (null != lastMap) continue;
                    this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
                    return;
                }
                catch (IOException e) {
                    LOG.error((Object)"Shuffle error :", (Throwable)e);
                    StringBuffer sb = new StringBuffer(e.getMessage());
                    Throwable t = e;
                    while (t.getCause() != null) {
                        sb.append(t.getCause().getMessage());
                        t = t.getCause();
                    }
                    this.sendError(ctx, sb.toString(), HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            lastMap.addListener((ChannelFutureListener)ShuffleHandler.this.metrics);
            lastMap.addListener(ChannelFutureListener.CLOSE);
        }

        protected void verifyRequest(String appid, ChannelHandlerContext ctx, HttpRequest request, HttpResponse response, URL requestUri) throws IOException {
            SecretKey tokenSecret = secretManager.retrieveTokenSecret(appid);
            if (null == tokenSecret) {
                LOG.info((Object)("Request for unknown token " + appid));
                throw new IOException("could not find jobid");
            }
            String enc_str = SecureShuffleUtils.buildMsgFrom((URL)requestUri);
            String urlHashStr = request.getHeader("UrlHash");
            if (urlHashStr == null) {
                LOG.info((Object)("Missing header hash for " + appid));
                throw new IOException("fetcher cannot be authenticated");
            }
            if (LOG.isDebugEnabled()) {
                int len = urlHashStr.length();
                LOG.debug((Object)("verifying request. enc_str=" + enc_str + "; hash=..." + urlHashStr.substring(len - len / 2, len - 1)));
            }
            SecureShuffleUtils.verifyReply((String)urlHashStr, (String)enc_str, (SecretKey)tokenSecret);
            String reply = SecureShuffleUtils.generateHash((byte[])urlHashStr.getBytes(Charsets.UTF_8), (SecretKey)tokenSecret);
            response.setHeader("ReplyHash", (Object)reply);
            response.setHeader("name", (Object)"mapreduce");
            response.setHeader("version", (Object)"1.0.0");
            if (LOG.isDebugEnabled()) {
                int len = reply.length();
                LOG.debug((Object)("Fetcher request verfied. enc_str=" + enc_str + ";reply=" + reply.substring(len - len / 2, len - 1)));
            }
        }

        protected ChannelFuture sendMapOutput(ChannelHandlerContext ctx, Channel ch, String user, String jobId, String mapId, int reduce) throws IOException {
            ChannelFuture writeFuture;
            RandomAccessFile spill;
            JobID jobID = JobID.forName((String)jobId);
            ApplicationId appID = ApplicationId.newInstance((long)Long.parseLong(jobID.getJtIdentifier()), (int)jobID.getId());
            String base = "usercache/" + user + "/" + "appcache" + "/" + ConverterUtils.toString((ApplicationId)appID) + "/output" + "/" + mapId;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DEBUG0 " + base));
            }
            Path indexFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out.index", this.conf);
            Path mapOutputFileName = this.lDirAlloc.getLocalPathToRead(base + "/file.out", this.conf);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("DEBUG1 " + base + " : " + mapOutputFileName + " : " + indexFileName));
            }
            IndexRecord info = this.indexCache.getIndexInformation(mapId, reduce, indexFileName, user);
            ShuffleHeader header = new ShuffleHeader(mapId, info.partLength, info.rawLength, reduce);
            DataOutputBuffer dob = new DataOutputBuffer();
            header.write((DataOutput)dob);
            ch.write((Object)ChannelBuffers.wrappedBuffer((byte[])dob.getData(), (int)0, (int)dob.getLength()));
            File spillfile = new File(mapOutputFileName.toString());
            try {
                spill = SecureIOUtils.openForRandomRead((File)spillfile, (String)"r", (String)user, null);
            }
            catch (FileNotFoundException e) {
                LOG.info((Object)(spillfile + " not found"));
                return null;
            }
            if (ch.getPipeline().get(SslHandler.class) == null) {
                final FadvisedFileRegion partition = new FadvisedFileRegion(spill, info.startOffset, info.partLength, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath());
                writeFuture = ch.write((Object)partition);
                writeFuture.addListener(new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) {
                        if (future.isSuccess()) {
                            partition.transferSuccessful();
                        }
                        partition.releaseExternalResources();
                    }
                });
            } else {
                FadvisedChunkedFile chunk = new FadvisedChunkedFile(spill, info.startOffset, info.partLength, ShuffleHandler.this.sslFileBufferSize, ShuffleHandler.this.manageOsCache, ShuffleHandler.this.readaheadLength, ShuffleHandler.this.readaheadPool, spillfile.getAbsolutePath());
                writeFuture = ch.write((Object)chunk);
            }
            ShuffleHandler.this.metrics.shuffleConnections.incr();
            ShuffleHandler.this.metrics.shuffleOutputBytes.incr(info.partLength);
            return writeFuture;
        }

        protected void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
            this.sendError(ctx, "", status);
        }

        protected void sendError(ChannelHandlerContext ctx, String message, HttpResponseStatus status) {
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, status);
            response.setHeader("Content-Type", (Object)"text/plain; charset=UTF-8");
            response.setHeader("name", (Object)"mapreduce");
            response.setHeader("version", (Object)"1.0.0");
            response.setContent(ChannelBuffers.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8));
            ctx.getChannel().write((Object)response).addListener(ChannelFutureListener.CLOSE);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, ExceptionEvent e) throws Exception {
            Channel ch = e.getChannel();
            Throwable cause = e.getCause();
            if (cause instanceof TooLongFrameException) {
                this.sendError(ctx, HttpResponseStatus.BAD_REQUEST);
                return;
            }
            if (cause instanceof IOException) {
                if (cause instanceof ClosedChannelException) {
                    LOG.debug((Object)"Ignoring closed channel error", cause);
                    return;
                }
                String message = String.valueOf(cause.getMessage());
                if (IGNORABLE_ERROR_MESSAGE.matcher(message).matches()) {
                    LOG.debug((Object)"Ignoring client socket close", cause);
                    return;
                }
            }
            LOG.error((Object)"Shuffle error: ", cause);
            if (ch.isConnected()) {
                LOG.error((Object)("Shuffle error " + e));
                this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    class HttpPipelineFactory
    implements ChannelPipelineFactory {
        final Shuffle SHUFFLE;
        private SSLFactory sslFactory;

        public HttpPipelineFactory(Configuration conf) throws Exception {
            this.SHUFFLE = ShuffleHandler.this.getShuffle(conf);
            if (conf.getBoolean("mapreduce.shuffle.ssl.enabled", false)) {
                this.sslFactory = new SSLFactory(SSLFactory.Mode.SERVER, conf);
                this.sslFactory.init();
            }
        }

        public void destroy() {
            if (this.sslFactory != null) {
                this.sslFactory.destroy();
            }
        }

        public ChannelPipeline getPipeline() throws Exception {
            ChannelPipeline pipeline = Channels.pipeline();
            if (this.sslFactory != null) {
                pipeline.addLast("ssl", (ChannelHandler)new SslHandler(this.sslFactory.createSSLEngine()));
            }
            pipeline.addLast("decoder", (ChannelHandler)new HttpRequestDecoder());
            pipeline.addLast("aggregator", (ChannelHandler)new HttpChunkAggregator(65536));
            pipeline.addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            pipeline.addLast("chunking", (ChannelHandler)new ChunkedWriteHandler());
            pipeline.addLast("shuffle", (ChannelHandler)this.SHUFFLE);
            return pipeline;
        }
    }

    @Metrics(about="Shuffle output metrics", context="mapred")
    static class ShuffleMetrics
    implements ChannelFutureListener {
        @Metric(value={"Shuffle output in bytes"})
        MutableCounterLong shuffleOutputBytes;
        @Metric(value={"# of failed shuffle outputs"})
        MutableCounterInt shuffleOutputsFailed;
        @Metric(value={"# of succeeeded shuffle outputs"})
        MutableCounterInt shuffleOutputsOK;
        @Metric(value={"# of current shuffle connections"})
        MutableGaugeInt shuffleConnections;

        ShuffleMetrics() {
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            if (future.isSuccess()) {
                this.shuffleOutputsOK.incr();
            } else {
                this.shuffleOutputsFailed.incr();
            }
            this.shuffleConnections.decr();
        }
    }
}

