/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import org.apache.pig.classification.InterfaceAudience;
import org.apache.pig.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class Expression {
    protected OpType opType;

    public OpType getOpType() {
        return this.opType;
    }

    public static class Const
    extends Expression {
        Object value;

        public Object getValue() {
            return this.value;
        }

        public Const(Object value) {
            this.opType = OpType.TERM_CONST;
            this.value = value;
        }

        public String toString() {
            return this.value instanceof String ? "'" + this.value + "'" : this.value.toString();
        }
    }

    public static class Column
    extends Expression {
        private String name;

        public Column(String name) {
            this.opType = OpType.TERM_COL;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static class BinaryExpression
    extends Expression {
        Expression lhs;
        Expression rhs;

        public BinaryExpression(Expression lhs, Expression rhs, OpType opType) {
            this.opType = opType;
            this.lhs = lhs;
            this.rhs = rhs;
        }

        public Expression getLhs() {
            return this.lhs;
        }

        public Expression getRhs() {
            return this.rhs;
        }

        public String toString() {
            return "(" + this.lhs.toString() + this.opType.toString() + this.rhs.toString() + ")";
        }
    }

    public static enum OpType {
        OP_PLUS(" + "),
        OP_MINUS(" - "),
        OP_TIMES(" * "),
        OP_DIV(" / "),
        OP_MOD(" % "),
        OP_EQ(" == "),
        OP_NE(" != "),
        OP_GT(" > "),
        OP_GE(" >= "),
        OP_LT(" < "),
        OP_LE(" <= "),
        OP_AND(" and "),
        OP_OR(" or "),
        TERM_COL(" Column "),
        TERM_CONST(" Constant ");

        private String str = "";

        private OpType(String rep) {
            this.str = rep;
        }

        private OpType() {
        }

        public String toString() {
            return this.str;
        }
    }
}

