/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators;

import java.util.List;
import java.util.Map;
import org.apache.pig.backend.executionengine.ExecException;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.Result;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.expressionOperators.ExpressionOperator;
import org.apache.pig.backend.hadoop.executionengine.physicalLayer.plans.PhyPlanVisitor;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;
import org.apache.pig.impl.plan.NodeIdGenerator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.VisitorException;
import org.joda.time.DateTime;

public class ConstantExpression
extends ExpressionOperator {
    private static final long serialVersionUID = 1L;
    Object value;
    Result res = new Result();

    public ConstantExpression(OperatorKey k) {
        this(k, -1);
    }

    public ConstantExpression(OperatorKey k, int rp) {
        super(k, rp);
    }

    @Override
    public String name() {
        if (this.value != null) {
            return "Constant(" + this.value.toString() + ") - " + this.mKey.toString();
        }
        return "Constant(DummyVal) - " + this.mKey.toString();
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return false;
    }

    @Override
    public void visit(PhyPlanVisitor v) throws VisitorException {
        v.visitConstant(this);
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
        Tuple dummyTuple = TupleFactory.getInstance().newTuple(1);
        this.attachInput(dummyTuple);
    }

    protected Result genericGetNext(Object obj, byte dataType) throws ExecException {
        this.res = this.processInput();
        if (this.res.returnStatus != 0) {
            return this.res;
        }
        this.res.result = this.value;
        return this.res;
    }

    @Override
    public Result getNext(DataBag db) throws ExecException {
        return this.genericGetNext(db, (byte)120);
    }

    @Override
    public Result getNext(DataByteArray ba) throws ExecException {
        return this.genericGetNext(ba, (byte)50);
    }

    @Override
    public Result getNext(Double d) throws ExecException {
        return this.genericGetNext(d, (byte)25);
    }

    @Override
    public Result getNext(Float f) throws ExecException {
        return this.genericGetNext(f, (byte)20);
    }

    @Override
    public Result getNext(Integer i) throws ExecException {
        return this.genericGetNext(i, (byte)10);
    }

    @Override
    public Result getNext(Long l) throws ExecException {
        return this.genericGetNext(l, (byte)15);
    }

    @Override
    public Result getNext(DateTime dt) throws ExecException {
        return this.genericGetNext(dt, (byte)30);
    }

    @Override
    public Result getNext(String s) throws ExecException {
        return this.genericGetNext(s, (byte)55);
    }

    @Override
    public Result getNext(Tuple t) throws ExecException {
        return this.genericGetNext(t, (byte)110);
    }

    @Override
    public Result getNext(Boolean b) throws ExecException {
        return this.genericGetNext(b, (byte)5);
    }

    @Override
    public Result getNext(Map m) throws ExecException {
        return this.genericGetNext(m, (byte)100);
    }

    @Override
    public ConstantExpression clone() throws CloneNotSupportedException {
        ConstantExpression clone = new ConstantExpression(new OperatorKey(this.mKey.scope, NodeIdGenerator.getGenerator().getNextNodeId(this.mKey.scope)));
        clone.value = this.value;
        clone.cloneHelper(this);
        return clone;
    }

    @Override
    public List<ExpressionOperator> getChildExpressions() {
        return null;
    }

    @Override
    public Tuple illustratorMarkup(Object in, Object out, int eqClassIndex) {
        return (Tuple)out;
    }
}

