/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer.schema;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pig.data.DataType;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.schema.Schema;

public class SchemaUtil {
    private static Set<Byte> SUPPORTED_TYPE_SET = new HashSet<Byte>();

    public static Schema newTupleSchema(String tupleName, List<String> fieldNames, List<Byte> dataTypes) throws FrontendException {
        SchemaUtil.checkParameters(fieldNames, dataTypes);
        ArrayList<Schema.FieldSchema> tokenSchemas = new ArrayList<Schema.FieldSchema>();
        for (int i = 0; i < fieldNames.size(); ++i) {
            String name = fieldNames.get(i);
            Byte type = dataTypes.get(i);
            tokenSchemas.add(new Schema.FieldSchema(name, type));
        }
        Schema tupleSchema = new Schema(tokenSchemas);
        Schema.FieldSchema tupleField = new Schema.FieldSchema(tupleName, tupleSchema);
        return new Schema(tupleField);
    }

    public static Schema newTupleSchema(String tupleName, String[] fieldNames, Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newTupleSchema(tupleName, Arrays.asList(fieldNames), Arrays.asList(dataTypes));
    }

    public static Schema newTupleSchema(List<String> fieldNames, List<Byte> dataTypes) throws FrontendException {
        return SchemaUtil.newTupleSchema("t", fieldNames, dataTypes);
    }

    public static Schema newTupleSchema(List<Byte> dataTypes) throws FrontendException {
        List<String> names = SchemaUtil.newNames(dataTypes.size());
        return SchemaUtil.newTupleSchema("t", names, dataTypes);
    }

    public static Schema newTupleSchema(String[] names, Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newTupleSchema("t", Arrays.asList(names), Arrays.asList(dataTypes));
    }

    public static Schema newTupleSchema(Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newTupleSchema(Arrays.asList(dataTypes));
    }

    private static List<String> newNames(int size) {
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            names.add("f" + i);
        }
        return names;
    }

    public static Schema newBagSchema(String bagName, String tupleName, List<String> fieldNames, List<Byte> dataTypes) throws FrontendException {
        SchemaUtil.checkParameters(fieldNames, dataTypes);
        Schema tupleSchema = SchemaUtil.newTupleSchema(tupleName, fieldNames, dataTypes);
        Schema.FieldSchema bagField = new Schema.FieldSchema(bagName, tupleSchema, 120);
        return new Schema(bagField);
    }

    public static Schema newBagSchema(String bagName, String tupleName, String[] fieldNames, Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newBagSchema(bagName, tupleName, Arrays.asList(fieldNames), Arrays.asList(dataTypes));
    }

    public static Schema newBagSchema(List<String> names, List<Byte> dataTypes) throws FrontendException {
        SchemaUtil.checkParameters(names, dataTypes);
        Schema tupleSchema = SchemaUtil.newTupleSchema(names, dataTypes);
        Schema.FieldSchema bagField = new Schema.FieldSchema("b", tupleSchema, 120);
        return new Schema(bagField);
    }

    public static Schema newBagSchema(List<Byte> dataTypes) throws FrontendException {
        List<String> names = SchemaUtil.newNames(dataTypes.size());
        return SchemaUtil.newBagSchema(names, dataTypes);
    }

    public static Schema newBagSchema(String[] names, Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newBagSchema(Arrays.asList(names), Arrays.asList(dataTypes));
    }

    public static Schema newBagSchema(Byte[] dataTypes) throws FrontendException {
        return SchemaUtil.newBagSchema(Arrays.asList(dataTypes));
    }

    private static void checkDataTypes(List<Byte> dataTypes) throws FrontendException {
        for (Byte type : dataTypes) {
            if (SUPPORTED_TYPE_SET.contains(type)) continue;
            throw new FrontendException("Currently pig do not support this kind of type using Schema:" + DataType.findTypeName(type) + ". You can write shema by yourself.");
        }
    }

    private static void checkParameters(List<String> names, List<Byte> dataTypes) throws FrontendException {
        SchemaUtil.checkDataTypes(dataTypes);
        if (names.size() != dataTypes.size()) {
            throw new FrontendException("The number of names is not equal to the number of dataTypes");
        }
    }

    static {
        SUPPORTED_TYPE_SET.add((byte)10);
        SUPPORTED_TYPE_SET.add((byte)15);
        SUPPORTED_TYPE_SET.add((byte)55);
        SUPPORTED_TYPE_SET.add((byte)5);
        SUPPORTED_TYPE_SET.add((byte)6);
        SUPPORTED_TYPE_SET.add((byte)50);
        SUPPORTED_TYPE_SET.add((byte)25);
        SUPPORTED_TYPE_SET.add((byte)20);
        SUPPORTED_TYPE_SET.add((byte)30);
        SUPPORTED_TYPE_SET.add((byte)100);
    }
}

