/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.parse;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.parse.ASTNode;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TypeCheckProcFactory;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.typeinfo.BaseTypeParams;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeParams;

public final class ParseUtils {
    public static boolean isJoinToken(ASTNode node) {
        switch (node.getToken().getType()) {
            case 638: 
            case 666: 
            case 669: 
            case 734: {
                return true;
            }
        }
        return false;
    }

    public static ASTNode findRootNonNullToken(ASTNode tree) {
        while (tree.getToken() == null && tree.getChildCount() > 0) {
            tree = (ASTNode)tree.getChild(0);
        }
        return tree;
    }

    private ParseUtils() {
    }

    public static List<String> validateColumnNameUniqueness(List<FieldSchema> fieldSchemas) throws SemanticException {
        Iterator<FieldSchema> iterCols = fieldSchemas.iterator();
        ArrayList<String> colNames = new ArrayList<String>();
        while (iterCols.hasNext()) {
            String colName = iterCols.next().getName();
            for (String oldColName : colNames) {
                if (!colName.equalsIgnoreCase(oldColName)) continue;
                throw new SemanticException(ErrorMsg.DUPLICATE_COLUMN_NAMES.getMsg(oldColName));
            }
            colNames.add(colName);
        }
        return colNames;
    }

    static ExprNodeDesc createConversionCast(ExprNodeDesc column, PrimitiveTypeInfo tableFieldTypeInfo) throws SemanticException {
        String baseType = TypeInfoUtils.getBaseName(tableFieldTypeInfo.getTypeName());
        BaseTypeParams typeParams = null;
        typeParams = tableFieldTypeInfo.getTypeParams();
        if (typeParams != null) {
            switch (tableFieldTypeInfo.getPrimitiveCategory()) {
                case VARCHAR: {
                    break;
                }
                default: {
                    throw new SemanticException("Type cast for " + (Object)((Object)tableFieldTypeInfo.getPrimitiveCategory()) + " does not take type parameters");
                }
            }
        }
        ExprNodeDesc ret = TypeCheckProcFactory.DefaultExprProcessor.getFuncExprNodeDescWithUdfData(baseType, typeParams, column);
        return ret;
    }

    public static VarcharTypeParams getVarcharParams(String typeName, ASTNode node) throws SemanticException {
        if (node.getChildCount() != 1) {
            throw new SemanticException("Bad params for type " + typeName);
        }
        try {
            VarcharTypeParams typeParams = new VarcharTypeParams();
            String lengthStr = node.getChild(0).getText();
            Integer length = Integer.valueOf(lengthStr);
            typeParams.setLength(length);
            typeParams.validateParams();
            return typeParams;
        }
        catch (SerDeException err) {
            throw new SemanticException(err);
        }
    }
}

