/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.command.wf;

import java.util.Properties;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.command.CommandException;
import org.apache.oozie.command.wf.ActionCheckCommand;
import org.apache.oozie.command.wf.WorkflowCommand;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.Services;
import org.apache.oozie.store.StoreException;
import org.apache.oozie.store.WorkflowStore;
import org.apache.oozie.util.ParamChecker;

public class CompletedActionCommand
extends WorkflowCommand<Void> {
    private String actionId;
    private String externalStatus;
    private Properties actionData;

    public CompletedActionCommand(String actionId, String externalStatus, Properties actionData, int priority) {
        super("callback", "callback", priority, 1);
        this.actionId = ParamChecker.notEmpty(actionId, "actionId");
        this.externalStatus = ParamChecker.notEmpty(externalStatus, "externalStatus");
        this.actionData = actionData;
    }

    public CompletedActionCommand(String actionId, String externalStatus, Properties actionData) {
        this(actionId, externalStatus, actionData, 1);
    }

    @Override
    protected Void call(WorkflowStore store) throws StoreException, CommandException {
        WorkflowActionBean action = store.getAction(this.actionId, false);
        this.setLogInfo(action);
        if (action.getStatus() == WorkflowAction.Status.RUNNING) {
            ActionExecutor executor = Services.get().get(ActionService.class).getExecutor(action.getType());
            if (executor.isCompleted(this.externalStatus)) {
                this.queueCallable(new ActionCheckCommand(action.getId(), this.getPriority(), -1));
            }
        } else {
            throw new CommandException(ErrorCode.E0800, this.actionId, action.getStatus());
        }
        return null;
    }
}

