/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.packet.DataPart;
import com.sap.dbtech.jdbc.translators.Putval;
import com.sap.dbtech.util.JoinReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.Reader;
import java.sql.SQLException;

public class PutvalUnicode
extends Putval {
    private Reader reader;
    private char[] sourceChars;

    public PutvalUnicode(Reader reader, int n) {
        this.reader = n >= 0 ? new ReaderFilter(reader, n) : reader;
    }

    public PutvalUnicode(char[] cArray) {
        this.reader = new CharArrayReader(cArray);
        this.sourceChars = cArray;
    }

    public Object cloneForBatch() {
        if (this.sourceChars == null) {
            return this;
        }
        return new PutvalUnicode(this.sourceChars);
    }

    public boolean atEnd() {
        return this.reader == null;
    }

    public void transferStream(DataPart dataPart) throws SQLException {
        boolean bl;
        if (!this.atEnd() && (bl = dataPart.fillWithReader(this.reader, this.descriptorMark, this))) {
            try {
                this.reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.reader = null;
        }
    }

    public String toString() {
        return "<PutValUnicode " + this.reader + ">";
    }

    public void reset() {
        if (this.requestedData != null) {
            char[] cArray = this.requestedData.getBigUnicode(0, this.requestedLen);
            CharArrayReader charArrayReader = new CharArrayReader(cArray);
            this.reader = this.reader == null ? charArrayReader : new JoinReader(new Reader[]{charArrayReader, this.reader});
            this.requestedData = null;
        }
    }

    public class ReaderFilter
    extends Reader {
        private int maxlength;
        private Reader ips;
        private int readlength = 0;

        public ReaderFilter(Reader reader, int n) {
            this.maxlength = n;
            this.ips = reader;
        }

        public int read() throws IOException {
            if (this.maxlength <= this.readlength++) {
                return -1;
            }
            return this.ips.read();
        }

        public int read(char[] cArray, int n, int n2) throws IOException {
            if (cArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n > cArray.length || n2 < 0 || n + n2 > cArray.length || n + n2 < 0) {
                throw new IndexOutOfBoundsException();
            }
            if (this.readlength >= this.maxlength) {
                return -1;
            }
            if (this.readlength + n2 > this.maxlength) {
                n2 = this.maxlength - this.readlength;
            }
            if (n2 <= 0) {
                return 0;
            }
            n2 = this.ips.read(cArray, n, n2);
            this.readlength += n2;
            return n2;
        }

        public void close() throws IOException {
            this.ips.close();
        }
    }
}

