/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pentaho.di.core.exception.KettlePluginException;
import org.pentaho.reporting.engine.classic.core.metadata.DataFactoryRegistry;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.EmbeddedKettleDataFactoryMetaData;
import org.pentaho.reporting.libraries.xmlns.parser.LoggingErrorHandler;
import org.pentaho.reporting.libraries.xmlns.parser.ParserEntityResolver;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentHelper {
    private DocumentHelper() {
    }

    public static Document loadDocumentFromBytes(byte[] bytes) throws KettlePluginException {
        return DocumentHelper.loadDocument(new ByteArrayInputStream(bytes));
    }

    public static Document loadDocumentFromPlugin(String id) throws KettlePluginException {
        EmbeddedKettleDataFactoryMetaData md = (EmbeddedKettleDataFactoryMetaData)DataFactoryRegistry.getInstance().getMetaData(id);
        ByteArrayInputStream in = new ByteArrayInputStream(md.getBytes());
        return DocumentHelper.loadDocument(in);
    }

    public static Document loadDocument(InputStream in) throws KettlePluginException {
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setNamespaceAware(true);
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            db.setEntityResolver((EntityResolver)ParserEntityResolver.getDefaultResolver());
            db.setErrorHandler((ErrorHandler)new LoggingErrorHandler());
            InputSource input = new InputSource(in);
            Document document = db.parse(input);
            return document;
        }
        catch (ParserConfigurationException e) {
            throw new KettlePluginException("Unable to initialize the XML-Parser", (Throwable)e);
        }
        catch (SAXException e) {
            throw new KettlePluginException("Unable to parse the document.", (Throwable)e);
        }
        catch (IOException e) {
            throw new KettlePluginException("Unable to read the document from stream.", (Throwable)e);
        }
        finally {
            try {
                in.close();
            }
            catch (IOException e) {}
        }
    }
}

