/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.tools.offlineImageViewer;

import com.google.common.base.Preconditions;
import com.google.common.io.LimitInputStream;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.protocol.proto.HdfsProtos;
import org.apache.hadoop.hdfs.server.namenode.FSImageFormatProtobuf;
import org.apache.hadoop.hdfs.server.namenode.FSImageUtil;
import org.apache.hadoop.hdfs.server.namenode.FsImageProto;
import org.apache.hadoop.io.IOUtils;

final class FileDistributionCalculator {
    private static final long MAX_SIZE_DEFAULT = 0x2000000000L;
    private static final int INTERVAL_DEFAULT = 0x200000;
    private final Configuration conf;
    private final long maxSize;
    private final int steps;
    private final PrintWriter out;
    private int[] distribution;
    private int totalFiles;
    private int totalDirectories;
    private int totalBlocks;
    private long totalSpace;
    private long maxFileSize;

    FileDistributionCalculator(Configuration conf, long maxSize, int steps, PrintWriter out) {
        this.conf = conf;
        this.maxSize = maxSize == 0L ? 0x2000000000L : maxSize;
        this.steps = steps == 0 ? 0x200000 : steps;
        this.out = out;
        long numIntervals = this.maxSize / (long)this.steps;
        this.distribution = new int[1 + (int)numIntervals];
        Preconditions.checkState((numIntervals < Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Too many distribution intervals");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void visit(RandomAccessFile file) throws IOException {
        if (!FSImageUtil.checkFileFormat(file)) {
            throw new IOException("Unrecognized FSImage");
        }
        FsImageProto.FileSummary summary = FSImageUtil.loadSummary(file);
        FileInputStream in = null;
        try {
            in = new FileInputStream(file.getFD());
            for (FsImageProto.FileSummary.Section s : summary.getSectionsList()) {
                if (FSImageFormatProtobuf.SectionName.fromString(s.getName()) != FSImageFormatProtobuf.SectionName.INODE) continue;
                in.getChannel().position(s.getOffset());
                InputStream is = FSImageUtil.wrapInputStreamForCompression(this.conf, summary.getCodec(), new BufferedInputStream((InputStream)new LimitInputStream((InputStream)in, s.getLength())));
                this.run(is);
                this.output();
            }
        }
        catch (Throwable throwable) {
            IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
            throw throwable;
        }
        IOUtils.cleanup(null, (Closeable[])new Closeable[]{in});
    }

    private void run(InputStream in) throws IOException {
        FsImageProto.INodeSection s = FsImageProto.INodeSection.parseDelimitedFrom(in);
        int i = 0;
        while ((long)i < s.getNumInodes()) {
            FsImageProto.INodeSection.INode p = FsImageProto.INodeSection.INode.parseDelimitedFrom(in);
            if (p.getType() == FsImageProto.INodeSection.INode.Type.FILE) {
                int bucket;
                ++this.totalFiles;
                FsImageProto.INodeSection.INodeFile f = p.getFile();
                this.totalBlocks += f.getBlocksCount();
                long fileSize = 0L;
                for (HdfsProtos.BlockProto b : f.getBlocksList()) {
                    fileSize += b.getNumBytes();
                }
                this.maxFileSize = Math.max(fileSize, this.maxFileSize);
                this.totalSpace += fileSize * (long)f.getReplication();
                int n = bucket = fileSize > this.maxSize ? this.distribution.length - 1 : (int)Math.ceil((double)fileSize / (double)this.steps);
                this.distribution[n] = this.distribution[n] + 1;
            } else if (p.getType() == FsImageProto.INodeSection.INode.Type.DIRECTORY) {
                ++this.totalDirectories;
            }
            if (i % 0x100000 == 0) {
                this.out.println("Processed " + i + " inodes.");
            }
            ++i;
        }
    }

    private void output() {
        this.out.print("Size\tNumFiles\n");
        for (int i = 0; i < this.distribution.length; ++i) {
            if (this.distribution[i] == 0) continue;
            this.out.print((long)i * (long)this.steps + "\t" + this.distribution[i]);
            this.out.print('\n');
        }
        this.out.print("totalFiles = " + this.totalFiles + "\n");
        this.out.print("totalDirectories = " + this.totalDirectories + "\n");
        this.out.print("totalBlocks = " + this.totalBlocks + "\n");
        this.out.print("totalSpace = " + this.totalSpace + "\n");
        this.out.print("maxFileSize = " + this.maxFileSize + "\n");
    }
}

