/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import com.google.protobuf.HBaseZeroCopyByteString;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.TreeSet;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.exceptions.DeserializationException;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.filter.ParseFilter;
import org.apache.hadoop.hbase.protobuf.generated.FilterProtos;
import org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Public
@InterfaceStability.Stable
public class MultipleColumnPrefixFilter
extends FilterBase {
    protected byte[] hint = null;
    protected TreeSet<byte[]> sortedPrefixes = this.createTreeSet();
    private static final int MAX_LOG_PREFIXES = 5;

    public MultipleColumnPrefixFilter(byte[][] prefixes) {
        if (prefixes != null) {
            for (int i = 0; i < prefixes.length; ++i) {
                if (this.sortedPrefixes.add(prefixes[i])) continue;
                throw new IllegalArgumentException("prefixes must be distinct");
            }
        }
    }

    public byte[][] getPrefix() {
        int count = 0;
        byte[][] temp = new byte[this.sortedPrefixes.size()][];
        for (byte[] prefixes : this.sortedPrefixes) {
            temp[count++] = prefixes;
        }
        return temp;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell kv) {
        if (this.sortedPrefixes.size() == 0 || kv.getQualifierArray() == null) {
            return Filter.ReturnCode.INCLUDE;
        }
        return this.filterColumn(kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength());
    }

    public Filter.ReturnCode filterColumn(byte[] buffer, int qualifierOffset, int qualifierLength) {
        byte[] qualifier = Arrays.copyOfRange(buffer, qualifierOffset, qualifierLength + qualifierOffset);
        TreeSet lesserOrEqualPrefixes = (TreeSet)this.sortedPrefixes.headSet(qualifier, true);
        if (lesserOrEqualPrefixes.size() != 0) {
            byte[] largestPrefixSmallerThanQualifier = (byte[])lesserOrEqualPrefixes.last();
            if (Bytes.startsWith((byte[])qualifier, (byte[])largestPrefixSmallerThanQualifier)) {
                return Filter.ReturnCode.INCLUDE;
            }
            if (lesserOrEqualPrefixes.size() == this.sortedPrefixes.size()) {
                return Filter.ReturnCode.NEXT_ROW;
            }
            this.hint = this.sortedPrefixes.higher(largestPrefixSmallerThanQualifier);
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        this.hint = this.sortedPrefixes.first();
        return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
    }

    public static Filter createFilterFromArguments(ArrayList<byte[]> filterArguments) {
        byte[][] prefixes = new byte[filterArguments.size()][];
        for (int i = 0; i < filterArguments.size(); ++i) {
            byte[] columnPrefix = ParseFilter.removeQuotesFromByteArray(filterArguments.get(i));
            prefixes[i] = columnPrefix;
        }
        return new MultipleColumnPrefixFilter(prefixes);
    }

    @Override
    public byte[] toByteArray() {
        FilterProtos.MultipleColumnPrefixFilter.Builder builder = FilterProtos.MultipleColumnPrefixFilter.newBuilder();
        for (byte[] element : this.sortedPrefixes) {
            if (element == null) continue;
            builder.addSortedPrefixes(HBaseZeroCopyByteString.wrap((byte[])element));
        }
        return builder.build().toByteArray();
    }

    public static MultipleColumnPrefixFilter parseFrom(byte[] pbBytes) throws DeserializationException {
        FilterProtos.MultipleColumnPrefixFilter proto;
        try {
            proto = FilterProtos.MultipleColumnPrefixFilter.parseFrom((byte[])pbBytes);
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializationException(e);
        }
        int numPrefixes = proto.getSortedPrefixesCount();
        byte[][] prefixes = new byte[numPrefixes][];
        for (int i = 0; i < numPrefixes; ++i) {
            prefixes[i] = proto.getSortedPrefixes(i).toByteArray();
        }
        return new MultipleColumnPrefixFilter(prefixes);
    }

    @Override
    boolean areSerializedFieldsEqual(Filter o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MultipleColumnPrefixFilter)) {
            return false;
        }
        MultipleColumnPrefixFilter other = (MultipleColumnPrefixFilter)o;
        return this.sortedPrefixes.equals(other.sortedPrefixes);
    }

    @Override
    public Cell getNextCellHint(Cell kv) {
        return KeyValue.createFirstOnRow((byte[])kv.getRowArray(), (int)kv.getRowOffset(), (int)kv.getRowLength(), (byte[])kv.getFamilyArray(), (int)kv.getFamilyOffset(), (int)kv.getFamilyLength(), (byte[])this.hint, (int)0, (int)this.hint.length);
    }

    public TreeSet<byte[]> createTreeSet() {
        return new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 == null || o2 == null) {
                    throw new IllegalArgumentException("prefixes can't be null");
                }
                byte[] b1 = (byte[])o1;
                byte[] b2 = (byte[])o2;
                return Bytes.compareTo((byte[])b1, (int)0, (int)b1.length, (byte[])b2, (int)0, (int)b2.length);
            }
        });
    }

    @Override
    public String toString() {
        return this.toString(5);
    }

    protected String toString(int maxPrefixes) {
        StringBuilder prefixes = new StringBuilder();
        int count = 0;
        for (byte[] ba : this.sortedPrefixes) {
            if (count >= maxPrefixes) break;
            prefixes.append(Bytes.toStringBinary((byte[])ba));
            if (++count >= this.sortedPrefixes.size() || count >= maxPrefixes) continue;
            prefixes.append(", ");
        }
        return String.format("%s (%d/%d): [%s]", this.getClass().getSimpleName(), count, this.sortedPrefixes.size(), prefixes.toString());
    }
}

