/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hbase.shim.common;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.util.Bytes;

public class DeserializedBooleanComparator
extends WritableByteArrayComparable {
    protected Boolean m_value;

    public DeserializedBooleanComparator() {
    }

    public DeserializedBooleanComparator(boolean value) {
        this.m_value = value;
    }

    public byte[] getValue() {
        return Bytes.toBytes((boolean)this.m_value);
    }

    public void readFields(DataInput in) throws IOException {
        this.m_value = new Boolean(in.readBoolean());
    }

    public void write(DataOutput out) throws IOException {
        out.writeBoolean(this.m_value);
    }

    public int compareTo(byte[] value) {
        Boolean decodedValue = DeserializedBooleanComparator.decodeBoolFromString(value);
        if (decodedValue == null) {
            decodedValue = DeserializedBooleanComparator.decodeBoolFromNumber(value);
        }
        if (decodedValue != null) {
            if (this.m_value.equals(decodedValue)) {
                return 0;
            }
            if (!this.m_value.booleanValue() && decodedValue.booleanValue()) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public int compareTo(byte[] value, int offset, int length) {
        return this.compareTo(value);
    }

    public static Boolean decodeBoolFromString(byte[] rawEncoded) {
        String tempString = Bytes.toString((byte[])rawEncoded);
        if (tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("N") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("NO") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("FALSE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("F") || tempString.equalsIgnoreCase("1") || tempString.equalsIgnoreCase("0")) {
            return tempString.equalsIgnoreCase("Y") || tempString.equalsIgnoreCase("YES") || tempString.equalsIgnoreCase("TRUE") || tempString.equalsIgnoreCase("T") || tempString.equalsIgnoreCase("1");
        }
        return null;
    }

    public static Boolean decodeBoolFromNumber(byte[] rawEncoded) {
        short tempShort;
        byte val;
        if (rawEncoded.length == 1 && ((val = rawEncoded[0]) == 0 || val == 1)) {
            return new Boolean(val == 1);
        }
        if (rawEncoded.length == 2 && ((tempShort = Bytes.toShort((byte[])rawEncoded)) == 0 || tempShort == 1)) {
            return new Boolean(tempShort == 1);
        }
        if (rawEncoded.length == 4 || rawEncoded.length == 4) {
            int tempInt = Bytes.toInt((byte[])rawEncoded);
            if (tempInt == 1 || tempInt == 0) {
                return new Boolean(tempInt == 1);
            }
            float tempFloat = Bytes.toFloat((byte[])rawEncoded);
            if (tempFloat == 0.0f || tempFloat == 1.0f) {
                return new Boolean(tempFloat == 1.0f);
            }
        }
        if (rawEncoded.length == 8 || rawEncoded.length == 8) {
            long tempLong = Bytes.toLong((byte[])rawEncoded);
            if (tempLong == 0L || tempLong == 1L) {
                return new Boolean(tempLong == 1L);
            }
            double tempDouble = Bytes.toDouble((byte[])rawEncoded);
            if (tempDouble == 0.0 || tempDouble == 1.0) {
                return new Boolean(tempDouble == 1.0);
            }
        }
        return null;
    }
}

