/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.mapReduceLayer;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.GzipCodec;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.StorageUtil;

public class PigTextOutputFormat
extends TextOutputFormat<WritableComparable, Tuple> {
    private final byte fieldDel;

    public PigTextOutputFormat(byte delimiter) {
        this.fieldDel = delimiter;
    }

    public RecordWriter<WritableComparable, Tuple> getRecordWriter(TaskAttemptContext job) throws IOException, InterruptedException {
        Configuration conf = job.getConfiguration();
        boolean isCompressed = PigTextOutputFormat.getCompressOutput((JobContext)job);
        CompressionCodec codec = null;
        String extension = "";
        if (isCompressed) {
            Class codecClass = PigTextOutputFormat.getOutputCompressorClass((JobContext)job, GzipCodec.class);
            codec = (CompressionCodec)ReflectionUtils.newInstance((Class)codecClass, (Configuration)conf);
            extension = codec.getDefaultExtension();
        }
        Path file = this.getDefaultWorkFile(job, extension);
        FileSystem fs = file.getFileSystem(conf);
        if (!isCompressed) {
            FSDataOutputStream fileOut = fs.create(file, false);
            return new PigLineRecordWriter((DataOutputStream)fileOut, this.fieldDel);
        }
        FSDataOutputStream fileOut = fs.create(file, false);
        return new PigLineRecordWriter(new DataOutputStream((OutputStream)codec.createOutputStream((OutputStream)fileOut)), this.fieldDel);
    }

    protected static class PigLineRecordWriter
    extends TextOutputFormat.LineRecordWriter<WritableComparable, Tuple> {
        private static final String utf8 = "UTF-8";
        private static final byte[] newline;
        private final byte fieldDel;

        public PigLineRecordWriter(DataOutputStream out, byte fieldDel) {
            super(out);
            this.fieldDel = fieldDel;
        }

        public synchronized void write(WritableComparable key, Tuple value) throws IOException {
            int sz = value.size();
            for (int i = 0; i < sz; ++i) {
                StorageUtil.putField(this.out, value.get(i));
                if (i == sz - 1) continue;
                this.out.writeByte(this.fieldDel);
            }
            this.out.write(newline);
        }

        static {
            try {
                newline = "\n".getBytes(utf8);
            }
            catch (UnsupportedEncodingException uee) {
                throw new IllegalArgumentException("can't find UTF-8 encoding");
            }
        }
    }
}

