/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.local;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.provider.AbstractOriginatingFileProvider;
import org.apache.commons.vfs.provider.LocalFileProvider;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.local.GenericFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileName;
import org.apache.commons.vfs.provider.local.LocalFileNameParser;
import org.apache.commons.vfs.provider.local.LocalFileSystem;
import org.apache.commons.vfs.provider.local.WindowsFileNameParser;
import org.apache.commons.vfs.util.Os;

public class DefaultLocalFileProvider
extends AbstractOriginatingFileProvider
implements LocalFileProvider {
    public static final Collection capabilities = Collections.unmodifiableCollection(Arrays.asList(Capability.CREATE, Capability.DELETE, Capability.RENAME, Capability.GET_TYPE, Capability.GET_LAST_MODIFIED, Capability.SET_LAST_MODIFIED_FILE, Capability.SET_LAST_MODIFIED_FOLDER, Capability.LIST_CHILDREN, Capability.READ_CONTENT, Capability.URI, Capability.WRITE_CONTENT, Capability.APPEND_CONTENT, Capability.RANDOM_ACCESS_READ, Capability.RANDOM_ACCESS_WRITE));

    public DefaultLocalFileProvider() {
        if (Os.isFamily(Os.OS_FAMILY_WINDOWS)) {
            this.setFileNameParser(new WindowsFileNameParser());
        } else {
            this.setFileNameParser(new GenericFileNameParser());
        }
    }

    public boolean isAbsoluteLocalName(String string) {
        return ((LocalFileNameParser)this.getFileNameParser()).isAbsoluteName(string);
    }

    public FileObject findLocalFile(String string) throws FileSystemException {
        StringBuffer stringBuffer = new StringBuffer(string.length() + 5);
        stringBuffer.append("file:");
        stringBuffer.append(string);
        FileName fileName = this.parseUri(null, stringBuffer.toString());
        return this.findFile(fileName, null);
    }

    public FileObject findLocalFile(File file) throws FileSystemException {
        return this.findLocalFile(UriParser.encode(file.getAbsolutePath()));
    }

    protected FileSystem doCreateFileSystem(FileName fileName, FileSystemOptions fileSystemOptions) throws FileSystemException {
        LocalFileName localFileName = (LocalFileName)fileName;
        return new LocalFileSystem((FileName)localFileName, localFileName.getRootFile(), fileSystemOptions);
    }

    public Collection getCapabilities() {
        return capabilities;
    }
}

