/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.webdav;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.HttpMethodBase;
import org.apache.commons.httpclient.MethodRetryHandler;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.util.DateUtil;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileNotFolderException;
import org.apache.commons.vfs.FileNotFoundException;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.provider.DefaultFileContent;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.http.HttpFileObject;
import org.apache.commons.vfs.provider.webdav.ExceptionConverter;
import org.apache.commons.vfs.provider.webdav.WebdavFileContentInfoFactory;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystem;
import org.apache.commons.vfs.provider.webdav.WebdavFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.webdav.WebdavMethodRetryHandler;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.MonitorOutputStream;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.UncheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.VersionControlMethod;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.w3c.dom.Node;

public class WebdavFileObject
extends HttpFileObject
implements FileObject {
    public static final DavPropertyName RESPONSE_CHARSET = DavPropertyName.create((String)"response-charset");
    private final WebdavFileSystem fileSystem;
    private final String urlCharset;
    private final WebdavFileSystemConfigBuilder builder;

    protected WebdavFileObject(FileName fileName, WebdavFileSystem webdavFileSystem) {
        super(fileName, webdavFileSystem);
        this.fileSystem = webdavFileSystem;
        this.builder = (WebdavFileSystemConfigBuilder)WebdavFileSystemConfigBuilder.getInstance();
        this.urlCharset = this.builder.getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    protected void configureMethod(HttpMethodBase httpMethodBase) {
        httpMethodBase.setMethodRetryHandler((MethodRetryHandler)WebdavMethodRetryHandler.getInstance());
    }

    protected FileType doGetType() throws Exception {
        try {
            return this.isDirectory((URLFileName)this.getName()) ? FileType.FOLDER : FileType.FILE;
        }
        catch (FileNotFolderException fileNotFolderException) {
            return FileType.IMAGINARY;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return FileType.IMAGINARY;
        }
    }

    protected String[] doListChildren() throws Exception {
        return null;
    }

    protected FileObject[] doListChildrenResolved() throws Exception {
        PropFindMethod propFindMethod = null;
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            if (this.isDirectory(uRLFileName)) {
                Object[] objectArray;
                DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
                davPropertyNameSet.add(DavPropertyName.create((String)"displayname"));
                propFindMethod = new PropFindMethod(this.urlString(uRLFileName), davPropertyNameSet, 1);
                this.execute((DavMethod)propFindMethod);
                ArrayList<WebdavFileObject> arrayList = new ArrayList<WebdavFileObject>();
                if (propFindMethod.succeeded()) {
                    objectArray = propFindMethod.getResponseBodyAsMultiStatus().getResponses();
                    for (int i = 0; i < objectArray.length; ++i) {
                        String string;
                        MultiStatusResponse multiStatusResponse = objectArray[i];
                        if (this.isCurrentFile(multiStatusResponse.getHref(), uRLFileName) || (string = this.resourceName(multiStatusResponse.getHref())) == null || string.length() <= 0) continue;
                        WebdavFileObject webdavFileObject = (WebdavFileObject)FileObjectUtils.getAbstractFileObject(this.getFileSystem().resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.getName(), string, NameScope.CHILD)));
                        arrayList.add(webdavFileObject);
                    }
                }
                objectArray = arrayList.toArray(new WebdavFileObject[arrayList.size()]);
                return objectArray;
            }
            try {
                throw new FileNotFolderException(this.getName());
            }
            catch (FileNotFolderException fileNotFolderException) {
                throw fileNotFolderException;
            }
            catch (DavException davException) {
                throw new FileSystemException(davException.getMessage(), davException);
            }
            catch (IOException iOException) {
                throw new FileSystemException(iOException.getMessage(), iOException);
            }
        }
        finally {
            if (propFindMethod != null) {
                propFindMethod.releaseConnection();
            }
        }
    }

    protected void doCreateFolder() throws Exception {
        MkColMethod mkColMethod = new MkColMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod((HttpMethod)mkColMethod);
        try {
            this.execute((DavMethod)mkColMethod);
        }
        catch (FileSystemException fileSystemException) {
            throw new FileSystemException("vfs.provider.webdav/create-collection.error", this.getName(), (Throwable)fileSystemException);
        }
    }

    protected void doDelete() throws Exception {
        DeleteMethod deleteMethod = new DeleteMethod(this.urlString((URLFileName)this.getName()));
        this.setupMethod((HttpMethod)deleteMethod);
        this.execute((DavMethod)deleteMethod);
    }

    protected void doRename(FileObject fileObject) throws Exception {
        String string = this.encodePath(this.urlString((URLFileName)this.getName()));
        String string2 = this.urlString((URLFileName)fileObject.getName(), false);
        MoveMethod moveMethod = new MoveMethod(string, string2, false);
        this.setupMethod((HttpMethod)moveMethod);
        this.execute((DavMethod)moveMethod);
    }

    protected long doGetContentSize() throws Exception {
        DavProperty davProperty = this.getProperty((URLFileName)this.getName(), "getcontentlength");
        if (davProperty != null) {
            String string = (String)davProperty.getValue();
            return Long.parseLong(string);
        }
        return 0L;
    }

    protected long doGetLastModifiedTime() throws Exception {
        DavProperty davProperty = this.getProperty((URLFileName)this.getName(), "getlastmodified");
        if (davProperty != null) {
            String string = (String)davProperty.getValue();
            return DateUtil.parseDate((String)string).getTime();
        }
        return 0L;
    }

    protected Map doGetAttributes() throws Exception {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            DavPropertySet davPropertySet = this.getProperties(uRLFileName, 1, new DavPropertyNameSet(), false);
            for (DavProperty davProperty : davPropertySet) {
                hashMap.put(davProperty.getName().toString(), davProperty.getValue());
            }
            davPropertySet = this.getPropertyNames(uRLFileName);
            for (DavProperty davProperty : davPropertySet) {
                if (hashMap.containsKey(davProperty.getName())) continue;
                davProperty = this.getProperty(uRLFileName, davProperty.getName());
                hashMap.put(davProperty.getName().toString(), davProperty.getValue());
            }
            return hashMap;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    protected void doSetAttribute(String string, Object object) throws Exception {
        try {
            URLFileName uRLFileName = (URLFileName)this.getName();
            String string2 = this.urlString(uRLFileName);
            DavPropertySet davPropertySet = new DavPropertySet();
            DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
            DefaultDavProperty defaultDavProperty = new DefaultDavProperty(string, object, Namespace.EMPTY_NAMESPACE);
            if (object != null) {
                davPropertySet.add((DavProperty)defaultDavProperty);
            } else {
                davPropertyNameSet.add(defaultDavProperty.getName());
            }
            PropPatchMethod propPatchMethod = new PropPatchMethod(string2, davPropertySet, davPropertyNameSet);
            this.setupMethod((HttpMethod)propPatchMethod);
            this.execute((DavMethod)propPatchMethod);
            if (!propPatchMethod.succeeded()) {
                throw new FileSystemException("Property '" + string + "' could not be set.");
            }
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        return new WebdavOutputStream(this);
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new WebdavFileContentInfoFactory();
    }

    protected void setupMethod(HttpMethod httpMethod) throws FileSystemException, URIException {
        String string = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        httpMethod.setPath(string);
        httpMethod.setFollowRedirects(false);
        httpMethod.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
        httpMethod.addRequestHeader("Cache-control", "no-cache");
        httpMethod.addRequestHeader("Cache-store", "no-store");
        httpMethod.addRequestHeader("Pragma", "no-cache");
        httpMethod.addRequestHeader("Expires", "0");
    }

    private void execute(DavMethod davMethod) throws FileSystemException {
        try {
            int n = this.fileSystem.getClient().executeMethod((HttpMethod)davMethod);
            if (n == 404 || n == 410) {
                throw new FileNotFoundException(davMethod.getURI());
            }
            davMethod.checkSuccess();
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (IOException iOException) {
            throw new FileSystemException(iOException);
        }
        catch (DavException davException) {
            throw ExceptionConverter.generate(davException);
        }
        finally {
            if (davMethod != null) {
                davMethod.releaseConnection();
            }
        }
    }

    private boolean isDirectory(URLFileName uRLFileName) throws IOException, DavException {
        try {
            Node node;
            DavProperty davProperty = this.getProperty(uRLFileName, "resourcetype");
            if (davProperty != null && (node = (Node)davProperty.getValue()) != null) {
                return node.getLocalName().equals("collection");
            }
            return false;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new FileNotFolderException(uRLFileName);
        }
    }

    DavProperty getProperty(URLFileName uRLFileName, String string) throws FileSystemException {
        return this.getProperty(uRLFileName, DavPropertyName.create((String)string));
    }

    DavProperty getProperty(URLFileName uRLFileName, DavPropertyName davPropertyName) throws FileSystemException {
        DavPropertyNameSet davPropertyNameSet = new DavPropertyNameSet();
        davPropertyNameSet.add(davPropertyName);
        DavPropertySet davPropertySet = this.getProperties(uRLFileName, davPropertyNameSet, false);
        return davPropertySet.get(davPropertyName);
    }

    DavPropertySet getProperties(URLFileName uRLFileName, DavPropertyNameSet davPropertyNameSet, boolean bl) throws FileSystemException {
        return this.getProperties(uRLFileName, 0, davPropertyNameSet, bl);
    }

    DavPropertySet getProperties(URLFileName uRLFileName) throws FileSystemException {
        return this.getProperties(uRLFileName, 1, new DavPropertyNameSet(), false);
    }

    DavPropertySet getPropertyNames(URLFileName uRLFileName) throws FileSystemException {
        return this.getProperties(uRLFileName, 2, new DavPropertyNameSet(), false);
    }

    DavPropertySet getProperties(URLFileName uRLFileName, int n, DavPropertyNameSet davPropertyNameSet, boolean bl) throws FileSystemException {
        try {
            String string = this.urlString(uRLFileName);
            PropFindMethod propFindMethod = new PropFindMethod(string, n, davPropertyNameSet, 0);
            this.setupMethod((HttpMethod)propFindMethod);
            this.execute((DavMethod)propFindMethod);
            if (propFindMethod.succeeded()) {
                MultiStatus multiStatus = propFindMethod.getResponseBodyAsMultiStatus();
                MultiStatusResponse multiStatusResponse = multiStatus.getResponses()[0];
                DavPropertySet davPropertySet = multiStatusResponse.getProperties(200);
                if (bl) {
                    DefaultDavProperty defaultDavProperty = new DefaultDavProperty(RESPONSE_CHARSET, (Object)propFindMethod.getResponseCharSet());
                    davPropertySet.add((DavProperty)defaultDavProperty);
                }
                return davPropertySet;
            }
            return new DavPropertySet();
        }
        catch (FileSystemException fileSystemException) {
            throw fileSystemException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider.webdav/propfind.error", this.getName(), (Throwable)exception);
        }
    }

    private String resourceName(String string) {
        int n;
        if (string.endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        return (n = string.lastIndexOf("/")) >= 0 ? string.substring(n + 1) : string;
    }

    private String urlString(URLFileName uRLFileName) {
        return this.urlString(uRLFileName, true);
    }

    private String urlString(URLFileName uRLFileName, boolean bl) {
        String string = null;
        String string2 = null;
        if (bl) {
            string = uRLFileName.getUserName();
            string2 = uRLFileName.getPassword();
        }
        URLFileName uRLFileName2 = new URLFileName("http", uRLFileName.getHostName(), uRLFileName.getPort(), uRLFileName.getDefaultPort(), string, string2, uRLFileName.getPath(), uRLFileName.getType(), uRLFileName.getQueryString());
        try {
            return uRLFileName2.getURIEncoded(this.urlCharset);
        }
        catch (Exception exception) {
            return uRLFileName.getURI();
        }
    }

    private boolean isCurrentFile(String string, URLFileName uRLFileName) {
        String string2 = this.hrefString(uRLFileName);
        if (string.endsWith("/") && !string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        return string.equals(string2);
    }

    private String hrefString(URLFileName uRLFileName) {
        URLFileName uRLFileName2 = new URLFileName("http", uRLFileName.getHostName(), uRLFileName.getPort(), uRLFileName.getDefaultPort(), null, null, uRLFileName.getPath(), uRLFileName.getType(), uRLFileName.getQueryString());
        try {
            return uRLFileName2.getURIEncoded(this.urlCharset);
        }
        catch (Exception exception) {
            return uRLFileName.getURI();
        }
    }

    private class WebdavOutputStream
    extends MonitorOutputStream {
        private WebdavFileObject file;

        public WebdavOutputStream(WebdavFileObject webdavFileObject2) throws FileSystemException {
            super(new ByteArrayOutputStream());
            this.file = webdavFileObject2;
        }

        protected void onClose() throws IOException {
            ByteArrayRequestEntity byteArrayRequestEntity = new ByteArrayRequestEntity(((ByteArrayOutputStream)this.out).toByteArray());
            URLFileName uRLFileName = (URLFileName)WebdavFileObject.this.getName();
            String string = WebdavFileObject.this.urlString(uRLFileName);
            if (WebdavFileObject.this.builder.isVersioning(WebdavFileObject.this.getFileSystem().getFileSystemOptions())) {
                PutMethod putMethod;
                boolean bl;
                boolean bl2;
                block21: {
                    DavPropertySet davPropertySet = null;
                    bl2 = true;
                    bl = true;
                    try {
                        davPropertySet = WebdavFileObject.this.getPropertyNames(uRLFileName);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        bl2 = false;
                    }
                    if (bl2 && davPropertySet != null) {
                        if (davPropertySet.contains(VersionControlledResource.CHECKED_OUT)) {
                            bl = false;
                        } else if (!davPropertySet.contains(VersionControlledResource.CHECKED_IN) && (putMethod = davPropertySet.get(VersionControlledResource.AUTO_VERSION)) != null && "checkout-checkin".equals((putMethod = WebdavFileObject.this.getProperty(uRLFileName, VersionControlledResource.AUTO_VERSION)).getValue())) {
                            this.createVersion(string);
                        }
                    }
                    if (bl2 && bl) {
                        try {
                            putMethod = new CheckoutMethod(string);
                            WebdavFileObject.this.setupMethod((HttpMethod)putMethod);
                            WebdavFileObject.this.execute((DavMethod)putMethod);
                            bl = false;
                        }
                        catch (FileSystemException fileSystemException) {
                            // empty catch block
                        }
                    }
                    try {
                        putMethod = new PutMethod(string);
                        putMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
                        WebdavFileObject.this.setupMethod((HttpMethod)putMethod);
                        WebdavFileObject.this.execute((DavMethod)putMethod);
                        this.setUserName(uRLFileName, string);
                    }
                    catch (FileSystemException fileSystemException) {
                        if (bl) break block21;
                        try {
                            UncheckoutMethod uncheckoutMethod = new UncheckoutMethod(string);
                            WebdavFileObject.this.setupMethod((HttpMethod)uncheckoutMethod);
                            WebdavFileObject.this.execute((DavMethod)uncheckoutMethod);
                            bl = true;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        throw fileSystemException;
                    }
                }
                if (!bl2) {
                    this.createVersion(string);
                    try {
                        putMethod = WebdavFileObject.this.getPropertyNames(uRLFileName);
                        bl = !putMethod.contains(VersionControlledResource.CHECKED_OUT);
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        // empty catch block
                    }
                }
                if (!bl) {
                    putMethod = new CheckinMethod(string);
                    WebdavFileObject.this.setupMethod((HttpMethod)putMethod);
                    WebdavFileObject.this.execute((DavMethod)putMethod);
                }
            } else {
                PutMethod putMethod = new PutMethod(string);
                putMethod.setRequestEntity((RequestEntity)byteArrayRequestEntity);
                WebdavFileObject.this.setupMethod((HttpMethod)putMethod);
                WebdavFileObject.this.execute((DavMethod)putMethod);
                try {
                    this.setUserName(uRLFileName, string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((DefaultFileContent)this.file.getContent()).resetAttributes();
        }

        private void setUserName(URLFileName uRLFileName, String string) throws IOException {
            String string2;
            ArrayList<DefaultDavProperty> arrayList = new ArrayList<DefaultDavProperty>();
            String string3 = WebdavFileObject.this.builder.getCreatorName(WebdavFileObject.this.getFileSystem().getFileSystemOptions());
            String string4 = uRLFileName.getUserName();
            if (string3 == null) {
                string3 = string4;
            } else if (string4 != null) {
                string2 = "Modified by user " + string4;
                arrayList.add(new DefaultDavProperty(DeltaVConstants.COMMENT, (Object)string2));
            }
            arrayList.add(new DefaultDavProperty(DeltaVConstants.CREATOR_DISPLAYNAME, (Object)string3));
            string2 = new PropPatchMethod(string, arrayList);
            WebdavFileObject.this.setupMethod((HttpMethod)string2);
            WebdavFileObject.this.execute((DavMethod)string2);
        }

        private boolean createVersion(String string) {
            try {
                VersionControlMethod versionControlMethod = new VersionControlMethod(string);
                WebdavFileObject.this.setupMethod((HttpMethod)versionControlMethod);
                WebdavFileObject.this.execute((DavMethod)versionControlMethod);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }
    }
}

