/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.pig.LoadFunc;
import org.apache.pig.LoadMetadata;
import org.apache.pig.LoadPushDown;
import org.apache.pig.ResourceSchema;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.io.FileSpec;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.logicalLayer.schema.SchemaMergeException;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.MultiMap;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOLoad
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private FileSpec mInputFileSpec;
    private transient LoadFunc mLoadFunc;
    private String mSchemaFile;
    private Schema mEnforcedSchema = null;
    private transient Configuration conf;
    private static Log log = LogFactory.getLog(LOLoad.class);
    private Schema mDeterminedSchema = null;
    private Schema scriptSchema = null;
    private LoadPushDown.RequiredFieldList requiredFieldList;
    private boolean mDeterminedSchemaCached = false;

    public LOLoad(LogicalPlan plan, OperatorKey key, FileSpec inputFileSpec, Configuration conf) throws IOException {
        super(plan, key);
        this.mInputFileSpec = inputFileSpec;
        this.mSchemaFile = inputFileSpec.getFileName();
        this.conf = conf;
        this.mAlias = "" + key.getId();
        try {
            this.mLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(inputFileSpec.getFuncSpec());
            this.mLoadFunc.setUDFContextSignature(this.getAlias());
        }
        catch (ClassCastException cce) {
            log.error((Object)(inputFileSpec.getFuncSpec() + " should implement the LoadFunc interface."));
            throw new IOException(cce);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public FileSpec getInputFile() {
        return this.mInputFileSpec;
    }

    public void setInputFile(FileSpec inputFileSpec) throws IOException {
        try {
            this.mLoadFunc = (LoadFunc)PigContext.instantiateFuncFromSpec(inputFileSpec.getFuncSpec());
        }
        catch (ClassCastException cce) {
            log.error((Object)(inputFileSpec.getFuncSpec() + " should implement the LoadFunc interface."));
            IOException ioe = new IOException(cce.getMessage());
            ioe.setStackTrace(cce.getStackTrace());
            throw ioe;
        }
        catch (Exception e) {
            IOException ioe = new IOException(e.getMessage());
            ioe.setStackTrace(e.getStackTrace());
            throw ioe;
        }
        this.mInputFileSpec = inputFileSpec;
    }

    public String getSchemaFile() {
        return this.mSchemaFile;
    }

    public LoadFunc getLoadFunc() {
        return this.mLoadFunc;
    }

    @Override
    public String name() {
        return this.getAliasString() + "Load " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            try {
                if (this.mEnforcedSchema != null) {
                    this.mSchema = this.mEnforcedSchema;
                    return this.mSchema;
                }
                if (null == this.mDeterminedSchema) {
                    this.mSchema = this.determineSchema();
                }
                if (this.mSchema == null) {
                    log.debug((Object)"Operator schema is null; Setting it to new schema");
                    this.mSchema = this.scriptSchema;
                } else {
                    log.debug((Object)"Reconciling schema");
                    log.debug((Object)("mSchema: " + this.mSchema + " schema: " + this.scriptSchema));
                    try {
                        this.mSchema = this.mSchema.mergePrefixSchema(this.scriptSchema, true, true);
                    }
                    catch (SchemaMergeException e) {
                        int errCode = 1019;
                        String msg = "Unable to merge schemas";
                        throw new FrontendException(msg, errCode, 2, false, null, e);
                    }
                }
                this.mIsSchemaComputed = true;
            }
            catch (IOException ioe) {
                int errCode = 1018;
                String msg = "Problem determining schema during load";
                FrontendException fee = new FrontendException(msg, errCode, 2, false, null, ioe);
                this.mIsSchemaComputed = false;
                this.mSchema = null;
                throw fee;
            }
            this.setParent(this.mSchema);
        }
        return this.mSchema;
    }

    private Schema determineSchema() throws IOException {
        if (!this.mDeterminedSchemaCached) {
            if (LoadMetadata.class.isAssignableFrom(this.mLoadFunc.getClass())) {
                LoadMetadata loadMetadata = (LoadMetadata)((Object)this.mLoadFunc);
                ResourceSchema rSchema = loadMetadata.getSchema(this.mInputFileSpec.getFileName(), new Job(this.conf));
                this.mDeterminedSchema = Schema.getPigSchema(rSchema);
            }
            this.mDeterminedSchemaCached = true;
            return this.mDeterminedSchema;
        }
        return this.mDeterminedSchema;
    }

    @Override
    public void setSchema(Schema schema) throws FrontendException {
        this.scriptSchema = schema;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    public Schema getEnforcedSchema() {
        return this.mEnforcedSchema;
    }

    public void setEnforcedSchema(Schema enforcedSchema) {
        this.mEnforcedSchema = enforcedSchema;
    }

    @Override
    public byte getType() {
        return 120;
    }

    public Schema getDeterminedSchema() {
        return this.mDeterminedSchema;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        }
        try {
            inputSchema = this.getSchema();
        }
        catch (IOException ioe) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (inputSchema == null && outputSchema != null) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        if (Schema.equals(inputSchema, outputSchema, false, true)) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        MultiMap<Integer, ProjectionMap.Column> mapFields = new MultiMap<Integer, ProjectionMap.Column>();
        for (int i = 0; i < inputSchema.size(); ++i) {
            mapFields.put((Integer)i, new ProjectionMap.Column(new Pair<Integer, Integer>(0, i)));
        }
        this.mProjectionMap = new ProjectionMap(mapFields, null, null);
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        requiredFields.add(new RequiredFields(false, true));
        return requiredFields;
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output != 0) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(true));
        return result;
    }

    public LoadPushDown.RequiredFieldResponse pushProjection(LoadPushDown.RequiredFieldList requiredFieldList) throws FrontendException {
        Integer index;
        int i;
        LoadPushDown.RequiredFieldResponse response = new LoadPushDown.RequiredFieldResponse(false);
        if (this.mSchema == null) {
            return response;
        }
        if (requiredFieldList.getFields() == null) {
            return response;
        }
        if (requiredFieldList.getFields() == null) {
            return response;
        }
        this.requiredFieldList = requiredFieldList;
        response = this.mLoadFunc instanceof LoadPushDown ? ((LoadPushDown)((Object)this.mLoadFunc)).pushProjection(requiredFieldList) : new LoadPushDown.RequiredFieldResponse(false);
        if (!response.getRequiredFieldResponse()) {
            return response;
        }
        TreeSet<Integer> prunedIndexSet = new TreeSet<Integer>();
        for (i = 0; i < this.mSchema.size(); ++i) {
            prunedIndexSet.add(i);
        }
        for (i = 0; i < requiredFieldList.getFields().size(); ++i) {
            LoadPushDown.RequiredField requiredField = requiredFieldList.getFields().get(i);
            if (requiredField.getIndex() >= 0) {
                prunedIndexSet.remove(requiredField.getIndex());
                continue;
            }
            try {
                int index2 = this.mSchema.getPosition(requiredField.getAlias());
                if (index2 <= 0) continue;
                prunedIndexSet.remove(index2);
                continue;
            }
            catch (FrontendException e) {
                return new LoadPushDown.RequiredFieldResponse(false);
            }
        }
        while ((index = (Integer)prunedIndexSet.pollLast()) != null) {
            this.mSchema.getFields().remove(index);
        }
        this.mIsProjectionMapComputed = false;
        this.getProjectionMap();
        return response;
    }

    @Override
    public void setAlias(String newAlias) {
        super.setAlias(newAlias);
        this.mLoadFunc.setUDFContextSignature(this.getAlias());
    }

    @Override
    public boolean pruneColumns(List<Pair<Integer, Integer>> columns) throws FrontendException {
        throw new FrontendException("Not implemented");
    }

    public LoadPushDown.RequiredFieldList getRequiredFieldList() {
        return this.requiredFieldList;
    }

    public Configuration getConfiguration() {
        return this.conf;
    }
}

