/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.logicalLayer;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.logicalLayer.LOVisitor;
import org.apache.pig.impl.logicalLayer.LogicalOperator;
import org.apache.pig.impl.logicalLayer.LogicalPlan;
import org.apache.pig.impl.logicalLayer.RelationalOperator;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.ProjectionMap;
import org.apache.pig.impl.plan.RequiredFields;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LOSplit
extends RelationalOperator {
    private static final long serialVersionUID = 2L;
    private ArrayList<LogicalOperator> mOutputs;
    private static Log log = LogFactory.getLog(LOSplit.class);

    public LOSplit(LogicalPlan plan, OperatorKey key, ArrayList<LogicalOperator> outputs) {
        super(plan, key);
        this.mOutputs = outputs;
    }

    public List<LogicalOperator> getOutputs() {
        return this.mOutputs;
    }

    public void setOutputs(ArrayList<LogicalOperator> outputs) {
        this.mOutputs = outputs;
    }

    public void addOutput(LogicalOperator lOp) {
        this.mOutputs.add(lOp);
    }

    @Override
    public String name() {
        return this.getAliasString() + "Split " + this.mKey.scope + "-" + this.mKey.id;
    }

    @Override
    public Schema getSchema() throws FrontendException {
        if (!this.mIsSchemaComputed) {
            List<LOSplit> s = this.mPlan.getPredecessors(this);
            try {
                LogicalOperator op = (LogicalOperator)s.iterator().next();
                if (null == op) {
                    int errCode = 1006;
                    String msg = "Could not find operator in plan";
                    throw new FrontendException(msg, errCode, 2, false, null);
                }
                LogicalOperator input = (LogicalOperator)s.iterator().next();
                this.mSchema = input.getSchema() != null ? Schema.copyAndLink(input.getSchema(), input) : null;
                this.mIsSchemaComputed = true;
            }
            catch (FrontendException ioe) {
                this.mSchema = null;
                this.mIsSchemaComputed = false;
                throw ioe;
            }
        }
        return this.mSchema;
    }

    @Override
    public boolean supportsMultipleInputs() {
        return false;
    }

    @Override
    public boolean supportsMultipleOutputs() {
        return true;
    }

    @Override
    public void visit(LOVisitor v) throws VisitorException {
        v.visit(this);
    }

    @Override
    public byte getType() {
        return 120;
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        LOSplit splitClone = (LOSplit)super.clone();
        return splitClone;
    }

    @Override
    public ProjectionMap getProjectionMap() {
        Schema outputSchema;
        if (this.mIsProjectionMapComputed) {
            return this.mProjectionMap;
        }
        this.mIsProjectionMapComputed = true;
        try {
            outputSchema = this.getSchema();
        }
        catch (FrontendException fee) {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        Schema inputSchema = null;
        ArrayList predecessors = (ArrayList)this.mPlan.getPredecessors(this);
        if (predecessors != null) {
            try {
                inputSchema = ((LogicalOperator)predecessors.get(0)).getSchema();
            }
            catch (FrontendException fee) {
                this.mProjectionMap = null;
                return this.mProjectionMap;
            }
        } else {
            this.mProjectionMap = null;
            return this.mProjectionMap;
        }
        if (Schema.equals(inputSchema, outputSchema, false, true)) {
            this.mProjectionMap = new ProjectionMap(false);
            return this.mProjectionMap;
        }
        this.mProjectionMap = null;
        return this.mProjectionMap;
    }

    @Override
    public List<RequiredFields> getRequiredFields() {
        ArrayList<RequiredFields> requiredFields = new ArrayList<RequiredFields>();
        requiredFields.add(new RequiredFields(false, true));
        return requiredFields;
    }

    @Override
    public void rewire(Operator<LOVisitor> oldPred, int oldPredIndex, Operator<LOVisitor> newPred, boolean useOldPred) throws PlanException {
        for (LogicalOperator logicalOperator : this.mPlan.getSuccessors(this)) {
            logicalOperator.rewire(oldPred, oldPredIndex, newPred, useOldPred);
        }
    }

    @Override
    public List<RequiredFields> getRelevantInputs(int output, int column) throws FrontendException {
        if (!this.mIsSchemaComputed) {
            this.getSchema();
        }
        if (output < 0) {
            return null;
        }
        List<LOSplit> successors = this.mPlan.getSuccessors(this);
        if (output >= successors.size()) {
            return null;
        }
        if (column < 0) {
            return null;
        }
        if (this.mSchema != null && column >= this.mSchema.size()) {
            return null;
        }
        ArrayList<Pair<Integer, Integer>> inputList = new ArrayList<Pair<Integer, Integer>>();
        inputList.add(new Pair<Integer, Integer>(0, column));
        ArrayList<RequiredFields> result = new ArrayList<RequiredFields>();
        result.add(new RequiredFields(inputList));
        return result;
    }
}

